/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.jdeqsim.SimUnit;

public abstract class Message
implements Comparable<Message> {
    protected static EventsManager eventsManager;
    private double messageArrivalTime = 0.0;
    private SimUnit receivingUnit;
    protected int priority = 0;
    private boolean isAlive = true;

    public static void setEventsManager(EventsManager eventsManager) {
        Message.eventsManager = eventsManager;
    }

    public double getMessageArrivalTime() {
        return this.messageArrivalTime;
    }

    public void setMessageArrivalTime(double messageArrivalTime) {
        this.messageArrivalTime = messageArrivalTime;
    }

    public abstract void processEvent();

    @Override
    public int compareTo(Message otherMessage) {
        if (this.messageArrivalTime > otherMessage.messageArrivalTime) {
            return 1;
        }
        if (this.messageArrivalTime < otherMessage.messageArrivalTime) {
            return -1;
        }
        return otherMessage.priority - this.priority;
    }

    public SimUnit getReceivingUnit() {
        return this.receivingUnit;
    }

    public void setReceivingUnit(SimUnit receivingUnit) {
        this.receivingUnit = receivingUnit;
    }

    public abstract void handleMessage();

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void killMessage() {
        this.isAlive = false;
    }

    public void reviveMessage() {
        this.isAlive = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }
}

