/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import java.util.LinkedList;
import org.matsim.core.mobsim.jdeqsim.DeadlockPreventionMessage;
import org.matsim.core.mobsim.jdeqsim.EndLegMessage;
import org.matsim.core.mobsim.jdeqsim.EndRoadMessage;
import org.matsim.core.mobsim.jdeqsim.EnterRoadMessage;
import org.matsim.core.mobsim.jdeqsim.JDEQSimConfigGroup;
import org.matsim.core.mobsim.jdeqsim.LeaveRoadMessage;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.StartingLegMessage;
import org.matsim.core.mobsim.jdeqsim.Vehicle;

public class MessageFactory {
    private static LinkedList<EndLegMessage> endLegMessageQueue = new LinkedList();
    private static LinkedList<EnterRoadMessage> enterRoadMessageQueue = new LinkedList();
    private static LinkedList<StartingLegMessage> startingLegMessageQueue = new LinkedList();
    private static LinkedList<LeaveRoadMessage> leaveRoadMessageQueue = new LinkedList();
    private static LinkedList<EndRoadMessage> endRoadMessageQueue = new LinkedList();
    private static LinkedList<DeadlockPreventionMessage> deadlockPreventionMessageQueue = new LinkedList();

    public static void disposeEndLegMessage(EndLegMessage message) {
        if (!JDEQSimConfigGroup.isGC_MESSAGES()) {
            endLegMessageQueue.add(message);
        }
    }

    public static void disposeEnterRoadMessage(EnterRoadMessage message) {
        if (!JDEQSimConfigGroup.isGC_MESSAGES()) {
            enterRoadMessageQueue.add(message);
        }
    }

    public static void disposeStartingLegMessage(StartingLegMessage message) {
        if (!JDEQSimConfigGroup.isGC_MESSAGES()) {
            startingLegMessageQueue.add(message);
        }
    }

    public static void disposeLeaveRoadMessage(LeaveRoadMessage message) {
        if (!JDEQSimConfigGroup.isGC_MESSAGES()) {
            leaveRoadMessageQueue.add(message);
        }
    }

    public static void disposeEndRoadMessage(EndRoadMessage message) {
        if (!JDEQSimConfigGroup.isGC_MESSAGES()) {
            endRoadMessageQueue.add(message);
        }
    }

    public static void disposeDeadlockPreventionMessage(DeadlockPreventionMessage message) {
        if (!JDEQSimConfigGroup.isGC_MESSAGES()) {
            deadlockPreventionMessageQueue.add(message);
        }
    }

    public static EndLegMessage getEndLegMessage(Scheduler scheduler, Vehicle vehicle) {
        if (endLegMessageQueue.size() == 0) {
            return new EndLegMessage(scheduler, vehicle);
        }
        EndLegMessage message = endLegMessageQueue.poll();
        message.resetMessage(scheduler, vehicle);
        return message;
    }

    public static EnterRoadMessage getEnterRoadMessage(Scheduler scheduler, Vehicle vehicle) {
        if (enterRoadMessageQueue.size() == 0) {
            return new EnterRoadMessage(scheduler, vehicle);
        }
        EnterRoadMessage message = enterRoadMessageQueue.poll();
        message.resetMessage(scheduler, vehicle);
        return message;
    }

    public static StartingLegMessage getStartingLegMessage(Scheduler scheduler, Vehicle vehicle) {
        if (startingLegMessageQueue.size() == 0) {
            return new StartingLegMessage(scheduler, vehicle);
        }
        StartingLegMessage message = startingLegMessageQueue.poll();
        message.resetMessage(scheduler, vehicle);
        return message;
    }

    public static LeaveRoadMessage getLeaveRoadMessage(Scheduler scheduler, Vehicle vehicle) {
        if (leaveRoadMessageQueue.size() == 0) {
            return new LeaveRoadMessage(scheduler, vehicle);
        }
        LeaveRoadMessage message = leaveRoadMessageQueue.poll();
        message.resetMessage(scheduler, vehicle);
        return message;
    }

    public static EndRoadMessage getEndRoadMessage(Scheduler scheduler, Vehicle vehicle) {
        if (endRoadMessageQueue.size() == 0) {
            return new EndRoadMessage(scheduler, vehicle);
        }
        EndRoadMessage message = endRoadMessageQueue.poll();
        message.resetMessage(scheduler, vehicle);
        return message;
    }

    public static DeadlockPreventionMessage getDeadlockPreventionMessage(Scheduler scheduler, Vehicle vehicle) {
        if (deadlockPreventionMessageQueue.size() == 0) {
            return new DeadlockPreventionMessage(scheduler, vehicle);
        }
        DeadlockPreventionMessage message = deadlockPreventionMessageQueue.poll();
        message.resetMessage(scheduler, vehicle);
        return message;
    }

    public static void GC_ALL_MESSAGES() {
        endLegMessageQueue = new LinkedList();
        enterRoadMessageQueue = new LinkedList();
        startingLegMessageQueue = new LinkedList();
        leaveRoadMessageQueue = new LinkedList();
        endRoadMessageQueue = new LinkedList();
        deadlockPreventionMessageQueue = new LinkedList();
    }

    public static LinkedList<EndLegMessage> getEndLegMessageQueue() {
        return endLegMessageQueue;
    }

    public static LinkedList<EnterRoadMessage> getEnterRoadMessageQueue() {
        return enterRoadMessageQueue;
    }

    public static LinkedList<StartingLegMessage> getStartingLegMessageQueue() {
        return startingLegMessageQueue;
    }

    public static LinkedList<LeaveRoadMessage> getLeaveRoadMessageQueue() {
        return leaveRoadMessageQueue;
    }

    public static LinkedList<EndRoadMessage> getEndRoadMessageQueue() {
        return endRoadMessageQueue;
    }

    public static LinkedList<DeadlockPreventionMessage> getDeadlockPreventionMessageQueue() {
        return deadlockPreventionMessageQueue;
    }
}

