/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import java.util.HashMap;
import java.util.LinkedList;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.mobsim.jdeqsim.DeadlockPreventionMessage;
import org.matsim.core.mobsim.jdeqsim.JDEQSimConfigGroup;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.SimUnit;
import org.matsim.core.mobsim.jdeqsim.Vehicle;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.misc.Time;

public class Road
extends SimUnit {
    protected static JDEQSimConfigGroup config = new JDEQSimConfigGroup();
    static HashMap<Id<Link>, Road> allRoads = null;
    protected Link link;
    private LinkedList<Double> gap;
    private LinkedList<Vehicle> interestedInEnteringRoad = new LinkedList();
    private double timeOfLastEnteringVehicle = Double.MIN_VALUE;
    protected double timeOfLastLeavingVehicle = Double.MIN_VALUE;
    private double inverseInFlowCapacity = 0.0;
    protected double inverseOutFlowCapacity = 0.0;
    protected int noOfCarsPromisedToEnterRoad = 0;
    private long maxNumberOfCarsOnRoad = 0L;
    private double gapTravelTime = 0.0;
    protected LinkedList<Vehicle> carsOnTheRoad = new LinkedList();
    protected LinkedList<Double> earliestDepartureTimeOfCar = new LinkedList();
    private LinkedList<DeadlockPreventionMessage> deadlockPreventionMessages = new LinkedList();

    public static void setConfig(JDEQSimConfigGroup config) {
        Road.config = config;
    }

    public static HashMap<Id<Link>, Road> getAllRoads() {
        return allRoads;
    }

    public static void setAllRoads(HashMap<Id<Link>, Road> allRoads) {
        Road.allRoads = allRoads;
    }

    public Road(Scheduler scheduler, Link link) {
        super(scheduler);
        this.link = link;
        this.maxNumberOfCarsOnRoad = Math.round(link.getLength() * (double)NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), link) * config.getStorageCapacityFactor() / config.getCarSize());
        if (this.maxNumberOfCarsOnRoad == 0L) {
            this.maxNumberOfCarsOnRoad = 1L;
        }
        double maxInverseInFlowCapacity = 3600.0 / (config.getMinimumInFlowCapacity() * config.getFlowCapacityFactor() * (double)NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), link));
        this.inverseOutFlowCapacity = 1.0 / (link.getFlowCapacityPerSec() * config.getFlowCapacityFactor());
        this.inverseInFlowCapacity = this.inverseOutFlowCapacity > maxInverseInFlowCapacity ? maxInverseInFlowCapacity : this.inverseOutFlowCapacity;
        this.gapTravelTime = link.getLength() / config.getGapTravelSpeed();
        this.gap = null;
    }

    public void leaveRoad(Vehicle vehicle, double simTime) {
        Vehicle nextVehicle;
        assert (this.carsOnTheRoad.getFirst() == vehicle);
        assert (this.interestedInEnteringRoad.size() == this.deadlockPreventionMessages.size());
        this.carsOnTheRoad.removeFirst();
        this.earliestDepartureTimeOfCar.removeFirst();
        this.timeOfLastLeavingVehicle = simTime;
        if (this.interestedInEnteringRoad.size() > 0) {
            nextVehicle = this.interestedInEnteringRoad.removeFirst();
            DeadlockPreventionMessage m3 = this.deadlockPreventionMessages.removeFirst();
            assert (m3.vehicle == nextVehicle);
            this.scheduler.unschedule(m3);
            double nextAvailableTimeForEnteringStreet = Math.max(this.timeOfLastEnteringVehicle + this.inverseInFlowCapacity, simTime + this.gapTravelTime);
            ++this.noOfCarsPromisedToEnterRoad;
            nextVehicle.scheduleEnterRoadMessage(nextAvailableTimeForEnteringStreet, this);
        } else if (this.gap != null) {
            this.gap.add(simTime + this.gapTravelTime);
            if (this.carsOnTheRoad.size() == 0) {
                this.gap = null;
            }
        }
        if (this.carsOnTheRoad.size() > 0) {
            nextVehicle = this.carsOnTheRoad.getFirst();
            double nextAvailableTimeForLeavingStreet = Math.max(this.earliestDepartureTimeOfCar.getFirst(), this.timeOfLastLeavingVehicle + this.inverseOutFlowCapacity);
            nextVehicle.scheduleEndRoadMessage(nextAvailableTimeForLeavingStreet, this);
        }
    }

    public void enterRoad(Vehicle vehicle, double simTime) {
        double nextAvailableTimeForLeavingStreet = simTime + this.link.getLength() / this.link.getFreespeed(simTime);
        --this.noOfCarsPromisedToEnterRoad;
        this.carsOnTheRoad.add(vehicle);
        this.earliestDepartureTimeOfCar.add(nextAvailableTimeForLeavingStreet);
        if (this.carsOnTheRoad.size() == 1) {
            nextAvailableTimeForLeavingStreet = Math.max(nextAvailableTimeForLeavingStreet, this.timeOfLastLeavingVehicle + this.inverseOutFlowCapacity);
            vehicle.scheduleEndRoadMessage(nextAvailableTimeForLeavingStreet, this);
        }
    }

    public void enterRequest(Vehicle vehicle, double simTime) {
        assert (this.interestedInEnteringRoad.size() == this.deadlockPreventionMessages.size());
        if ((long)(this.carsOnTheRoad.size() + this.noOfCarsPromisedToEnterRoad) < this.maxNumberOfCarsOnRoad) {
            double nextAvailableTimeForEnteringStreet;
            double arrivalTimeOfGap = Double.MIN_VALUE;
            if (this.gap != null && this.gap.size() > 0) {
                arrivalTimeOfGap = this.gap.remove();
            }
            ++this.noOfCarsPromisedToEnterRoad;
            this.timeOfLastEnteringVehicle = nextAvailableTimeForEnteringStreet = Math.max(Math.max(this.timeOfLastEnteringVehicle + this.inverseInFlowCapacity, simTime), arrivalTimeOfGap);
            vehicle.scheduleEnterRoadMessage(nextAvailableTimeForEnteringStreet, this);
        } else {
            if (this.gap == null) {
                this.gap = new LinkedList();
            } else {
                this.gap.clear();
            }
            this.interestedInEnteringRoad.add(vehicle);
            if (this.deadlockPreventionMessages.size() > 0) {
                this.deadlockPreventionMessages.add(vehicle.scheduleDeadlockPreventionMessage(this.deadlockPreventionMessages.getLast().getMessageArrivalTime() + config.getSqueezeTime(), this));
            } else {
                this.deadlockPreventionMessages.add(vehicle.scheduleDeadlockPreventionMessage(simTime + config.getSqueezeTime(), this));
            }
            assert (this.interestedInEnteringRoad.size() == this.deadlockPreventionMessages.size()) : this.interestedInEnteringRoad.size() + " - " + this.deadlockPreventionMessages.size();
        }
    }

    public void giveBackPromisedSpaceToRoad() {
        --this.noOfCarsPromisedToEnterRoad;
    }

    public void incrementPromisedToEnterRoad() {
        ++this.noOfCarsPromisedToEnterRoad;
    }

    public Link getLink() {
        return this.link;
    }

    public void setTimeOfLastEnteringVehicle(double timeOfLastEnteringVehicle) {
        this.timeOfLastEnteringVehicle = timeOfLastEnteringVehicle;
    }

    public void removeFirstDeadlockPreventionMessage(DeadlockPreventionMessage dpMessage) {
        assert (this.deadlockPreventionMessages.getFirst() == dpMessage) : "Inconsitency in logic!!! => this should only be invoked from the handler of this message";
        this.deadlockPreventionMessages.removeFirst();
    }

    public void removeFromInterestedInEnteringRoad() {
        this.interestedInEnteringRoad.removeFirst();
        assert (this.interestedInEnteringRoad.size() == this.deadlockPreventionMessages.size());
    }

    public static Road getRoad(Id<Link> linkId) {
        return Road.getAllRoads().get(linkId);
    }
}

