/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import org.apache.log4j.Logger;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.jdeqsim.Message;
import org.matsim.core.mobsim.jdeqsim.MessageQueue;

public class Scheduler {
    private static final Logger log = Logger.getLogger(Scheduler.class);
    private double simTime = 0.0;
    protected final MessageQueue queue;
    private double simulationStartTime = System.currentTimeMillis();
    private final double simulationEndTime;
    private double hourlyLogTime = 3600.0;

    public Scheduler(MessageQueue queue) {
        this(queue, Double.MAX_VALUE);
    }

    public Scheduler(MessageQueue messageQueue, double simulationEndTime) {
        this.queue = messageQueue;
        this.simulationEndTime = simulationEndTime;
    }

    public void schedule(Message m3) {
        this.queue.putMessage(m3);
    }

    public void unschedule(Message m3) {
        this.queue.removeMessage(m3);
    }

    public void startSimulation() {
        while (!this.queue.isEmpty() && this.simTime < this.simulationEndTime) {
            Message m3 = this.queue.getNextMessage();
            if (m3 != null) {
                this.simTime = m3.getMessageArrivalTime();
                m3.processEvent();
                m3.handleMessage();
            }
            this.printLog();
        }
    }

    public double getSimTime() {
        return this.simTime;
    }

    private void printLog() {
        if (this.simTime / this.hourlyLogTime > 1.0) {
            this.hourlyLogTime = this.simTime + 3600.0;
            log.info("Simulation at " + this.simTime / 3600.0 + "[h]; s/r:" + this.simTime / ((double)System.currentTimeMillis() - this.simulationStartTime) * 1000.0);
            Gbl.printMemoryUsage();
        }
    }
}

