/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.core.mobsim.jdeqsim.EventMessage;
import org.matsim.core.mobsim.jdeqsim.Road;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.Vehicle;

public class StartingLegMessage
extends EventMessage {
    public StartingLegMessage(Scheduler scheduler, Vehicle vehicle) {
        super(scheduler, vehicle);
        this.priority = 125;
    }

    @Override
    public void handleMessage() {
        if (this.vehicle.getCurrentLeg().getMode().equals("car")) {
            if (this.vehicle.getCurrentLinkRoute().length == 0) {
                this.scheduleEndLegMessage(this.getMessageArrivalTime());
            } else {
                Road road = Road.getRoad(this.vehicle.getCurrentLinkId());
                road.enterRequest(this.vehicle, this.getMessageArrivalTime());
            }
        } else {
            this.scheduleEndLegMessage(this.getMessageArrivalTime() + this.vehicle.getCurrentLeg().getTravelTime());
        }
    }

    private void scheduleEndLegMessage(double time) {
        this.vehicle.moveToFirstLinkInNextLeg();
        Road road = Road.getRoad(this.vehicle.getCurrentLinkId());
        this.vehicle.scheduleEndLegMessage(time, road);
    }

    @Override
    public void processEvent() {
        Event event = new ActivityEndEvent(this.getMessageArrivalTime(), this.vehicle.getOwnerPerson().getId(), this.vehicle.getCurrentLinkId(), this.vehicle.getPreviousActivity().getFacilityId(), this.vehicle.getPreviousActivity().getType());
        eventsManager.processEvent(event);
        event = new PersonDepartureEvent(this.getMessageArrivalTime(), this.vehicle.getOwnerPerson().getId(), this.vehicle.getCurrentLinkId(), this.vehicle.getCurrentLeg().getMode());
        eventsManager.processEvent(event);
    }
}

