/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.mobsim.jdeqsim.DeadlockPreventionMessage;
import org.matsim.core.mobsim.jdeqsim.MessageFactory;
import org.matsim.core.mobsim.jdeqsim.Road;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.SimUnit;
import org.matsim.core.population.routes.NetworkRoute;

public class Vehicle
extends SimUnit {
    private static final Logger log = Logger.getLogger(Vehicle.class);
    private Person ownerPerson = null;
    private Leg currentLeg = null;
    private int legIndex;
    private Id<Link> currentLinkId = null;
    private int linkIndex;
    private Id<Link>[] currentLinkRoute = null;
    private final PlansConfigGroup.ActivityDurationInterpretation activityEndTimeInterpretation;

    public Vehicle(Scheduler scheduler, Person ownerPerson, PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation) {
        super(scheduler);
        this.ownerPerson = ownerPerson;
        this.activityEndTimeInterpretation = activityDurationInterpretation;
        this.initialize();
    }

    public void initialize() {
        this.linkIndex = -1;
        if (this.ownerPerson.getSelectedPlan() == null) {
            return;
        }
        Plan plan = (Plan)this.ownerPerson.getSelectedPlan();
        List<PlanElement> actsLegs = plan.getPlanElements();
        if (actsLegs.size() <= 1) {
            return;
        }
        this.legIndex = 1;
        this.setCurrentLeg((Leg)actsLegs.get(this.legIndex));
        Activity firstAct = (Activity)actsLegs.get(0);
        double departureTime = firstAct.getEndTime();
        this.setCurrentLinkId(firstAct.getLinkId());
        Road road = Road.getRoad(this.getCurrentLinkId());
        this.scheduleStartingLegMessage(departureTime, road);
    }

    public Activity getPreviousActivity() {
        Plan plan = (Plan)this.ownerPerson.getSelectedPlan();
        List<PlanElement> actsLegs = plan.getPlanElements();
        for (int i = 0; i < actsLegs.size(); ++i) {
            if (actsLegs.get(i) != this.currentLeg) continue;
            return (Activity)actsLegs.get(i - 1);
        }
        return null;
    }

    public Activity getNextActivity() {
        Plan plan = (Plan)this.ownerPerson.getSelectedPlan();
        List<PlanElement> actsLegs = plan.getPlanElements();
        for (int i = 0; i < actsLegs.size(); ++i) {
            if (actsLegs.get(i) != this.currentLeg) continue;
            return (Activity)actsLegs.get(i + 1);
        }
        return null;
    }

    public void setCurrentLeg(Leg currentLeg) {
        this.currentLeg = currentLeg;
        if (currentLeg.getRoute() instanceof NetworkRoute) {
            List<Id<Link>> linkIds = ((NetworkRoute)currentLeg.getRoute()).getLinkIds();
            this.currentLinkRoute = linkIds.toArray(new Id[linkIds.size()]);
        } else {
            this.currentLinkRoute = null;
        }
    }

    protected Id<Link>[] getCurrentLinkRoute() {
        return this.currentLinkRoute;
    }

    public void setLegIndex(int legIndex) {
        this.legIndex = legIndex;
    }

    public Person getOwnerPerson() {
        return this.ownerPerson;
    }

    public Leg getCurrentLeg() {
        return this.currentLeg;
    }

    public int getLegIndex() {
        return this.legIndex;
    }

    public Id<Link> getCurrentLinkId() {
        return this.currentLinkId;
    }

    public int getLinkIndex() {
        return this.linkIndex;
    }

    public void setCurrentLinkId(Id<Link> currentLinkId) {
        this.currentLinkId = currentLinkId;
    }

    public void setLinkIndex(int linkIndex) {
        this.linkIndex = linkIndex;
    }

    public boolean isCurrentLegFinished() {
        return this.getCurrentLinkRoute().length == this.getLinkIndex() + 1;
    }

    public void moveToNextLinkInLeg() {
        this.setLinkIndex(this.getLinkIndex() + 1);
        this.setCurrentLinkId(this.getCurrentLinkRoute()[this.getLinkIndex()]);
    }

    public void moveToFirstLinkInNextLeg() {
        Plan plan = (Plan)this.getOwnerPerson().getSelectedPlan();
        List<PlanElement> actsLegs = plan.getPlanElements();
        this.setCurrentLinkId(((Activity)actsLegs.get(this.getLegIndex() + 1)).getLinkId());
    }

    public boolean isEndingLegMode() {
        return this.getCurrentLinkRoute().length == this.getLinkIndex();
    }

    public void initiateEndingLegMode() {
        this.linkIndex = this.getCurrentLinkRoute().length;
    }

    public void scheduleEnterRoadMessage(double scheduleTime, Road road) {
        if (this.getLinkIndex() >= 0) {
            this.scheduleLeavePreviousRoadMessage(scheduleTime);
        }
        if (this.isEndingLegMode()) {
            road.giveBackPromisedSpaceToRoad();
            this.scheduleEndLegMessage(scheduleTime, road);
        } else {
            this._scheduleEnterRoadMessage(scheduleTime, road);
        }
    }

    public void scheduleLeavePreviousRoadMessage(double scheduleTime) {
        Road previousRoad = null;
        Id<Link> previousLinkId = null;
        if (this.getLinkIndex() == 0) {
            Plan plan = (Plan)this.ownerPerson.getSelectedPlan();
            List<PlanElement> actsLegs = plan.getPlanElements();
            previousLinkId = ((Activity)actsLegs.get(this.legIndex - 1)).getLinkId();
            previousRoad = Road.getRoad(previousLinkId);
        } else if (this.getLinkIndex() >= 1) {
            previousLinkId = this.getCurrentLinkRoute()[this.getLinkIndex() - 1];
            previousRoad = Road.getRoad(previousLinkId);
        } else {
            log.error("Some thing is wrong with the simulation: Why is this.getLinkIndex() negative");
        }
        this.scheduleLeaveRoadMessage(scheduleTime, previousRoad);
    }

    protected void _scheduleEnterRoadMessage(double scheduleTime, Road road) {
        this.sendMessage(MessageFactory.getEnterRoadMessage(road.scheduler, this), road, scheduleTime);
    }

    public void scheduleEndRoadMessage(double scheduleTime, Road road) {
        this.sendMessage(MessageFactory.getEndRoadMessage(road.scheduler, this), road, scheduleTime);
    }

    public void scheduleLeaveRoadMessage(double scheduleTime, Road road) {
        this.sendMessage(MessageFactory.getLeaveRoadMessage(road.scheduler, this), road, scheduleTime);
    }

    public void scheduleEndLegMessage(double scheduleTime, Road road) {
        this.sendMessage(MessageFactory.getEndLegMessage(road.scheduler, this), road, scheduleTime);
    }

    public void scheduleStartingLegMessage(double scheduleTime, Road road) {
        this.sendMessage(MessageFactory.getStartingLegMessage(road.scheduler, this), road, scheduleTime);
    }

    public DeadlockPreventionMessage scheduleDeadlockPreventionMessage(double scheduleTime, Road road) {
        DeadlockPreventionMessage dpMessage = MessageFactory.getDeadlockPreventionMessage(road.scheduler, this);
        this.sendMessage(dpMessage, road, scheduleTime);
        return dpMessage;
    }

    public PlansConfigGroup.ActivityDurationInterpretation getActivityEndTimeInterpretation() {
        return this.activityEndTimeInterpretation;
    }
}

