/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.mobsim.jdeqsim.EventLog;
import org.matsim.core.utils.io.IOUtils;

public class CppEventFileParser {
    public static void main(String[] args) {
        String eventFileName = args[0];
        CppEventFileParser eventFileParser = new CppEventFileParser();
        eventFileParser.parse(eventFileName);
    }

    public void parse(String eventFileName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<EventLog> parseFile(String filePath) {
        int counter = 0;
        ArrayList<EventLog> rows = new ArrayList<EventLog>();
        BufferedReader br = null;
        try {
            br = IOUtils.getBufferedReader(filePath);
            String line = null;
            StringTokenizer tokenizer = null;
            line = br.readLine();
            while (line != null) {
                if (++counter % 1000000 == 0) {
                    System.out.println("noOfLines Read:" + counter);
                }
                tokenizer = new StringTokenizer(line);
                String token = null;
                token = tokenizer.nextToken();
                double first = Double.parseDouble(token);
                token = tokenizer.nextToken();
                int second = Integer.parseInt(token);
                token = tokenizer.nextToken();
                int third = Integer.parseInt(token);
                token = tokenizer.nextToken();
                int fourth = Integer.parseInt(token);
                token = tokenizer.nextToken();
                int fifth = Integer.parseInt(token);
                token = tokenizer.nextToken();
                int sixth = Integer.parseInt(token);
                String eventType = token = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    eventType = eventType + " " + token;
                }
                if (eventType.equalsIgnoreCase("starting")) {
                    eventType = "start leg";
                } else if (eventType.equalsIgnoreCase("end")) {
                    eventType = "end leg";
                } else if (eventType.equalsIgnoreCase("enter")) {
                    eventType = "enter link";
                } else if (eventType.equalsIgnoreCase("leave")) {
                    eventType = "leave link";
                }
                if (!eventType.equalsIgnoreCase("enter net")) {
                    rows.add(new EventLog(first, second, third, fourth, fifth, sixth, eventType));
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }

    @Deprecated
    public static boolean equals(Event personEvent, Id<Person> personId, EventLog deqSimEvent) {
        return CppEventFileParser.equals(personEvent, deqSimEvent);
    }

    public static boolean equals(Event personEvent, EventLog deqSimEvent) {
        if (personEvent.getTime() != deqSimEvent.getTime()) {
            CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
            return false;
        }
        if (personEvent instanceof PersonDepartureEvent) {
            if (Integer.parseInt(((PersonDepartureEvent)personEvent).getLinkId().toString()) != deqSimEvent.getLinkId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (Integer.parseInt(((PersonDepartureEvent)personEvent).getPersonId().toString()) != deqSimEvent.getVehicleId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (!deqSimEvent.getType().equalsIgnoreCase("start leg")) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
        }
        if (personEvent instanceof LinkEnterEvent) {
            if (Integer.parseInt(((LinkEnterEvent)personEvent).getLinkId().toString()) != deqSimEvent.getLinkId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (Integer.parseInt(((LinkEnterEvent)personEvent).getVehicleId().toString()) != deqSimEvent.getVehicleId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (!deqSimEvent.getType().equalsIgnoreCase("enter link")) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
        }
        if (personEvent instanceof LinkLeaveEvent) {
            if (Integer.parseInt(((LinkLeaveEvent)personEvent).getLinkId().toString()) != deqSimEvent.getLinkId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (Integer.parseInt(((LinkLeaveEvent)personEvent).getVehicleId().toString()) != deqSimEvent.getVehicleId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (!deqSimEvent.getType().equalsIgnoreCase("leave link")) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
        }
        if (personEvent instanceof PersonArrivalEvent) {
            if (Integer.parseInt(((PersonArrivalEvent)personEvent).getLinkId().toString()) != deqSimEvent.getLinkId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (Integer.parseInt(((PersonArrivalEvent)personEvent).getPersonId().toString()) != deqSimEvent.getVehicleId()) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
            if (!deqSimEvent.getType().equalsIgnoreCase("end leg")) {
                CppEventFileParser.printNotEqualEvents(personEvent, deqSimEvent);
                return false;
            }
        }
        return true;
    }

    private static void printNotEqualEvents(Event personEvent, EventLog deqSimEvent) {
        System.out.println("POSSIBLE PROBLEM: EVENTS NOT EQUAL");
        System.out.println(personEvent.toString());
        deqSimEvent.print();
    }
}

