/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.ActivityEngine;
import org.matsim.core.mobsim.qsim.AgentCounter;
import org.matsim.core.mobsim.qsim.InternalInterface;

public class ActivityEngineDefaultImpl
implements ActivityEngine {
    private static final Logger log = Logger.getLogger(ActivityEngineDefaultImpl.class);
    private EventsManager eventsManager;
    private InternalInterface internalInterface;
    private final Queue<AgentEntry> activityEndsList = new PriorityBlockingQueue<AgentEntry>(500, new Comparator<AgentEntry>(){

        @Override
        public int compare(AgentEntry arg0, AgentEntry arg1) {
            int cmp = Double.compare(arg0.activityEndTime, arg1.activityEndTime);
            if (cmp == 0) {
                return arg1.agent.getId().compareTo(arg0.agent.getId());
            }
            return cmp;
        }
    });
    private boolean beforeFirstSimStep = true;

    @Inject
    public ActivityEngineDefaultImpl(EventsManager eventsManager) {
        this.eventsManager = eventsManager;
    }

    public ActivityEngineDefaultImpl(EventsManager eventsManager, org.matsim.core.mobsim.qsim.interfaces.AgentCounter agentCounter) {
        this.eventsManager = eventsManager;
    }

    @Override
    public void onPrepareSim() {
    }

    @Override
    public void doSimStep(double time) {
        this.beforeFirstSimStep = false;
        while (this.activityEndsList.peek() != null) {
            if (this.activityEndsList.peek().activityEndTime <= time) {
                MobsimAgent agent = this.activityEndsList.poll().agent;
                this.unregisterAgentAtActivityLocation(agent);
                agent.endActivityAndComputeNextState(time);
                this.internalInterface.arrangeNextAgentState(agent);
                continue;
            }
            return;
        }
    }

    @Override
    public void afterSim() {
        double now = this.internalInterface.getMobsim().getSimTimer().getTimeOfDay();
        for (AgentEntry entry : this.activityEndsList) {
            if (entry.activityEndTime == Double.POSITIVE_INFINITY || entry.activityEndTime == Double.NEGATIVE_INFINITY) continue;
            this.eventsManager.processEvent(new PersonStuckEvent(now, entry.agent.getId(), null, null));
        }
        this.activityEndsList.clear();
    }

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.internalInterface = internalInterface;
    }

    @Override
    public boolean handleActivity(MobsimAgent agent) {
        if (agent.getActivityEndTime() == Double.POSITIVE_INFINITY) {
            this.internalInterface.getMobsim().getAgentCounter().decLiving();
        } else if (agent.getActivityEndTime() <= this.internalInterface.getMobsim().getSimTimer().getTimeOfDay() && !this.beforeFirstSimStep) {
            agent.endActivityAndComputeNextState(this.internalInterface.getMobsim().getSimTimer().getTimeOfDay());
            this.internalInterface.arrangeNextAgentState(agent);
        } else {
            AgentEntry agentEntry = new AgentEntry(agent, agent.getActivityEndTime());
            this.activityEndsList.add(agentEntry);
            this.internalInterface.registerAdditionalAgentOnLink(agent);
        }
        return true;
    }

    @Override
    public void rescheduleActivityEnd(MobsimAgent agent) {
        if (agent.getState() != MobsimAgent.State.ACTIVITY) {
            return;
        }
        double newActivityEndTime = agent.getActivityEndTime();
        AgentEntry oldEntry = this.removeAgentFromQueue(agent);
        if (oldEntry == null) {
            if (newActivityEndTime != Double.POSITIVE_INFINITY) {
                this.activityEndsList.add(new AgentEntry(agent, newActivityEndTime));
                this.internalInterface.registerAdditionalAgentOnLink(agent);
                ((AgentCounter)this.internalInterface.getMobsim().getAgentCounter()).incLiving();
            }
        } else if (newActivityEndTime == Double.POSITIVE_INFINITY) {
            this.unregisterAgentAtActivityLocation(agent);
            this.internalInterface.getMobsim().getAgentCounter().decLiving();
        } else {
            this.activityEndsList.add(new AgentEntry(agent, newActivityEndTime));
        }
    }

    private AgentEntry removeAgentFromQueue(MobsimAgent agent) {
        Iterator iterator = this.activityEndsList.iterator();
        while (iterator.hasNext()) {
            AgentEntry entry = (AgentEntry)iterator.next();
            if (entry.agent != agent) continue;
            iterator.remove();
            return entry;
        }
        return null;
    }

    private void unregisterAgentAtActivityLocation(MobsimAgent agent) {
        Id<Person> agentId = agent.getId();
        Id<Link> linkId = agent.getCurrentLinkId();
        if (linkId != null) {
            this.internalInterface.unregisterAdditionalAgentOnLink(agentId, linkId);
        }
    }

    private static class AgentEntry {
        final MobsimAgent agent;
        final double activityEndTime;

        public AgentEntry(MobsimAgent agent, double activityEndTime) {
            this.agent = agent;
            this.activityEndTime = activityEndTime;
        }
    }
}

