/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.inject.Inject;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.internal.HasPersonId;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.ActivityEngine;
import org.matsim.core.mobsim.qsim.ActivityEngineDefaultImpl;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.PreplanningEngine;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;

public final class ActivityEngineWithWakeup
implements ActivityEngine {
    public static final String PREBOOKING_OFFSET_ATTRIBUTE_NAME = "prebookingOffset_s";
    private final EventsManager eventsManager;
    private PreplanningEngine preplanningEngine;
    private ActivityEngine delegate;
    private final Queue<AgentEntry> wakeUpList = new PriorityBlockingQueue<AgentEntry>(500, (o1, o2) -> {
        int cmp = Double.compare(o1.time, o2.time);
        return cmp != 0 ? cmp : o1.agent.getId().compareTo(o2.agent.getId());
    });
    private InternalInterface internalInterface;

    @Inject
    ActivityEngineWithWakeup(EventsManager eventsManager, PreplanningEngine preplanningEngine) {
        this.delegate = new ActivityEngineDefaultImpl(eventsManager);
        this.eventsManager = eventsManager;
        this.preplanningEngine = preplanningEngine;
    }

    @Override
    public void onPrepareSim() {
        this.delegate.onPrepareSim();
    }

    @Override
    public void doSimStep(double now) {
        while (!this.wakeUpList.isEmpty() && this.wakeUpList.peek().time <= now) {
            AgentEntry entry = this.wakeUpList.poll();
            this.eventsManager.processEvent(new AgentWakeupEvent(now, entry.agent.getId()));
            entry.agentWakeup.wakeUp(entry.agent, now);
        }
        this.delegate.doSimStep(now);
    }

    @Override
    public void afterSim() {
        this.delegate.afterSim();
    }

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.internalInterface = internalInterface;
        this.delegate.setInternalInterface(internalInterface);
    }

    @Override
    public boolean handleActivity(MobsimAgent agent) {
        double now = this.internalInterface.getMobsim().getSimTimer().getTimeOfDay();
        Activity act = (Activity)WithinDayAgentUtils.getCurrentPlanElement(agent);
        if (!act.getType().contains("interaction")) {
            this.wakeUpList.addAll(this.preplanningEngine.generateWakeups(agent, now));
        }
        return this.delegate.handleActivity(agent);
    }

    @Override
    public void rescheduleActivityEnd(MobsimAgent agent) {
        this.delegate.rescheduleActivityEnd(agent);
    }

    public static final class AgentWakeupEvent
    extends Event
    implements HasPersonId {
        private final Id<Person> personId;

        public AgentWakeupEvent(double now, Id<Person> personId) {
            super(now);
            this.personId = personId;
        }

        @Override
        public String getEventType() {
            return "agentWakeup";
        }

        @Override
        public Id<Person> getPersonId() {
            return this.personId;
        }

        @Override
        public Map<String, String> getAttributes() {
            Map<String, String> attr = super.getAttributes();
            attr.put("person", this.personId.toString());
            return attr;
        }
    }

    static class AgentEntry {
        final MobsimAgent agent;
        final double time;
        final AgentWakeup agentWakeup;

        public AgentEntry(MobsimAgent agent, double time, AgentWakeup agentWakeup) {
            this.agent = agent;
            this.time = time;
            this.agentWakeup = agentWakeup;
        }
    }

    public static interface AgentWakeup {
        public void wakeUp(MobsimAgent var1, double var2);
    }
}

