/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.experimental.events.TeleportationArrivalEvent;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.TeleportationEngine;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.facilities.Facility;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.TeleportationVisData;

public final class DefaultTeleportationEngine
implements TeleportationEngine {
    private static final Logger log = Logger.getLogger(DefaultTeleportationEngine.class);
    private final Queue<Tuple<Double, MobsimAgent>> teleportationList = new PriorityQueue<Tuple<Double, MobsimAgent>>(30, new Comparator<Tuple<Double, MobsimAgent>>(){

        @Override
        public int compare(Tuple<Double, MobsimAgent> o1, Tuple<Double, MobsimAgent> o2) {
            int ret = o1.getFirst().compareTo(o2.getFirst());
            if (ret == 0) {
                ret = o2.getSecond().getId().compareTo(o1.getSecond().getId());
            }
            return ret;
        }
    });
    private final LinkedHashMap<Id<Person>, TeleportationVisData> teleportationData = new LinkedHashMap();
    private InternalInterface internalInterface;
    private Scenario scenario;
    private EventsManager eventsManager;
    private final boolean withTravelTimeCheck;

    @Inject
    public DefaultTeleportationEngine(Scenario scenario, EventsManager eventsManager) {
        this.scenario = scenario;
        this.eventsManager = eventsManager;
        this.withTravelTimeCheck = scenario.getConfig().qsim().isUsingTravelTimeCheckInTeleportation();
    }

    @Override
    public boolean handleDeparture(double now, MobsimAgent agent, Id<Link> linkId) {
        if (agent.getExpectedTravelTime() == null || agent.getExpectedTravelTime() == Double.NEGATIVE_INFINITY) {
            Logger.getLogger(this.getClass()).info("mode: " + agent.getMode());
            throw new RuntimeException("teleportation does not work when travel time is undefined.  There is also really no magic fix for this, since we cannot guess travel times for arbitrary modes and arbitrary landscapes.  kai/mz, apr'15 & feb'16");
        }
        Double travelTime = agent.getExpectedTravelTime();
        if (this.withTravelTimeCheck) {
            Double speed = this.scenario.getConfig().plansCalcRoute().getTeleportedModeSpeeds().get(agent.getMode());
            Facility dpfac = agent.getCurrentFacility();
            Facility arfac = agent.getDestinationFacility();
            travelTime = DefaultTeleportationEngine.travelTimeCheck(travelTime, speed, dpfac, arfac);
        }
        double arrivalTime = now + travelTime;
        this.teleportationList.add(new Tuple<Double, MobsimAgent>(arrivalTime, agent));
        Id<Person> agentId = agent.getId();
        Link currLink = this.scenario.getNetwork().getLinks().get(linkId);
        Link destLink = this.scenario.getNetwork().getLinks().get(agent.getDestinationLinkId());
        Coord fromCoord = currLink.getToNode().getCoord();
        Coord toCoord = destLink.getToNode().getCoord();
        TeleportationVisData agentInfo = new TeleportationVisData(now, agentId, fromCoord, toCoord, travelTime);
        this.teleportationData.put(agentId, agentInfo);
        return true;
    }

    @Override
    public Collection<AgentSnapshotInfo> addAgentSnapshotInfo(Collection<AgentSnapshotInfo> snapshotList) {
        double time = this.internalInterface.getMobsim().getSimTimer().getTimeOfDay();
        for (TeleportationVisData teleportationVisData : this.teleportationData.values()) {
            teleportationVisData.updatePosition(time);
            snapshotList.add(teleportationVisData);
        }
        return snapshotList;
    }

    @Override
    public void doSimStep(double time) {
        this.handleTeleportationArrivals();
    }

    private void handleTeleportationArrivals() {
        Tuple<Double, MobsimAgent> entry;
        double now = this.internalInterface.getMobsim().getSimTimer().getTimeOfDay();
        while (this.teleportationList.peek() != null && (entry = this.teleportationList.peek()).getFirst() <= now) {
            this.teleportationList.poll();
            MobsimAgent personAgent = entry.getSecond();
            personAgent.notifyArrivalOnLinkByNonNetworkMode(personAgent.getDestinationLinkId());
            double distance = personAgent.getExpectedTravelDistance();
            this.eventsManager.processEvent(new TeleportationArrivalEvent(this.internalInterface.getMobsim().getSimTimer().getTimeOfDay(), personAgent.getId(), distance));
            personAgent.endLegAndComputeNextState(now);
            this.teleportationData.remove(personAgent.getId());
            this.internalInterface.arrangeNextAgentState(personAgent);
        }
    }

    @Override
    public void onPrepareSim() {
    }

    @Override
    public void afterSim() {
        double now = this.internalInterface.getMobsim().getSimTimer().getTimeOfDay();
        for (Tuple tuple : this.teleportationList) {
            MobsimAgent agent = (MobsimAgent)tuple.getSecond();
            this.eventsManager.processEvent(new PersonStuckEvent(now, agent.getId(), agent.getDestinationLinkId(), agent.getMode()));
        }
        this.teleportationList.clear();
    }

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.internalInterface = internalInterface;
    }

    private static Double travelTimeCheck(Double travelTime, Double speed, Facility dpfac, Facility arfac) {
        Coord arCoord;
        if (speed == null) {
            return travelTime;
        }
        if (dpfac == null || arfac == null) {
            log.warn("dpfac = " + dpfac);
            log.warn("arfac = " + arfac);
            throw new RuntimeException("have bushwhacking mode but nothing that leads to coordinates; don't know what to do ...");
        }
        if (dpfac.getCoord() == null || arfac.getCoord() == null) {
            return travelTime;
        }
        Coord dpCoord = dpfac.getCoord();
        double dist = NetworkUtils.getEuclideanDistance(dpCoord, arCoord = arfac.getCoord());
        double travelTimeTmp = dist / speed;
        if (travelTimeTmp < travelTime) {
            return travelTime;
        }
        return travelTimeTmp;
    }
}

