/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimManager;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeCleanupEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimInitializedEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeCleanupListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimInitializedListener;
import org.matsim.core.mobsim.framework.listeners.MobsimListener;
import org.matsim.core.utils.misc.ClassUtils;

class MobsimListenerManager
implements MatsimManager {
    private static final Logger log = Logger.getLogger(MobsimListenerManager.class);
    private final Mobsim sim;
    private final EventListenerList listenerList = new EventListenerList();

    public MobsimListenerManager(Mobsim sim) {
        this.sim = sim;
    }

    public void addQueueSimulationListener(MobsimListener l) {
        log.info("calling addQueueSimulationListener");
        for (Class<?> interfaceClass : ClassUtils.getAllTypes(l.getClass())) {
            if (!MobsimListener.class.isAssignableFrom(interfaceClass)) continue;
            this.listenerList.add(interfaceClass, l);
            log.info("  assigned class " + MobsimListener.class.getName() + " to interface " + interfaceClass.getName());
        }
    }

    public void removeQueueSimulationListener(MobsimListener l) {
        for (Class<?> interfaceClass : ClassUtils.getAllTypes(l.getClass())) {
            if (!MobsimListener.class.isAssignableFrom(interfaceClass)) continue;
            this.listenerList.remove(interfaceClass, l);
        }
    }

    public void fireQueueSimulationInitializedEvent() {
        MobsimInitializedListener[] listener;
        MobsimInitializedEvent<Mobsim> event = new MobsimInitializedEvent<Mobsim>(this.sim);
        for (MobsimInitializedListener aListener : listener = (MobsimInitializedListener[])this.listenerList.getListeners(MobsimInitializedListener.class)) {
            aListener.notifyMobsimInitialized(event);
        }
    }

    public void fireQueueSimulationAfterSimStepEvent(double simTime) {
        MobsimAfterSimStepListener[] listener;
        MobsimAfterSimStepEvent<Mobsim> event = new MobsimAfterSimStepEvent<Mobsim>(this.sim, simTime);
        for (MobsimAfterSimStepListener aListener : listener = (MobsimAfterSimStepListener[])this.listenerList.getListeners(MobsimAfterSimStepListener.class)) {
            aListener.notifyMobsimAfterSimStep(event);
        }
    }

    public void fireQueueSimulationBeforeCleanupEvent() {
        MobsimBeforeCleanupListener[] listener;
        MobsimBeforeCleanupEvent<Mobsim> event = new MobsimBeforeCleanupEvent<Mobsim>(this.sim);
        for (MobsimBeforeCleanupListener aListener : listener = (MobsimBeforeCleanupListener[])this.listenerList.getListeners(MobsimBeforeCleanupListener.class)) {
            aListener.notifyMobsimBeforeCleanup(event);
        }
    }

    public void fireQueueSimulationBeforeSimStepEvent(double time) {
        MobsimBeforeSimStepListener[] listener;
        MobsimBeforeSimStepEvent<Mobsim> event = new MobsimBeforeSimStepEvent<Mobsim>(this.sim, time);
        for (MobsimBeforeSimStepListener aListener : listener = (MobsimBeforeSimStepListener[])this.listenerList.getListeners(MobsimBeforeSimStepListener.class)) {
            aListener.notifyMobsimBeforeSimStep(event);
        }
    }
}

