/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimPassengerAgent;
import org.matsim.core.mobsim.framework.PlanAgent;
import org.matsim.core.mobsim.qsim.ActivityEngineWithWakeup;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.agents.HasModifiablePlan;
import org.matsim.core.mobsim.qsim.agents.WithinDayAgentUtils;
import org.matsim.core.mobsim.qsim.interfaces.DepartureHandler;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.mobsim.qsim.interfaces.TripInfo;
import org.matsim.core.mobsim.qsim.interfaces.TripInfoRequest;
import org.matsim.core.mobsim.qsim.interfaces.TripInfoWithRequiredBooking;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.GenericRouteImpl;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.StageActivityTypesImpl;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.Facility;
import org.matsim.withinday.utils.EditPlans;
import org.matsim.withinday.utils.EditTrips;

public final class PreplanningEngine
implements MobsimEngine {
    private static final Logger log = Logger.getLogger(PreplanningEngine.class);
    public static final StageActivityTypes drtStageActivities = new StageActivityTypesImpl(PlanCalcScoreConfigGroup.createStageActivityType("drt"), PlanCalcScoreConfigGroup.createStageActivityType("walk"));
    private final ActivityFacilities facilities;
    private final Map<String, TripInfo.Provider> tripInfoProviders = new LinkedHashMap<String, TripInfo.Provider>();
    private final Population population;
    private final Network network;
    private final Scenario scenario;
    private Map<MobsimAgent, Optional<TripInfo>> tripInfoUpdatesMap = new TreeMap<MobsimAgent, Optional<TripInfo>>((o1, o2) -> o1.getId().compareTo(o2.getId()));
    private Map<MobsimAgent, TripInfoRequest> tripInfoRequestMap = new TreeMap<MobsimAgent, TripInfoRequest>((o1, o2) -> o1.getId().compareTo(o2.getId()));
    private EditTrips editTrips;
    private EditPlans editPlans = null;
    private final TripRouter tripRouter;
    private InternalInterface internalInterface;

    @Inject
    PreplanningEngine(TripRouter tripRouter, Scenario scenario) {
        this.tripRouter = tripRouter;
        this.population = scenario.getPopulation();
        this.facilities = scenario.getActivityFacilities();
        this.network = scenario.getNetwork();
        this.scenario = scenario;
    }

    @Override
    public void onPrepareSim() {
        for (DepartureHandler departureHandler : this.internalInterface.getDepartureHandlers()) {
            if (!(departureHandler instanceof TripInfo.Provider)) continue;
            String mode = ((TripInfo.Provider)((Object)departureHandler)).getMode();
            log.warn("registering TripInfo.Provider for mode=" + mode);
            this.tripInfoProviders.put(mode, (TripInfo.Provider)((Object)departureHandler));
        }
    }

    @Override
    public void afterSim() {
    }

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.editTrips = new EditTrips(this.tripRouter, this.scenario, internalInterface);
        this.editPlans = new EditPlans(internalInterface.getMobsim(), this.tripRouter, this.editTrips);
        this.internalInterface = internalInterface;
    }

    @Override
    public void doSimStep(double time) {
        this.processTripInfoRequests();
        this.processTripInfoUpdates();
    }

    public final synchronized void notifyChangedTripInformation(MobsimAgent agent, Optional<TripInfo> tripInfoUpdate) {
        this.tripInfoUpdatesMap.put(agent, tripInfoUpdate);
    }

    final synchronized void notifyTripInfoNeeded(MobsimAgent agent, TripInfoRequest tripInfoRequest) {
        this.tripInfoRequestMap.put(agent, tripInfoRequest);
    }

    private void processTripInfoRequests() {
        for (Map.Entry<MobsimAgent, TripInfoRequest> entry : this.tripInfoRequestMap.entrySet()) {
            LinkedHashMap<TripInfo, TripInfo.Provider> allTripInfos = new LinkedHashMap<TripInfo, TripInfo.Provider>();
            for (TripInfo.Provider provider : this.tripInfoProviders.values()) {
                List<TripInfo> tripInfos = provider.getTripInfos(entry.getValue());
                for (TripInfo tripInfo : tripInfos) {
                    allTripInfos.put(tripInfo, provider);
                }
            }
            this.decide(entry.getKey(), allTripInfos);
        }
        this.tripInfoRequestMap.clear();
    }

    private void decide(MobsimAgent agent, Map<TripInfo, TripInfo.Provider> allTripInfos) {
        this.population.getPersons().get(agent.getId()).getAttributes().putAttribute("marker", true);
        if (allTripInfos.isEmpty()) {
            return;
        }
        TripInfo tripInfo = allTripInfos.keySet().iterator().next();
        if (tripInfo instanceof TripInfoWithRequiredBooking) {
            this.tripInfoProviders.get(tripInfo.getMode()).bookTrip((MobsimPassengerAgent)agent, (TripInfoWithRequiredBooking)tripInfo);
            tripInfo.getOriginalRequest().getFromActivity().setEndTime(Double.MAX_VALUE);
            this.editPlans.rescheduleActivityEnd(agent);
        } else {
            this.notifyChangedTripInformation(agent, Optional.of(tripInfo));
        }
        log.warn("---");
    }

    private void processTripInfoUpdates() {
        for (Map.Entry<MobsimAgent, Optional<TripInfo>> entry : this.tripInfoUpdatesMap.entrySet()) {
            MobsimAgent agent = entry.getKey();
            Optional<TripInfo> tripInfo = entry.getValue();
            if (tripInfo.isPresent()) {
                TripInfo actualTripInfo = tripInfo.get();
                this.updateAgentPlan(agent, actualTripInfo);
                continue;
            }
            TripInfoRequest request = null;
            this.notifyTripInfoNeeded(agent, request);
        }
        this.tripInfoUpdatesMap.clear();
    }

    public List<ActivityEngineWithWakeup.AgentEntry> generateWakeups(MobsimAgent agent, double now) {
        if (!(agent instanceof HasModifiablePlan)) {
            return Collections.emptyList();
        }
        ArrayList<ActivityEngineWithWakeup.AgentEntry> wakeups = new ArrayList<ActivityEngineWithWakeup.AgentEntry>();
        Double prebookingOffset_s = (Double)((PlanAgent)((Object)agent)).getCurrentPlan().getAttributes().getAttribute("prebookingOffset_s");
        if (prebookingOffset_s == null) {
            log.warn("not prebooking");
            return wakeups;
        }
        for (String mode : new String[]{"drt", "taxi"}) {
            for (Leg drtLeg : PreplanningEngine.findLegsWithModeInFuture(agent, mode)) {
                Activity originActivity;
                double prebookingTime = drtLeg.getDepartureTime() - prebookingOffset_s;
                if (prebookingTime < agent.getActivityEndTime()) {
                    log.info("adding agent to wakeup list");
                    wakeups.add(new ActivityEngineWithWakeup.AgentEntry(agent, prebookingTime, (agent1, then) -> this.wakeUpAgent(agent1, then, drtLeg)));
                }
                if (!((originActivity = this.editTrips.findTripAtPlanElement(agent, drtLeg).getOriginActivity()).getEndTime() < now + 2.0)) continue;
                originActivity.setEndTime(now + 2.0);
                WithinDayAgentUtils.resetCaches(agent);
            }
        }
        return wakeups;
    }

    public static List<Leg> findLegsWithModeInFuture(MobsimAgent agent, String mode) {
        ArrayList<Leg> retVal = new ArrayList<Leg>();
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        for (int ii = WithinDayAgentUtils.getCurrentPlanElementIndex(agent).intValue(); ii < plan.getPlanElements().size(); ++ii) {
            PlanElement pe = plan.getPlanElements().get(ii);
            if (!(pe instanceof Leg) || !Objects.equals(mode, ((Leg)pe).getMode())) continue;
            retVal.add((Leg)pe);
        }
        return retVal;
    }

    private void wakeUpAgent(MobsimAgent agent, double now, Leg leg) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        TripStructureUtils.Trip drtTrip = TripStructureUtils.findTripAtPlanElement(leg, plan, drtStageActivities);
        Gbl.assertNotNull(drtTrip);
        TripInfoRequest request = new TripInfoRequest.Builder(this.scenario).setFromActivity(drtTrip.getOriginActivity()).setToActivity(drtTrip.getDestinationActivity()).setTime(drtTrip.getOriginActivity().getEndTime()).createRequest();
        this.notifyTripInfoNeeded(agent, request);
    }

    private void updateAgentPlan(MobsimAgent agent, TripInfo tripInfo) {
        double expectedTravelTime;
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        TripStructureUtils.Trip inputTrip = null;
        Coord pickupCoord = FacilitiesUtils.decideOnCoord(tripInfo.getPickupLocation(), this.network);
        Coord dropoffCoord = FacilitiesUtils.decideOnCoord(tripInfo.getDropoffLocation(), this.network);
        for (TripStructureUtils.Trip drtTrip : TripStructureUtils.getTrips(plan, drtStageActivities)) {
            Coord coordDestination;
            Coord coordOrigin = PopulationUtils.decideOnCoordForActivity(drtTrip.getOriginActivity(), this.scenario);
            if (CoordUtils.calcEuclideanDistance(coordOrigin, pickupCoord) > 1000.0 || CoordUtils.calcEuclideanDistance(coordDestination = PopulationUtils.decideOnCoordForActivity(drtTrip.getDestinationActivity(), this.scenario), dropoffCoord) > 1000.0) continue;
            inputTrip = drtTrip;
            break;
        }
        Gbl.assertNotNull(inputTrip);
        ArrayList<PlanElement> result = new ArrayList<PlanElement>();
        inputTrip.getOriginActivity().setEndTime(tripInfo.getExpectedBoardingTime() - 900.0);
        WithinDayAgentUtils.resetCaches(agent);
        log.warn("agentId=" + agent.getId() + " | newActEndTime=" + inputTrip.getOriginActivity().getEndTime());
        PopulationFactory pf = this.population.getFactory();
        Facility fromFacility = FacilitiesUtils.toFacility(inputTrip.getOriginActivity(), this.facilities);
        Facility toFacility = tripInfo.getPickupLocation();
        double departureTime = tripInfo.getExpectedBoardingTime() - 900.0;
        List<? extends PlanElement> planElements = this.tripRouter.calcRoute("walk", fromFacility, toFacility, departureTime, null);
        result.addAll(planElements);
        Activity act = pf.createActivityFromLinkId(PlanCalcScoreConfigGroup.createStageActivityType("taxi"), tripInfo.getPickupLocation().getLinkId());
        act.setMaximumDuration(0.0);
        result.add(act);
        Leg leg = pf.createLeg("taxi");
        result.add(leg);
        GenericRouteImpl route = pf.getRouteFactories().createRoute(GenericRouteImpl.class, tripInfo.getPickupLocation().getLinkId(), tripInfo.getDropoffLocation().getLinkId());
        leg.setRoute(route);
        act = pf.createActivityFromLinkId(PlanCalcScoreConfigGroup.createStageActivityType("taxi"), tripInfo.getDropoffLocation().getLinkId());
        act.setMaximumDuration(0.0);
        result.add(act);
        fromFacility = tripInfo.getDropoffLocation();
        toFacility = FacilitiesUtils.toFacility(inputTrip.getDestinationActivity(), this.facilities);
        try {
            expectedTravelTime = tripInfo.getExpectedTravelTime();
        }
        catch (Exception ee) {
            expectedTravelTime = 900.0;
        }
        double departureTime2 = tripInfo.getExpectedBoardingTime() + expectedTravelTime;
        List<? extends PlanElement> planElements2 = this.tripRouter.calcRoute("walk", fromFacility, toFacility, departureTime2, null);
        result.addAll(planElements2);
        TripRouter.insertTrip(plan, inputTrip.getOriginActivity(), result, inputTrip.getDestinationActivity());
        this.editPlans.rescheduleActivityEnd(agent);
        log.warn("new plan for agentId=" + agent.getId());
        for (PlanElement planElement : plan.getPlanElements()) {
            log.warn(planElement.toString());
        }
        log.warn("---");
    }

    static String toString(TripInfo info) {
        StringBuilder strb = new StringBuilder();
        strb.append("[ ");
        strb.append("mode=").append(info.getMode());
        strb.append(" | ");
        strb.append("des/expBoardingTime=").append(info.getExpectedBoardingTime());
        strb.append(" ]");
        return strb.toString();
    }
}

