/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.events.EventsUtils;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.AgentSource;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.framework.listeners.MobsimListener;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.ActivityEngine;
import org.matsim.core.mobsim.qsim.AgentCounter;
import org.matsim.core.mobsim.qsim.AgentTracker;
import org.matsim.core.mobsim.qsim.HasAgentTracker;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.MobsimListenerManager;
import org.matsim.core.mobsim.qsim.TeleportationEngine;
import org.matsim.core.mobsim.qsim.changeeventsengine.NetworkChangeEventsEngineI;
import org.matsim.core.mobsim.qsim.interfaces.ActivityHandler;
import org.matsim.core.mobsim.qsim.interfaces.DepartureHandler;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.interfaces.Netsim;
import org.matsim.core.mobsim.qsim.interfaces.NetsimNetwork;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.utils.misc.Time;
import org.matsim.vehicles.Vehicle;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.VisData;
import org.matsim.vis.snapshotwriters.VisMobsim;
import org.matsim.vis.snapshotwriters.VisNetwork;
import org.matsim.withinday.mobsim.WithinDayEngine;

public final class QSim
extends Thread
implements VisMobsim,
Netsim,
ActivityEndRescheduler {
    private static final Logger log = Logger.getLogger(QSim.class);
    private double infoTime = 0.0;
    private static final int INFO_PERIOD = 3600;
    private final EventsManager events;
    private NetsimEngine netEngine;
    private final Collection<MobsimEngine> mobsimEngines = new ArrayList<MobsimEngine>();
    private final MobsimTimer simTimer;
    private TeleportationEngine teleportationEngine;
    private WithinDayEngine withindayEngine = null;
    private final Date realWorldStarttime = new Date();
    private double stopTime = 360000.0;
    private final MobsimListenerManager listenerManager;
    private final Scenario scenario;
    private final List<ActivityHandler> activityHandlers = new ArrayList<ActivityHandler>();
    private final List<DepartureHandler> departureHandlers = new ArrayList<DepartureHandler>();
    private final AgentCounter agentCounter;
    private final Map<Id<Person>, MobsimAgent> agents = new LinkedHashMap<Id<Person>, MobsimAgent>();
    private final Map<Id<Vehicle>, MobsimVehicle> vehicles = new LinkedHashMap<Id<Vehicle>, MobsimVehicle>();
    private final List<AgentSource> agentSources = new ArrayList<AgentSource>();
    public static boolean analyzeRunTimes = false;
    private long startTime = 0L;
    private long qSimInternalTime = 0L;
    private final Map<MobsimEngine, AtomicLong> mobsimEngineRunTimes = analyzeRunTimes ? new HashMap<MobsimEngine, AtomicLong>() : null;
    private ActivityEngine activityEngine;
    final InternalInterface internalInterface = new InternalInterface(){

        @Override
        public synchronized void arrangeNextAgentState(MobsimAgent agent) {
            QSim.this.arrangeNextAgentAction(agent);
        }

        @Override
        public QSim getMobsim() {
            return QSim.this;
        }

        @Override
        public synchronized void registerAdditionalAgentOnLink(MobsimAgent planAgent) {
            if (QSim.this.netEngine != null) {
                QSim.this.netEngine.registerAdditionalAgentOnLink(planAgent);
            }
        }

        @Override
        public synchronized MobsimAgent unregisterAdditionalAgentOnLink(Id<Person> agentId, Id<Link> linkId) {
            if (QSim.this.netEngine != null) {
                return QSim.this.netEngine.unregisterAdditionalAgentOnLink(agentId, linkId);
            }
            return null;
        }

        @Override
        public final List<DepartureHandler> getDepartureHandlers() {
            return QSim.this.departureHandlers;
        }
    };
    private Collection<AgentTracker> agentTrackers = new ArrayList<AgentTracker>();
    private Injector childInjector;
    private static int wrnCnt2 = 0;

    @Override
    public final void rescheduleActivityEnd(MobsimAgent agent) {
        for (ActivityHandler activityHandler : this.activityHandlers) {
            Gbl.assertNotNull(activityHandler);
            activityHandler.rescheduleActivityEnd(agent);
        }
    }

    @Inject
    private QSim(Scenario sc, EventsManager events, Injector childInjector) {
        this.scenario = sc;
        this.events = sc.getConfig().qsim().getNumberOfThreads() > 1 ? EventsUtils.getParallelFeedableInstance(events) : events;
        this.listenerManager = new MobsimListenerManager(this);
        this.agentCounter = new AgentCounter();
        this.simTimer = new MobsimTimer(sc.getConfig().qsim().getTimeStepSize());
        this.childInjector = childInjector;
    }

    @Override
    public void run() {
        try {
            this.departureHandlers.add(this.teleportationEngine);
            this.activityHandlers.add(this.activityEngine);
            this.prepareSim();
            this.listenerManager.fireQueueSimulationInitializedEvent();
            for (MobsimAgent agent : new ArrayList<MobsimAgent>(this.agents.values())) {
                this.arrangeNextAgentAction(agent);
            }
            boolean doContinue = true;
            while (doContinue) {
                doContinue = this.doSimStep();
            }
        }
        finally {
            try {
                this.cleanupSim();
            }
            catch (Exception e) {
                log.warn("exception in finally block - this may be a follow-up exception of an exception thrown in the try block.", e);
            }
        }
    }

    void prepareSim() {
        this.events.initProcessing();
        this.createAgents();
        this.initSimTimer();
        this.infoTime = Math.floor(this.simTimer.getSimStartTime() / 3600.0) * 3600.0;
        for (MobsimEngine mobsimEngine : this.mobsimEngines) {
            mobsimEngine.onPrepareSim();
        }
    }

    private void createAgents() {
        for (AgentSource agentSource : this.agentSources) {
            agentSource.insertAgentsIntoMobsim();
        }
    }

    public void addParkedVehicle(MobsimVehicle veh, Id<Link> startLinkId) {
        if (this.netEngine != null) {
            this.netEngine.addParkedVehicle(veh, startLinkId);
        } else if (wrnCnt2 < 1) {
            log.warn("not able to add parked vehicle since there is no netsim engine.  continuing anyway, but it may not be clear what this means ...");
            log.warn(" This message given only once.");
            ++wrnCnt2;
        }
        if (this.vehicles.containsKey(veh.getId())) {
            throw new RuntimeException("vehicle with ID " + veh.getId() + " exists twice. Aborting ...");
        }
        this.vehicles.put(veh.getId(), veh);
    }

    public Map<Id<Vehicle>, MobsimVehicle> getVehicles() {
        return Collections.unmodifiableMap(this.vehicles);
    }

    void cleanupSim() {
        this.listenerManager.fireQueueSimulationBeforeCleanupEvent();
        boolean gotException = false;
        for (MobsimEngine mobsimEngine : this.mobsimEngines) {
            try {
                mobsimEngine.afterSim();
            }
            catch (Exception e) {
                log.error("got exception while cleaning up", e);
            }
        }
        if (gotException) {
            throw new RuntimeException("got exception while cleaning up the QSim. Please check the error messages above for details.");
        }
        this.events.finishProcessing();
        if (analyzeRunTimes) {
            log.info("qsim internal cpu time (nanos): " + this.qSimInternalTime);
            for (Map.Entry entry : this.mobsimEngineRunTimes.entrySet()) {
                log.info(((MobsimEngine)entry.getKey()).getClass().toString() + " cpu time (nanos): " + ((AtomicLong)entry.getValue()).get());
            }
            log.info("");
            if (this.netEngine instanceof QNetsimEngine) {
                ((QNetsimEngine)this.netEngine).printEngineRunTimes();
            }
        }
    }

    boolean doSimStep() {
        if (analyzeRunTimes) {
            this.startTime = System.nanoTime();
        }
        double now = this.getSimTimer().getTimeOfDay();
        this.listenerManager.fireQueueSimulationBeforeSimStepEvent(now);
        if (analyzeRunTimes) {
            this.qSimInternalTime += System.nanoTime() - this.startTime;
        }
        if (this.withindayEngine != null) {
            if (analyzeRunTimes) {
                this.startTime = System.nanoTime();
            }
            this.withindayEngine.doSimStep(now);
            if (analyzeRunTimes) {
                this.mobsimEngineRunTimes.get(this.withindayEngine).addAndGet(System.nanoTime() - this.startTime);
            }
        }
        for (MobsimEngine mobsimEngine : this.mobsimEngines) {
            if (analyzeRunTimes) {
                this.startTime = System.nanoTime();
            }
            if (mobsimEngine == this.withindayEngine) continue;
            mobsimEngine.doSimStep(now);
            if (!analyzeRunTimes) continue;
            this.mobsimEngineRunTimes.get(mobsimEngine).addAndGet(System.nanoTime() - this.startTime);
        }
        if (analyzeRunTimes) {
            this.startTime = System.nanoTime();
        }
        this.printSimLog(now);
        boolean doContinue = this.agentCounter.isLiving() && this.stopTime > now;
        this.events.afterSimStep(now);
        this.listenerManager.fireQueueSimulationAfterSimStepEvent(now);
        QSimConfigGroup qsimConfigGroup = this.scenario.getConfig().qsim();
        if (qsimConfigGroup.getSimEndtimeInterpretation() == QSimConfigGroup.EndtimeInterpretation.onlyUseEndtime) {
            doContinue = !(now > qsimConfigGroup.getEndTime());
        }
        if (doContinue) {
            this.simTimer.incrementTime();
        }
        if (analyzeRunTimes) {
            this.qSimInternalTime += System.nanoTime() - this.startTime;
        }
        return doContinue;
    }

    public void insertAgentIntoMobsim(MobsimAgent agent) {
        if (this.agents.containsKey(agent.getId())) {
            throw new RuntimeException("Agent with same Id (" + agent.getId().toString() + ") already in mobsim; aborting ... ");
        }
        this.agents.put(agent.getId(), agent);
        this.agentCounter.incLiving();
    }

    private void arrangeNextAgentAction(MobsimAgent agent) {
        switch (agent.getState()) {
            case ACTIVITY: {
                this.arrangeAgentActivity(agent);
                break;
            }
            case LEG: {
                this.arrangeAgentDeparture(agent);
                break;
            }
            case ABORT: {
                this.events.processEvent(new PersonStuckEvent(this.simTimer.getTimeOfDay(), agent.getId(), agent.getCurrentLinkId(), agent.getMode()));
                this.agents.remove(agent.getId());
                this.agentCounter.decLiving();
                this.agentCounter.incLost();
                break;
            }
            default: {
                throw new RuntimeException("agent with unknown state (possibly null)");
            }
        }
    }

    private void arrangeAgentActivity(MobsimAgent agent) {
        for (ActivityHandler activityHandler : this.activityHandlers) {
            if (!activityHandler.handleActivity(agent)) continue;
            return;
        }
    }

    private void arrangeAgentDeparture(MobsimAgent agent) {
        double now = this.getSimTimer().getTimeOfDay();
        Id<Link> linkId = agent.getCurrentLinkId();
        Gbl.assertIf(linkId != null);
        this.events.processEvent(new PersonDepartureEvent(now, agent.getId(), linkId, agent.getMode()));
        for (DepartureHandler departureHandler : this.departureHandlers) {
            if (!departureHandler.handleDeparture(now, agent, linkId)) continue;
            return;
        }
        log.warn("no departure handler wanted to handle the departure of agent " + agent.getId());
    }

    private void initSimTimer() {
        double simStartTime;
        QSimConfigGroup qSimConfigGroup = this.scenario.getConfig().qsim();
        Double configuredStartTime = qSimConfigGroup.getStartTime();
        this.stopTime = qSimConfigGroup.getEndTime();
        if (configuredStartTime == Double.NEGATIVE_INFINITY) {
            configuredStartTime = 0.0;
        }
        if (this.stopTime == Double.NEGATIVE_INFINITY || this.stopTime == 0.0) {
            this.stopTime = Double.MAX_VALUE;
        }
        if (QSimConfigGroup.StarttimeInterpretation.maxOfStarttimeAndEarliestActivityEnd.equals((Object)qSimConfigGroup.getSimStarttimeInterpretation())) {
            double firstAgentStartTime = this.calculateFirstAgentStartTime();
            simStartTime = Math.floor(Math.max(configuredStartTime, firstAgentStartTime));
        } else if (QSimConfigGroup.StarttimeInterpretation.onlyUseStarttime.equals((Object)qSimConfigGroup.getSimStarttimeInterpretation())) {
            simStartTime = configuredStartTime;
        } else {
            throw new RuntimeException("unkonwn starttimeInterpretation; aborting ...");
        }
        this.simTimer.setSimStartTime(simStartTime);
        this.simTimer.setTime(simStartTime);
    }

    private double calculateFirstAgentStartTime() {
        double firstAgentStartTime = Double.POSITIVE_INFINITY;
        for (MobsimAgent agent : this.agents.values()) {
            firstAgentStartTime = Math.min(firstAgentStartTime, agent.getActivityEndTime());
        }
        return firstAgentStartTime;
    }

    private void printSimLog(double time) {
        if (time >= this.infoTime) {
            this.infoTime += 3600.0;
            Date endtime = new Date();
            long diffreal = (endtime.getTime() - this.realWorldStarttime.getTime()) / 1000L;
            double diffsim = time - this.simTimer.getSimStartTime();
            log.info("SIMULATION (NEW QSim) AT " + Time.writeTime(time) + " : #Veh=" + this.agentCounter.getLiving() + " lost=" + this.agentCounter.getLost() + " simT=" + diffsim + "s realT=" + diffreal + "s; (s/r): " + diffsim / ((double)diffreal + Double.MIN_VALUE));
            Gbl.printMemoryUsage();
        }
    }

    @Override
    public EventsManager getEventsManager() {
        return this.events;
    }

    @Override
    public NetsimNetwork getNetsimNetwork() {
        return this.netEngine.getNetsimNetwork();
    }

    @Override
    public VisNetwork getVisNetwork() {
        return this.netEngine.getNetsimNetwork();
    }

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }

    @Override
    public MobsimTimer getSimTimer() {
        return this.simTimer;
    }

    public void addMobsimEngine(MobsimEngine mobsimEngine) {
        if (mobsimEngine instanceof AgentTracker) {
            this.agentTrackers.add((AgentTracker)((Object)mobsimEngine));
        }
        if (mobsimEngine instanceof ActivityEngine) {
            this.activityEngine = (ActivityEngine)mobsimEngine;
        }
        if (mobsimEngine instanceof HasAgentTracker) {
            this.agentTrackers.add(((HasAgentTracker)((Object)mobsimEngine)).getAgentTracker());
        }
        if (mobsimEngine instanceof NetsimEngine) {
            this.netEngine = (NetsimEngine)((Object)mobsimEngine);
        }
        if (mobsimEngine instanceof TeleportationEngine) {
            this.teleportationEngine = (TeleportationEngine)mobsimEngine;
        }
        if (mobsimEngine instanceof WithinDayEngine) {
            this.withindayEngine = (WithinDayEngine)mobsimEngine;
        }
        mobsimEngine.setInternalInterface(this.internalInterface);
        this.mobsimEngines.add(mobsimEngine);
        if (analyzeRunTimes) {
            this.mobsimEngineRunTimes.put(mobsimEngine, new AtomicLong());
        }
    }

    @Override
    public org.matsim.core.mobsim.qsim.interfaces.AgentCounter getAgentCounter() {
        return this.agentCounter;
    }

    public void addDepartureHandler(DepartureHandler departureHandler) {
        if (!(departureHandler instanceof TeleportationEngine)) {
            this.departureHandlers.add(departureHandler);
        }
    }

    public void addActivityHandler(ActivityHandler activityHandler) {
        if (!(activityHandler instanceof ActivityEngine)) {
            Gbl.assertNotNull(activityHandler);
            this.activityHandlers.add(activityHandler);
        }
    }

    @Override
    public void addQueueSimulationListeners(MobsimListener listener) {
        this.listenerManager.addQueueSimulationListener(listener);
    }

    @Inject
    void addQueueSimulationListeners(Set<MobsimListener> listeners) {
        for (MobsimListener listener : listeners) {
            this.listenerManager.addQueueSimulationListener(listener);
        }
    }

    @Override
    public Map<Id<Person>, MobsimAgent> getAgents() {
        return Collections.unmodifiableMap(this.agents);
    }

    public void addAgentSource(AgentSource agentSource) {
        this.agentSources.add(agentSource);
    }

    @Override
    public VisData getNonNetworkAgentSnapshots() {
        return new VisData(){

            @Override
            public Collection<AgentSnapshotInfo> addAgentSnapshotInfo(Collection<AgentSnapshotInfo> positions) {
                for (MobsimEngine mobsimEngine : QSim.this.mobsimEngines) {
                    if (!(mobsimEngine instanceof VisData)) continue;
                    VisData visData = (VisData)((Object)mobsimEngine);
                    positions = visData.addAgentSnapshotInfo(positions);
                }
                return positions;
            }
        };
    }

    public Collection<AgentTracker> getAgentTrackers() {
        return Collections.unmodifiableCollection(this.agentTrackers);
    }

    public Injector getChildInjector() {
        return this.childInjector;
    }

    public final void addNetworkChangeEvent(NetworkChangeEvent event) {
        boolean processed = false;
        for (MobsimEngine engine : this.mobsimEngines) {
            if (!(engine instanceof NetworkChangeEventsEngineI)) continue;
            ((NetworkChangeEventsEngineI)engine).addNetworkChangeEvent(event);
            processed = true;
        }
        if (!processed) {
            throw new RuntimeException("received a network change event, but did not process it.  Maybe the network change events engine was not set up for the qsim?  Aborting ...");
        }
    }
}

