/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.AllowsConfiguration;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.qsim.AbstractQSimModule;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.QSimModule;
import org.matsim.core.mobsim.qsim.components.QSimComponentsConfig;
import org.matsim.core.mobsim.qsim.components.QSimComponentsConfigurator;
import org.matsim.core.mobsim.qsim.components.StandardQSimComponentConfigurator;
import org.matsim.core.scenario.ScenarioByInstanceModule;

public class QSimBuilder
implements AllowsConfiguration {
    private final Config config;
    private final Collection<AbstractQSimModule> qsimModules = new LinkedList<AbstractQSimModule>();
    private final QSimComponentsConfig components = new QSimComponentsConfig();
    private final List<AbstractModule> overridingControllerModules = new LinkedList<AbstractModule>();
    private final List<AbstractQSimModule> overridingQSimModules = new LinkedList<AbstractQSimModule>();

    public QSimBuilder(Config config) {
        this.config = config;
    }

    public QSimBuilder useDefaults() {
        this.useDefaultComponents();
        this.useDefaultQSimModules();
        return this;
    }

    @Override
    public QSimBuilder addOverridingModule(AbstractModule module) {
        this.overridingControllerModules.add(module);
        return this;
    }

    @Override
    public QSimBuilder addQSimModule(AbstractQSimModule module) {
        this.qsimModules.add(module);
        return this;
    }

    @Override
    public QSimBuilder addOverridingQSimModule(AbstractQSimModule module) {
        this.overridingQSimModules.add(module);
        return this;
    }

    public QSimBuilder useDefaultComponents() {
        this.components.clear();
        new StandardQSimComponentConfigurator(this.config).configure(this.components);
        return this;
    }

    @Override
    public QSimBuilder configureQSimComponents(QSimComponentsConfigurator configurator) {
        configurator.configure(this.components);
        return this;
    }

    public QSimBuilder useDefaultQSimModules() {
        this.qsimModules.clear();
        this.qsimModules.addAll(QSimModule.getDefaultQSimModules());
        return this;
    }

    public QSimBuilder configureModules(Consumer<Collection<AbstractQSimModule>> configurator) {
        configurator.accept(this.qsimModules);
        return this;
    }

    public QSimBuilder removeModule(Class<? extends AbstractQSimModule> moduleType) {
        this.qsimModules.removeIf(moduleType::isInstance);
        return this;
    }

    public QSim build(Scenario scenario, EventsManager eventsManager) {
        AbstractModule controllerModule = new StandaloneQSimModule(scenario, eventsManager);
        for (AbstractModule override : this.overridingControllerModules) {
            controllerModule = AbstractModule.override(Collections.singleton(controllerModule), override);
        }
        controllerModule = AbstractModule.override(Collections.singleton(controllerModule), new AbstractModule(){

            @Override
            public void install() {
                this.bind(QSimComponentsConfig.class).toInstance(QSimBuilder.this.components);
                QSimBuilder.this.qsimModules.forEach(this::installQSimModule);
                this.bind(Key.get(new TypeLiteral<List<AbstractQSimModule>>(){}, (Annotation)Names.named("overrides"))).toInstance(QSimBuilder.this.overridingQSimModules);
            }
        });
        Injector injector = org.matsim.core.controler.Injector.createInjector(this.config, controllerModule);
        return (QSim)injector.getInstance(Mobsim.class);
    }

    private static class StandaloneQSimModule
    extends AbstractModule {
        private final Scenario scenario;
        private final EventsManager eventsManager;

        public StandaloneQSimModule(Scenario scenario, EventsManager eventsManager) {
            this.scenario = scenario;
            this.eventsManager = eventsManager;
        }

        @Override
        public void install() {
            this.install(new ScenarioByInstanceModule(this.scenario));
            this.bind(EventsManager.class).toInstance(this.eventsManager);
            this.install(new QSimModule(false));
        }
    }
}

