/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.matsim.core.config.Config;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.qsim.AbstractQSimModule;
import org.matsim.core.mobsim.qsim.ActivityEngineModule;
import org.matsim.core.mobsim.qsim.PopulationModule;
import org.matsim.core.mobsim.qsim.QSimProvider;
import org.matsim.core.mobsim.qsim.TeleportationModule;
import org.matsim.core.mobsim.qsim.changeeventsengine.NetworkChangeEventsModule;
import org.matsim.core.mobsim.qsim.components.QSimComponentsModule;
import org.matsim.core.mobsim.qsim.messagequeueengine.MessageQueueModule;
import org.matsim.core.mobsim.qsim.pt.TransitEngineModule;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngineModule;

public class QSimModule
extends AbstractModule {
    @Inject
    Config config;
    private final boolean addDefaultQSimModules;

    public QSimModule() {
        this(true);
    }

    public QSimModule(boolean addDefaultQSimModules) {
        this.addDefaultQSimModules = addDefaultQSimModules;
    }

    @Override
    public void install() {
        this.install(new QSimComponentsModule());
        if (this.addDefaultQSimModules) {
            QSimModule.getDefaultQSimModules().forEach(this::installQSimModule);
        }
        this.bind(Key.get(new TypeLiteral<List<AbstractQSimModule>>(){}, (Annotation)Names.named("overrides"))).toInstance(Collections.emptyList());
        this.bind(new TypeLiteral<Collection<AbstractQSimModule>>(){}).to((TypeLiteral<Collection<AbstractQSimModule>>)new TypeLiteral<Set<AbstractQSimModule>>(){});
        this.bind(Mobsim.class).toProvider(QSimProvider.class);
    }

    public static Collection<AbstractQSimModule> getDefaultQSimModules() {
        return Arrays.asList(new MessageQueueModule(), new ActivityEngineModule(), new QNetsimEngineModule(), new TeleportationModule(), new PopulationModule(), new NetworkChangeEventsModule(), new TransitEngineModule());
    }
}

