/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim;

import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.controler.IterationCounter;
import org.matsim.core.mobsim.framework.AgentSource;
import org.matsim.core.mobsim.framework.listeners.MobsimListener;
import org.matsim.core.mobsim.qsim.AbstractQSimModule;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.components.QSimComponent;
import org.matsim.core.mobsim.qsim.components.QSimComponentsConfig;
import org.matsim.core.mobsim.qsim.interfaces.ActivityHandler;
import org.matsim.core.mobsim.qsim.interfaces.DepartureHandler;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.mobsim.qsim.interfaces.Netsim;
import org.matsim.core.mobsim.qsim.pt.TransitStopHandlerFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;

public class QSimProvider
implements Provider<QSim> {
    private static final Logger log = Logger.getLogger(QSimProvider.class);
    private Injector injector;
    private Config config;
    private Collection<AbstractQSimModule> modules;
    private List<AbstractQSimModule> overridingModules;
    private QSimComponentsConfig components;
    @Inject(optional=true)
    private IterationCounter iterationCounter;

    @Inject
    QSimProvider(Injector injector, Config config, Collection<AbstractQSimModule> modules, QSimComponentsConfig components, @Named(value="overrides") List<AbstractQSimModule> overridingModules) {
        this.injector = injector;
        this.modules = modules;
        this.config = config;
        this.components = components;
        this.overridingModules = overridingModules;
    }

    @Override
    public QSim get() {
        this.performHistoricalCheck(this.injector);
        this.modules.forEach(m3 -> m3.setConfig(this.config));
        this.overridingModules.forEach(m3 -> m3.setConfig(this.config));
        final AbstractQSimModule qsimModule = AbstractQSimModule.overrideQSimModules(this.modules, this.overridingModules);
        AbstractModule module = new AbstractModule(){

            @Override
            protected void configure() {
                this.install(qsimModule);
                this.bind(QSim.class).asEagerSingleton();
                this.bind(Netsim.class).to(QSim.class);
            }
        };
        Injector qsimInjector = this.injector.createChildInjector(module);
        QSim qSim = qsimInjector.getInstance(QSim.class);
        for (Object activeComponent : this.components.getActiveComponents()) {
            Key<Collection<Provider<QSimComponent>>> activeComponentKey = activeComponent instanceof Annotation ? Key.get(new TypeLiteral<Collection<Provider<QSimComponent>>>(){}, (Annotation)activeComponent) : Key.get(new TypeLiteral<Collection<Provider<QSimComponent>>>(){}, (Class<? extends Annotation>)((Class)activeComponent));
            Collection<Provider<QSimComponent>> providers = qsimInjector.getInstance(activeComponentKey);
            for (Provider<QSimComponent> provider : providers) {
                QSimComponent instance;
                QSimComponent qSimComponent = provider.get();
                if (qSimComponent instanceof MobsimEngine) {
                    instance = (MobsimEngine)qSimComponent;
                    qSim.addMobsimEngine((MobsimEngine)instance);
                    log.info("Added MobsimEngine " + instance.getClass());
                }
                if (qSimComponent instanceof ActivityHandler) {
                    instance = (ActivityHandler)qSimComponent;
                    qSim.addActivityHandler((ActivityHandler)instance);
                    log.info("Added Activityhandler " + instance.getClass());
                }
                if (qSimComponent instanceof DepartureHandler) {
                    instance = (DepartureHandler)qSimComponent;
                    qSim.addDepartureHandler((DepartureHandler)instance);
                    log.info("Added DepartureHandler " + instance.getClass());
                }
                if (qSimComponent instanceof AgentSource) {
                    instance = (AgentSource)qSimComponent;
                    qSim.addAgentSource((AgentSource)instance);
                    log.info("Added AgentSource " + instance.getClass());
                }
                if (!(qSimComponent instanceof MobsimListener)) continue;
                instance = (MobsimListener)qSimComponent;
                qSim.addQueueSimulationListeners((MobsimListener)instance);
                log.info("Added MobsimListener " + instance.getClass());
            }
        }
        return qSim;
    }

    private void performHistoricalCheck(Injector injector) {
        boolean foundNetworkFactoryBinding = true;
        try {
            injector.getBinding(QNetworkFactory.class);
        }
        catch (ConfigurationException e) {
            foundNetworkFactoryBinding = false;
        }
        if (foundNetworkFactoryBinding) {
            throw new IllegalStateException("QNetworkFactory should only be bound via AbstractQSimModule");
        }
        boolean foundTransitStopHandlerFactoryBinding = true;
        try {
            injector.getBinding(TransitStopHandlerFactory.class);
        }
        catch (ConfigurationException e) {
            foundTransitStopHandlerFactoryBinding = false;
        }
        if (foundTransitStopHandlerFactoryBinding) {
            throw new IllegalStateException("TransitStopHandlerFactory should be bound via AbstractQSimModule");
        }
    }
}

