/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.agents;

import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.utils.misc.Time;

public class ActivityDurationUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double calculateDepartureTime(Activity act, double now, PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation) {
        if (Time.isUndefinedTime(act.getMaximumDuration()) && Time.isUndefinedTime(act.getEndTime())) {
            return Double.POSITIVE_INFINITY;
        }
        double departure = 0.0;
        if (activityDurationInterpretation.equals((Object)PlansConfigGroup.ActivityDurationInterpretation.minOfDurationAndEndTime)) {
            departure = Time.isUndefinedTime(act.getMaximumDuration()) ? act.getEndTime() : (Time.isUndefinedTime(act.getEndTime()) ? now + act.getMaximumDuration() : Math.min(act.getEndTime(), now + act.getMaximumDuration()));
        } else if (activityDurationInterpretation.equals((Object)PlansConfigGroup.ActivityDurationInterpretation.endTimeOnly)) {
            if (Time.isUndefinedTime(act.getEndTime())) throw new IllegalStateException("activity end time not set and using something else not allowed.");
            departure = act.getEndTime();
        } else {
            if (!activityDurationInterpretation.equals((Object)PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration)) throw new IllegalStateException("should not happen");
            if (!Time.isUndefinedTime(act.getEndTime())) {
                departure = act.getEndTime();
            } else {
                if (Time.isUndefinedTime(act.getMaximumDuration())) throw new IllegalStateException("neither activity end time nor activity duration defined; don't know what to do.");
                departure = now + act.getMaximumDuration();
            }
        }
        if (!(departure < now)) return departure;
        return now;
    }
}

