/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.agents;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.HasPerson;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.framework.PlanAgent;
import org.matsim.core.mobsim.framework.VehicleUsingAgent;
import org.matsim.core.mobsim.qsim.agents.ActivityDurationUtils;
import org.matsim.core.mobsim.qsim.agents.HasModifiablePlan;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.Facility;
import org.matsim.vehicles.Vehicle;

public final class BasicPlanAgentImpl
implements MobsimAgent,
PlanAgent,
HasPerson,
VehicleUsingAgent,
HasModifiablePlan {
    private static final Logger log = Logger.getLogger(BasicPlanAgentImpl.class);
    private static int finalActHasDpTimeWrnCnt = 0;
    private static int noRouteWrnCnt = 0;
    private int currentPlanElementIndex = 0;
    private Plan plan;
    private boolean firstTimeToGetModifiablePlan = true;
    private final Scenario scenario;
    private final EventsManager events;
    private final MobsimTimer simTimer;
    private MobsimVehicle vehicle;
    private double activityEndTime = Double.NEGATIVE_INFINITY;
    private MobsimAgent.State state = MobsimAgent.State.ABORT;
    private Id<Link> currentLinkId = null;
    private int currentLinkIndex = 0;

    public BasicPlanAgentImpl(Plan plan2, Scenario scenario, EventsManager events, MobsimTimer simTimer) {
        this.plan = PopulationUtils.unmodifiablePlan(plan2);
        this.scenario = scenario;
        this.events = events;
        this.simTimer = simTimer;
        List<PlanElement> planElements = this.getCurrentPlan().getPlanElements();
        if (planElements.size() > 0) {
            Activity firstAct = (Activity)planElements.get(0);
            Id<Link> linkId = PopulationUtils.computeLinkIdFromActivity(firstAct, scenario.getActivityFacilities(), scenario.getConfig());
            Gbl.assertIf(linkId != null);
            this.setCurrentLinkId(linkId);
            this.setState(MobsimAgent.State.ACTIVITY);
            this.calculateAndSetDepartureTime(firstAct);
        }
    }

    @Override
    public final void endLegAndComputeNextState(double now) {
        this.getEvents().processEvent(new PersonArrivalEvent(now, this.getId(), this.getDestinationLinkId(), this.getCurrentLeg().getMode()));
        if (!(this.getCurrentLinkId() == null && this.getDestinationLinkId() == null || this.getCurrentLinkId().equals(this.getDestinationLinkId()))) {
            log.error("The agent " + this.getPerson().getId() + " has destination link " + this.getDestinationLinkId() + ", but arrived on link " + this.getCurrentLinkId() + ". Setting agent state to ABORT.");
            this.setState(MobsimAgent.State.ABORT);
        } else {
            this.advancePlan(now);
        }
        this.currentLinkIndex = 0;
    }

    @Override
    public final void setStateToAbort(double now) {
        this.setState(MobsimAgent.State.ABORT);
    }

    @Override
    public final void notifyArrivalOnLinkByNonNetworkMode(Id<Link> linkId) {
        Gbl.assertNotNull(linkId);
        this.setCurrentLinkId(linkId);
    }

    private void advancePlan(double now) {
        ++this.currentPlanElementIndex;
        if (this.getCurrentPlanElementIndex() >= this.getCurrentPlan().getPlanElements().size()) {
            log.error("plan of agent with id = " + this.getId() + " has run empty.  Setting agent state to ABORT (but continuing the mobsim).");
            this.setState(MobsimAgent.State.ABORT);
            return;
        }
        PlanElement pe = this.getCurrentPlanElement();
        if (pe instanceof Activity) {
            Activity act = (Activity)pe;
            this.initializeActivity(act, now);
        } else if (pe instanceof Leg) {
            Leg leg = (Leg)pe;
            this.initializeLeg(leg);
        } else {
            throw new RuntimeException("Unknown PlanElement of type: " + pe.getClass().getName());
        }
    }

    private void initializeLeg(Leg leg) {
        this.setState(MobsimAgent.State.LEG);
        this.currentLinkIndex = 0;
        if (leg.getRoute() == null) {
            log.error("The agent " + this.getPerson().getId() + " has no route in its leg.  Setting agent state to ABORT.");
            if (noRouteWrnCnt < 1) {
                log.info("(Route is needed inside Leg even if you want teleportation since Route carries the start/endLinkId info.)");
                ++noRouteWrnCnt;
            }
            this.setState(MobsimAgent.State.ABORT);
        }
    }

    private void initializeActivity(Activity act, double now) {
        this.setState(MobsimAgent.State.ACTIVITY);
        this.getEvents().processEvent(new ActivityStartEvent(now, this.getId(), this.getCurrentLinkId(), act.getFacilityId(), act.getType()));
        this.calculateAndSetDepartureTime(act);
        this.getModifiablePlan();
        ((Activity)this.getCurrentPlanElement()).setStartTime(now);
    }

    private final void calculateAndSetDepartureTime(Activity act) {
        PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation = this.getScenario().getConfig().plans().getActivityDurationInterpretation();
        double now = this.getSimTimer().getTimeOfDay();
        double departure = ActivityDurationUtils.calculateDepartureTime(act, now, activityDurationInterpretation);
        if (this.getCurrentPlanElementIndex() == this.getCurrentPlan().getPlanElements().size() - 1) {
            if (finalActHasDpTimeWrnCnt < 1 && departure != Double.POSITIVE_INFINITY) {
                log.error("last activity of person driver agent id " + this.getId() + " has end time < infty; setting it to infty");
                log.error(" This message given only once.");
                ++finalActHasDpTimeWrnCnt;
            }
            departure = Double.POSITIVE_INFINITY;
        }
        this.activityEndTime = departure;
    }

    @Override
    public final void endActivityAndComputeNextState(double now) {
        if (!(this.getCurrentPlanElement() instanceof Activity)) {
            log.warn("trying to end an activity but current plan element is not an activity; agentId=" + this.getId());
        }
        Activity act = (Activity)this.getCurrentPlanElement();
        this.getEvents().processEvent(new ActivityEndEvent(now, this.getPerson().getId(), this.currentLinkId, act.getFacilityId(), act.getType()));
        this.advancePlan(now);
    }

    @Override
    public final void resetCaches() {
        if (this.getCurrentPlanElement() instanceof Activity) {
            Activity act = (Activity)this.getCurrentPlanElement();
            this.calculateAndSetDepartureTime(act);
        }
    }

    @Override
    public final Plan getModifiablePlan() {
        if (this.firstTimeToGetModifiablePlan) {
            this.firstTimeToGetModifiablePlan = false;
            Plan newPlan = PopulationUtils.createPlan(this.getCurrentPlan().getPerson());
            PopulationUtils.copyFromTo(this.getCurrentPlan(), newPlan);
            this.plan = newPlan;
        }
        return this.getCurrentPlan();
    }

    @Override
    public final Id<Vehicle> getPlannedVehicleId() {
        NetworkRoute route = (NetworkRoute)this.getCurrentLeg().getRoute();
        if (route.getVehicleId() != null) {
            return route.getVehicleId();
        }
        Gbl.assertIf(this.scenario.getConfig().qsim().getUsePersonIdForMissingVehicleId());
        return Id.create(this.getId(), Vehicle.class);
    }

    @Override
    public final String getMode() {
        if (this.getCurrentPlanElementIndex() >= this.getCurrentPlan().getPlanElements().size()) {
            return null;
        }
        PlanElement currentPlanElement = this.getCurrentPlanElement();
        if (!(currentPlanElement instanceof Leg)) {
            return null;
        }
        return ((Leg)currentPlanElement).getMode();
    }

    @Override
    public final Double getExpectedTravelTime() {
        PlanElement currentPlanElement = this.getCurrentPlanElement();
        if (!(currentPlanElement instanceof Leg)) {
            return null;
        }
        double travelTimeFromRoute = ((Leg)currentPlanElement).getRoute().getTravelTime();
        if (travelTimeFromRoute != Double.NEGATIVE_INFINITY) {
            return travelTimeFromRoute;
        }
        if (((Leg)currentPlanElement).getTravelTime() != Double.NEGATIVE_INFINITY) {
            return ((Leg)currentPlanElement).getTravelTime();
        }
        return null;
    }

    @Override
    public final Double getExpectedTravelDistance() {
        PlanElement currentPlanElement = this.getCurrentPlanElement();
        if (!(currentPlanElement instanceof Leg)) {
            return null;
        }
        return ((Leg)currentPlanElement).getRoute().getDistance();
    }

    @Override
    public final PlanElement getCurrentPlanElement() {
        return this.plan.getPlanElements().get(this.currentPlanElementIndex);
    }

    @Override
    public final PlanElement getNextPlanElement() {
        if (this.currentPlanElementIndex < this.plan.getPlanElements().size() - 1) {
            return this.plan.getPlanElements().get(this.currentPlanElementIndex + 1);
        }
        return null;
    }

    public final Activity getNextActivity() {
        for (int idx = this.currentPlanElementIndex + 1; idx < this.plan.getPlanElements().size(); ++idx) {
            if (!(this.plan.getPlanElements().get(idx) instanceof Activity)) continue;
            return (Activity)this.plan.getPlanElements().get(idx);
        }
        return null;
    }

    public final Activity getPreviousActivity() {
        for (int idx = this.currentPlanElementIndex - 1; idx >= 0; --idx) {
            if (!(this.plan.getPlanElements().get(idx) instanceof Activity)) continue;
            return (Activity)this.plan.getPlanElements().get(idx);
        }
        return null;
    }

    @Override
    public final PlanElement getPreviousPlanElement() {
        if (this.currentPlanElementIndex >= 1) {
            return this.plan.getPlanElements().get(this.currentPlanElementIndex - 1);
        }
        return null;
    }

    final int getCurrentPlanElementIndex() {
        return this.currentPlanElementIndex;
    }

    @Override
    public final Plan getCurrentPlan() {
        return this.plan;
    }

    @Override
    public final Id<Person> getId() {
        return this.plan.getPerson().getId();
    }

    @Override
    public final Person getPerson() {
        return this.plan.getPerson();
    }

    public final Scenario getScenario() {
        return this.scenario;
    }

    public final EventsManager getEvents() {
        return this.events;
    }

    final MobsimTimer getSimTimer() {
        return this.simTimer;
    }

    @Override
    public final MobsimVehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    public final void setVehicle(MobsimVehicle vehicle) {
        this.vehicle = vehicle;
    }

    @Override
    public final Id<Link> getCurrentLinkId() {
        return this.currentLinkId;
    }

    final void setCurrentLinkId(Id<Link> linkId) {
        this.currentLinkId = linkId;
    }

    @Override
    public final Id<Link> getDestinationLinkId() {
        return this.getCurrentLeg().getRoute().getEndLinkId();
    }

    @Override
    public final double getActivityEndTime() {
        return this.activityEndTime;
    }

    @Override
    public final MobsimAgent.State getState() {
        return this.state;
    }

    final void setState(MobsimAgent.State state) {
        this.state = state;
    }

    final Leg getCurrentLeg() {
        return (Leg)this.getCurrentPlanElement();
    }

    @Override
    public final int getCurrentLinkIndex() {
        return this.currentLinkIndex;
    }

    final void incCurrentLinkIndex() {
        ++this.currentLinkIndex;
    }

    @Override
    public Facility getCurrentFacility() {
        Activity activity;
        PlanElement pe = this.getCurrentPlanElement();
        if (pe instanceof Activity) {
            activity = (Activity)pe;
        } else if (pe instanceof Leg) {
            activity = this.getPreviousActivity();
        } else {
            throw new RuntimeException("unexpected type of PlanElement");
        }
        return FacilitiesUtils.toFacility(activity, this.scenario.getActivityFacilities());
    }

    @Override
    public Facility getDestinationFacility() {
        PlanElement pe = this.getCurrentPlanElement();
        if (pe instanceof Leg) {
            Activity activity = this.getNextActivity();
            return FacilitiesUtils.toFacility(activity, this.scenario.getActivityFacilities());
        }
        if (pe instanceof Activity) {
            return null;
        }
        throw new RuntimeException("unexpected type of PlanElement");
    }
}

