/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.agents;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.DriverAgent;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.agents.BasicPlanAgentImpl;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.vehicles.Vehicle;

public final class PlanBasedDriverAgentImpl
implements DriverAgent {
    private static final Logger log = Logger.getLogger(PlanBasedDriverAgentImpl.class);
    private BasicPlanAgentImpl basicPlanAgentDelegate;
    private static int expectedLinkWarnCount = 0;
    private Id<Link> cachedNextLinkId = null;

    public PlanBasedDriverAgentImpl(BasicPlanAgentImpl basicAgent) {
        this.basicPlanAgentDelegate = basicAgent;
    }

    @Override
    public final void notifyMoveOverNode(Id<Link> newLinkId) {
        if (expectedLinkWarnCount < 10 && !newLinkId.equals(this.cachedNextLinkId)) {
            log.warn("Agent did not end up on expected link. Ok for within-day replanning agent, otherwise not.  Continuing anyway ... This warning is suppressed after the first 10 warnings.");
            ++expectedLinkWarnCount;
        }
        Gbl.assertNotNull(newLinkId);
        this.basicPlanAgentDelegate.setCurrentLinkId(newLinkId);
        this.basicPlanAgentDelegate.incCurrentLinkIndex();
        this.cachedNextLinkId = null;
    }

    @Override
    public final Id<Link> chooseNextLinkId() {
        if (this.cachedNextLinkId != null && !this.cachedNextLinkId.equals(this.getCurrentLinkId())) {
            return this.cachedNextLinkId;
        }
        if (!(this.basicPlanAgentDelegate.getCurrentLeg().getRoute() instanceof NetworkRoute)) {
            return null;
        }
        List<Id<Link>> routeLinkIds = ((NetworkRoute)this.basicPlanAgentDelegate.getCurrentLeg().getRoute()).getLinkIds();
        if (this.basicPlanAgentDelegate.getCurrentLinkIndex() >= routeLinkIds.size()) {
            if (this.getCurrentLinkId().equals(this.getDestinationLinkId()) && this.basicPlanAgentDelegate.getCurrentLinkIndex() > routeLinkIds.size()) {
                return null;
            }
            this.cachedNextLinkId = this.getDestinationLinkId();
            return this.cachedNextLinkId;
        }
        this.cachedNextLinkId = routeLinkIds.get(this.basicPlanAgentDelegate.getCurrentLinkIndex());
        return this.cachedNextLinkId;
    }

    @Override
    public final boolean isWantingToArriveOnCurrentLink() {
        if (!(this.basicPlanAgentDelegate.getCurrentLeg().getRoute() instanceof NetworkRoute)) {
            return true;
        }
        List<Id<Link>> routeLinkIds = ((NetworkRoute)this.basicPlanAgentDelegate.getCurrentLeg().getRoute()).getLinkIds();
        int routeLinkIdsSize = routeLinkIds.size();
        return this.basicPlanAgentDelegate.getCurrentLinkIndex() >= routeLinkIdsSize && this.getCurrentLinkId().equals(this.getDestinationLinkId());
    }

    public final void resetCaches() {
        this.cachedNextLinkId = null;
        if (this.basicPlanAgentDelegate.getCurrentPlanElement() == null) {
            throw new RuntimeException("encountered unexpected null pointer");
        }
        if (this.basicPlanAgentDelegate.getCurrentPlanElement() instanceof Leg && this.basicPlanAgentDelegate.getCurrentLeg().getRoute() == null) {
            log.error("The agent " + this.getId() + " has no route in its leg. Setting agent state to abort.");
            this.basicPlanAgentDelegate.setState(MobsimAgent.State.ABORT);
        }
        this.basicPlanAgentDelegate.resetCaches();
    }

    @Override
    public Id<Person> getId() {
        return this.basicPlanAgentDelegate.getId();
    }

    @Override
    public Id<Link> getCurrentLinkId() {
        return this.basicPlanAgentDelegate.getCurrentLinkId();
    }

    @Override
    public Id<Link> getDestinationLinkId() {
        return this.basicPlanAgentDelegate.getDestinationLinkId();
    }

    @Override
    public void setVehicle(MobsimVehicle veh) {
        this.basicPlanAgentDelegate.setVehicle(veh);
    }

    @Override
    public MobsimVehicle getVehicle() {
        return this.basicPlanAgentDelegate.getVehicle();
    }

    @Override
    public Id<Vehicle> getPlannedVehicleId() {
        return this.basicPlanAgentDelegate.getPlannedVehicleId();
    }

    @Override
    public String getMode() {
        return this.basicPlanAgentDelegate.getMode();
    }
}

