/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.agents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.mobsim.framework.AgentSource;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.agents.AgentFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicleFactory;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleUtils;

public final class PopulationAgentSource
implements AgentSource {
    private static final Logger log = Logger.getLogger(PopulationAgentSource.class);
    private final Population population;
    private final AgentFactory agentFactory;
    private final QVehicleFactory qVehicleFactory;
    private final QSim qsim;
    private final Collection<String> mainModes;
    private Map<Id<Vehicle>, Id<Link>> seenVehicleIds = new HashMap<Id<Vehicle>, Id<Link>>();

    @Inject
    PopulationAgentSource(Population population, AgentFactory agentFactory, QVehicleFactory qVehicleFactory, QSim qsim) {
        this.population = population;
        this.agentFactory = agentFactory;
        this.qVehicleFactory = qVehicleFactory;
        this.qsim = qsim;
        this.mainModes = qsim.getScenario().getConfig().qsim().getMainModes();
    }

    @Override
    public void insertAgentsIntoMobsim() {
        for (Person person : this.population.getPersons().values()) {
            MobsimAgent agent = this.agentFactory.createMobsimAgentFromPerson(person);
            this.qsim.insertAgentIntoMobsim(agent);
        }
        for (Person person : this.population.getPersons().values()) {
            this.insertVehicles(person);
        }
    }

    private void insertVehicles(Person person) {
        HashMap<String, Id> seenModes = new HashMap<String, Id>();
        for (Leg leg : TripStructureUtils.getLegs((Plan)person.getSelectedPlan())) {
            if (!this.mainModes.contains(leg.getMode())) continue;
            NetworkRoute route = (NetworkRoute)leg.getRoute();
            Id vehicleId = null;
            if (route != null) {
                vehicleId = route.getVehicleId();
            }
            if (vehicleId == null) {
                vehicleId = VehicleUtils.getVehicleId(person, leg.getMode());
                if (route != null) {
                    route.setVehicleId(vehicleId);
                }
            }
            if (seenModes.keySet().contains(leg.getMode())) {
                if (vehicleId != null || route == null) continue;
                vehicleId = (Id)seenModes.get(leg.getMode());
                route.setVehicleId(vehicleId);
                continue;
            }
            seenModes.put(leg.getMode(), vehicleId);
            Vehicle vehicle = this.qsim.getScenario().getVehicles().getVehicles().get(vehicleId);
            if (vehicle == null) {
                String msg = "Could not get the requested vehicle with ID=" + vehicleId + " from the vehicles container. ";
                QSimConfigGroup.VehiclesSource vehiclesSource = this.qsim.getScenario().getConfig().qsim().getVehiclesSource();
                switch (vehiclesSource) {
                    case defaultVehicle: 
                    case modeVehicleTypesFromVehiclesData: {
                        msg = msg + "You are using the config switch qsim.vehiclesSource=" + vehiclesSource.name() + "; this should have worked so " + "please report under matsim.org/faq .";
                        break;
                    }
                    case fromVehiclesData: {
                        msg = msg + "You are using the config switch qsim.vehiclesSource=" + vehiclesSource.name() + "; with that setting, you have to" + " provide all needed vehicles yourself.";
                        break;
                    }
                    default: {
                        throw new RuntimeException("not implemented");
                    }
                }
                throw new RuntimeException(msg);
            }
            Id<Link> vehicleLinkId = this.findVehicleLink(person);
            Id<Link> result = this.seenVehicleIds.get(vehicleId);
            if (result != null) {
                log.info("have seen vehicle with id " + vehicleId + " before; not placing it again.");
                if (result == vehicleLinkId) continue;
                throw new RuntimeException("vehicle placement error: vehicleId=" + vehicleId + "; previous placement link=" + vehicleLinkId + "; current placement link=" + result);
            }
            this.seenVehicleIds.put(vehicleId, vehicleLinkId);
            this.qsim.addParkedVehicle(this.qVehicleFactory.createQVehicle(vehicle), vehicleLinkId);
        }
    }

    private Id<Link> findVehicleLink(Person person) {
        for (PlanElement planElement : ((Plan)person.getSelectedPlan()).getPlanElements()) {
            Leg leg;
            if (planElement instanceof Activity) {
                Config config;
                Activity activity = (Activity)planElement;
                ActivityFacilities facilities = this.qsim.getScenario().getActivityFacilities();
                Id<Link> activityLinkId = PopulationUtils.computeLinkIdFromActivity(activity, facilities, config = this.qsim.getScenario().getConfig());
                if (activityLinkId == null) continue;
                return activityLinkId;
            }
            if (!(planElement instanceof Leg) || (leg = (Leg)planElement).getRoute().getStartLinkId() == null) continue;
            return leg.getRoute().getStartLinkId();
        }
        throw new RuntimeException("Don't know where to put a vehicle for this agent.");
    }
}

