/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.agents;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.mobsim.qsim.agents.BasicPlanAgentImpl;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.core.mobsim.qsim.pt.TransitVehicle;
import org.matsim.pt.config.TransitConfigGroup;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public final class TransitAgentImpl
implements PTPassengerAgent {
    private BasicPlanAgentImpl basicAgentDelegate;
    private final TransitConfigGroup.BoardingAcceptance boardingAcceptance;
    private static final Logger log = Logger.getLogger(TransitAgentImpl.class);

    public TransitAgentImpl(BasicPlanAgentImpl basicAgent) {
        this(basicAgent, TransitConfigGroup.BoardingAcceptance.checkLineAndStop);
    }

    public TransitAgentImpl(BasicPlanAgentImpl basicAgent, TransitConfigGroup.BoardingAcceptance boardingAcceptance) {
        this.basicAgentDelegate = basicAgent;
        this.boardingAcceptance = boardingAcceptance;
    }

    @Override
    public final boolean getExitAtStop(TransitStopFacility stop) {
        ExperimentalTransitRoute route = (ExperimentalTransitRoute)this.basicAgentDelegate.getCurrentLeg().getRoute();
        return route.getEgressStopId().equals(stop.getId());
    }

    @Override
    public final boolean getEnterTransitRoute(TransitLine line, TransitRoute transitRoute, List<TransitRouteStop> stopsToCome, TransitVehicle transitVehicle) {
        ExperimentalTransitRoute route = (ExperimentalTransitRoute)this.basicAgentDelegate.getCurrentLeg().getRoute();
        switch (this.boardingAcceptance) {
            case checkLineAndStop: {
                return line.getId().equals(route.getLineId()) && this.containsId(stopsToCome, route.getEgressStopId());
            }
            case checkStopOnly: {
                return this.containsId(stopsToCome, route.getEgressStopId());
            }
        }
        throw new RuntimeException("not implemented");
    }

    private final boolean containsId(List<TransitRouteStop> stopsToCome, Id<TransitStopFacility> egressStopId) {
        for (TransitRouteStop stop : stopsToCome) {
            if (!egressStopId.equals(stop.getStopFacility().getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final double getWeight() {
        return 1.0;
    }

    @Override
    public final Id<TransitStopFacility> getDesiredAccessStopId() {
        Leg leg = this.basicAgentDelegate.getCurrentLeg();
        if (!(leg.getRoute() instanceof ExperimentalTransitRoute)) {
            log.error("pt-leg has no TransitRoute. Removing agent from simulation. Agent " + this.getId().toString());
            log.info("route: " + leg.getRoute().getClass().getCanonicalName() + " " + leg.getRoute().getRouteDescription());
            return null;
        }
        ExperimentalTransitRoute route = (ExperimentalTransitRoute)leg.getRoute();
        Id<TransitStopFacility> accessStopId = route.getAccessStopId();
        return accessStopId;
    }

    @Override
    public final Id<TransitStopFacility> getDesiredDestinationStopId() {
        ExperimentalTransitRoute route = (ExperimentalTransitRoute)this.basicAgentDelegate.getCurrentLeg().getRoute();
        return route.getEgressStopId();
    }

    @Override
    public Id<Link> getCurrentLinkId() {
        return this.basicAgentDelegate.getCurrentLinkId();
    }

    @Override
    public Id<Link> getDestinationLinkId() {
        return this.basicAgentDelegate.getDestinationLinkId();
    }

    @Override
    public void setVehicle(MobsimVehicle veh) {
        this.basicAgentDelegate.setVehicle(veh);
    }

    @Override
    public MobsimVehicle getVehicle() {
        return this.basicAgentDelegate.getVehicle();
    }

    @Override
    public Id<Vehicle> getPlannedVehicleId() {
        return this.basicAgentDelegate.getPlannedVehicleId();
    }

    @Override
    public Id<Person> getId() {
        return this.basicAgentDelegate.getId();
    }

    @Override
    public String getMode() {
        return this.basicAgentDelegate.getMode();
    }
}

