/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.agents;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.PlanAgent;
import org.matsim.core.mobsim.qsim.ActivityEndRescheduler;
import org.matsim.core.mobsim.qsim.agents.HasModifiablePlan;

public final class WithinDayAgentUtils {
    private static final Logger log = Logger.getLogger(WithinDayAgentUtils.class);

    private WithinDayAgentUtils() {
    }

    public static Integer getCurrentPlanElementIndex(MobsimAgent agent) {
        if (agent instanceof PlanAgent) {
            return ((PlanAgent)((Object)agent)).getCurrentPlan().getPlanElements().indexOf(((PlanAgent)((Object)agent)).getCurrentPlanElement());
        }
        throw new RuntimeException("Sorry, agent is from type " + agent.getClass().toString() + " which does not support getCurrentPlanElementIndex(...). Aborting!");
    }

    public static Integer getCurrentRouteLinkIdIndex(MobsimAgent agent) {
        if (agent instanceof HasModifiablePlan) {
            return ((HasModifiablePlan)((Object)agent)).getCurrentLinkIndex();
        }
        throw new RuntimeException("Sorry, agent is from type " + agent.getClass().toString() + " which does not support getCurrentRouteLinkIdIndex(...). Aborting!");
    }

    public static void resetCaches(MobsimAgent agent) {
        if (!(agent instanceof HasModifiablePlan)) {
            throw new RuntimeException("Sorry, agent is from type " + agent.getClass().toString() + " which does not support resetCaches(...). Aborting!");
        }
        ((HasModifiablePlan)((Object)agent)).resetCaches();
    }

    public static void rescheduleActivityEnd(MobsimAgent agent, Mobsim mobsim) {
        if (!(mobsim instanceof ActivityEndRescheduler)) {
            throw new RuntimeException("mobsim does not support activity end rescheduling; aborting ...");
        }
        ((ActivityEndRescheduler)((Object)mobsim)).rescheduleActivityEnd(agent);
    }

    public static Leg getModifiableCurrentLeg(MobsimAgent agent) {
        PlanElement currentPlanElement = WithinDayAgentUtils.getCurrentPlanElement(agent);
        if (!(currentPlanElement instanceof Leg)) {
            return null;
        }
        return (Leg)currentPlanElement;
    }

    public static Plan getModifiablePlan(MobsimAgent agent) {
        if (agent instanceof HasModifiablePlan) {
            return ((HasModifiablePlan)((Object)agent)).getModifiablePlan();
        }
        throw new RuntimeException("Sorry, agent is from type " + agent.getClass().toString() + " which does not support getModifiablePlan(...). Aborting!");
    }

    public static PlanElement getCurrentPlanElement(MobsimAgent agent) {
        return WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements().get(WithinDayAgentUtils.getCurrentPlanElementIndex(agent));
    }

    public static boolean isOnReplannableCarLeg(MobsimAgent agent) {
        if (!(WithinDayAgentUtils.getCurrentPlanElement(agent) instanceof Leg)) {
            log.info("agent not on leg; returning ... ");
            return false;
        }
        if (!((Leg)WithinDayAgentUtils.getCurrentPlanElement(agent)).getMode().equals("car")) {
            log.info("not a car leg; can only replan car legs; returning ... ");
            return false;
        }
        return true;
    }

    public static Plan printPlan(MobsimAgent agent1) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent1);
        return WithinDayAgentUtils.printPlan(plan);
    }

    public static Plan printPlan(Plan plan) {
        System.err.println("plan=" + plan);
        for (int ii = 0; ii < plan.getPlanElements().size(); ++ii) {
            System.err.println("\t" + ii + ":\t" + plan.getPlanElements().get(ii));
        }
        return plan;
    }

    public static boolean replaceLegBlindly(Plan plan, Leg oldLeg, Leg newLeg) {
        if (plan == null) {
            return false;
        }
        if (oldLeg == null) {
            return false;
        }
        if (newLeg == null) {
            return false;
        }
        int index = plan.getPlanElements().indexOf(oldLeg);
        if (index == -1) {
            return false;
        }
        plan.getPlanElements().remove(index);
        plan.getPlanElements().add(index, newLeg);
        return true;
    }

    public static boolean replaceActivityBlindly(Plan plan, Activity oldActivity, Activity newActivity) {
        if (plan == null) {
            return false;
        }
        if (oldActivity == null) {
            return false;
        }
        if (newActivity == null) {
            return false;
        }
        int index = plan.getPlanElements().indexOf(oldActivity);
        if (index == -1) {
            return false;
        }
        plan.getPlanElements().remove(index);
        plan.getPlanElements().add(index, newActivity);
        return true;
    }

    public static int indexOfPlanElement(MobsimAgent agent, PlanElement pe) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        return planElements.indexOf(pe);
    }

    public static int indexOfNextActivityWithType(MobsimAgent agent, String type) {
        Plan plan = WithinDayAgentUtils.getModifiablePlan(agent);
        List<PlanElement> planElements = plan.getPlanElements();
        for (int index = WithinDayAgentUtils.getCurrentPlanElementIndex(agent).intValue(); index < planElements.size(); ++index) {
            PlanElement pe = planElements.get(index);
            if (!(pe instanceof Activity) || !((Activity)pe).getType().equals(type)) continue;
            return index;
        }
        return -1;
    }

    public static Activity findNextActivityWithType(MobsimAgent agent, String type) {
        int index = WithinDayAgentUtils.indexOfNextActivityWithType(agent, type);
        return (Activity)WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements().get(index);
    }

    public static List<PlanElement> subList(MobsimAgent agent, int fromIndex, int toIndex) {
        return WithinDayAgentUtils.getModifiablePlan(agent).getPlanElements().subList(fromIndex, toIndex);
    }
}

