/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.components;

import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class QSimComponentsConfig {
    private final List<Object> components = new LinkedList<Object>();
    private final Set<Key<?>> keys = new HashSet();

    public void addComponent(Class<? extends Annotation> annotation) {
        this.addComponent(Key.get(Object.class, annotation));
        this.components.add(annotation);
    }

    public void addComponent(Annotation annotation) {
        this.addComponent(Key.get(Object.class, annotation));
        this.components.add(annotation);
    }

    private void addComponent(Key<?> componentKey) {
        if (this.keys.contains(componentKey)) {
            throw new IllegalStateException(this.keyToString(componentKey) + " is already registered.");
        }
        this.keys.add(componentKey);
    }

    public void addNamedComponent(String name) {
        this.addComponent(Names.named(name));
    }

    public void removeComponent(Class<? extends Annotation> annotation) {
        this.addComponent(Key.get(Object.class, annotation));
        this.components.remove(annotation);
    }

    public void removeComponent(Annotation annotation) {
        this.removeComponent(Key.get(Object.class, annotation));
        this.components.remove(annotation);
    }

    private void removeComponent(Key<?> componentKey) {
        if (!this.keys.remove(componentKey)) {
            throw new IllegalStateException(this.keyToString(componentKey) + " is not registered.");
        }
    }

    public void removeNamedComponent(String name) {
        this.removeComponent(Names.named(name));
    }

    public boolean hasComponent(Class<? extends Annotation> annotation) {
        return this.hasComponent(Key.get(Object.class, annotation));
    }

    public boolean hasComponent(Annotation annotation) {
        return this.hasComponent(Key.get(Object.class, annotation));
    }

    private boolean hasComponent(Key<?> componentKey) {
        return this.keys.contains(componentKey);
    }

    public boolean hasNamedComponent(String name) {
        return this.hasComponent(Names.named(name));
    }

    private String keyToString(Key<?> componentKey) {
        return "Annotation" + componentKey.getAnnotation() != null ? " " + componentKey.getAnnotation() : "Type " + componentKey.getAnnotationType();
    }

    public void clear() {
        this.components.clear();
        this.keys.clear();
    }

    public List<Object> getActiveComponents() {
        return Collections.unmodifiableList(this.components);
    }
}

