/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.components;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public class QSimComponentsConfigGroup
extends ConfigGroup {
    public static final String GROUP_NAME = "qsim_components";
    public static final String ACTIVE_COMPONENTS = "activeComponents";
    public static final List<String> DEFAULT_COMPONENTS = Arrays.asList("ActivityEngine", "NetsimEngine", "TeleportationEngine", "PopulationAgentSource", "MessageQueueEngine");
    private List<String> activeComponents = new LinkedList<String>(DEFAULT_COMPONENTS);

    public QSimComponentsConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public final Map<String, String> getComments() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ACTIVE_COMPONENTS, "Defines which components are active and in which order they are registered. Depending on which extensions and contribs you use, it may be necessary to define additional components here. Default is: " + String.join((CharSequence)", ", DEFAULT_COMPONENTS));
        return map;
    }

    public List<String> getActiveComponents() {
        return this.activeComponents;
    }

    public void setActiveComponents(List<String> activeComponents) {
        this.activeComponents = activeComponents;
    }

    @ReflectiveConfigGroup.StringGetter(value="activeComponents")
    public String getActiveComponentsAsString() {
        return String.join((CharSequence)", ", this.activeComponents);
    }

    @ReflectiveConfigGroup.StringSetter(value="activeComponents")
    public void setActiveComponentsAsString(String activeComponents) {
        this.activeComponents = this.interpretQSimComponents(activeComponents);
    }

    private List<String> interpretQSimComponents(String config) {
        List<String> elements = Arrays.asList(config.split(",")).stream().map(String::trim).collect(Collectors.toList());
        if (elements.size() == 1 && elements.get(0).length() == 0) {
            return new LinkedList<String>();
        }
        return elements;
    }
}

