/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.interfaces;

import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.mobsim.qsim.interfaces.TripInfo;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.Facility;

public class TripInfoRequest {
    private final Facility fromFacility;
    private final Facility toFacility;
    private final double time;
    private final TripInfo.TimeInterpretation timeInterpretation;
    private final Activity fromActivity;
    private final Activity toActivity;

    private TripInfoRequest(Scenario scenario, Activity fromActivity, Activity toActivity, double time, TripInfo.TimeInterpretation timeInterpretation) {
        this.fromActivity = fromActivity;
        this.toActivity = toActivity;
        this.fromFacility = FacilitiesUtils.toFacility(fromActivity, scenario.getActivityFacilities());
        this.toFacility = FacilitiesUtils.toFacility(toActivity, scenario.getActivityFacilities());
        this.time = time;
        this.timeInterpretation = timeInterpretation;
    }

    public Facility getFromFacility() {
        return this.fromFacility;
    }

    public Facility getToFacility() {
        return this.toFacility;
    }

    public double getTime() {
        return this.time;
    }

    public TripInfo.TimeInterpretation getTimeInterpretation() {
        return this.timeInterpretation;
    }

    public Activity getFromActivity() {
        return this.fromActivity;
    }

    public Activity getToActivity() {
        return this.toActivity;
    }

    public static class Builder {
        private final Scenario scenario;
        private double time;
        private TripInfo.TimeInterpretation timeInterpretation = TripInfo.TimeInterpretation.departure;
        private Activity fromActivity;
        private Activity toActivity;

        public Builder(Scenario scenario) {
            this.scenario = scenario;
        }

        public Builder setFromActivity(Activity fromActivity) {
            this.fromActivity = fromActivity;
            return this;
        }

        public Builder setToActivity(Activity toActivity) {
            this.toActivity = toActivity;
            return this;
        }

        public Builder setTime(double time) {
            this.time = time;
            return this;
        }

        public Builder setTimeInterpretation(TripInfo.TimeInterpretation timeInterpretation) {
            this.timeInterpretation = timeInterpretation;
            return this;
        }

        public TripInfoRequest createRequest() {
            return new TripInfoRequest(this.scenario, this.fromActivity, this.toActivity, this.time, this.timeInterpretation);
        }
    }
}

