/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.jdeqsimengine;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.framework.HasPerson;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.jdeqsim.JDEQSimConfigGroup;
import org.matsim.core.mobsim.jdeqsim.JDEQSimulation;
import org.matsim.core.mobsim.jdeqsim.Road;
import org.matsim.core.mobsim.jdeqsim.Vehicle;
import org.matsim.core.mobsim.jdeqsim.util.Timer;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.interfaces.ActivityHandler;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.mobsim.qsim.jdeqsimengine.SteppableScheduler;

class JDEQSimEngine
implements MobsimEngine,
ActivityHandler {
    private static final Logger log = Logger.getLogger(JDEQSimEngine.class);
    private JDEQSimConfigGroup config;
    private Scenario scenario;
    private EventsManager eventsManager;
    private Timer t;
    private SteppableScheduler scheduler;
    private int numberOfAgents = 0;
    private AgentCounter agentCounter;

    public JDEQSimEngine(JDEQSimConfigGroup config, Scenario scenario, EventsManager eventsManager, AgentCounter agentCounter, SteppableScheduler scheduler) {
        this.config = config;
        this.scheduler = scheduler;
        this.scenario = scenario;
        this.eventsManager = eventsManager;
        this.agentCounter = agentCounter;
    }

    @Override
    public void onPrepareSim() {
        new JDEQSimulation(this.config, this.scenario, this.eventsManager);
        this.t = new Timer();
        this.t.startTimer();
        Road.setAllRoads(new HashMap<Id<Link>, Road>());
        for (Link link : this.scenario.getNetwork().getLinks().values()) {
            Road road = new Road(this.scheduler, link);
            Road.getAllRoads().put(link.getId(), road);
        }
    }

    @Override
    public boolean handleActivity(MobsimAgent agent) {
        new Vehicle(this.scheduler, ((HasPerson)((Object)agent)).getPerson(), this.scenario.getConfig().plans().getActivityDurationInterpretation());
        ++this.numberOfAgents;
        return true;
    }

    @Override
    public void afterSim() {
        this.t.endTimer();
        log.info("Time needed for one iteration (only JDEQSimulation part): " + this.t.getMeasuredTime() + "[ms]");
    }

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
    }

    @Override
    public void doSimStep(double time) {
        this.scheduler.doSimStep(time);
        if (this.scheduler.isFinished()) {
            while (this.numberOfAgents > 0) {
                this.agentCounter.decLiving();
                --this.numberOfAgents;
            }
        }
    }

    @Override
    public void rescheduleActivityEnd(MobsimAgent agent) {
    }
}

