/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.jdeqsimengine;

import javax.inject.Inject;
import org.matsim.core.mobsim.framework.Steppable;
import org.matsim.core.mobsim.jdeqsim.Message;
import org.matsim.core.mobsim.jdeqsim.MessageQueue;
import org.matsim.core.mobsim.jdeqsim.Scheduler;

public class SteppableScheduler
extends Scheduler
implements Steppable {
    private Message lookahead;
    private boolean finished = false;

    @Inject
    public SteppableScheduler(MessageQueue queue) {
        super(queue);
    }

    @Override
    public void doSimStep(double time) {
        this.finished = false;
        if (this.lookahead != null && time < this.lookahead.getMessageArrivalTime()) {
            return;
        }
        if (this.lookahead != null) {
            this.lookahead.processEvent();
            this.lookahead.handleMessage();
            this.lookahead = null;
        }
        while (!this.queue.isEmpty()) {
            Message m3 = this.queue.getNextMessage();
            if (m3 != null && m3.getMessageArrivalTime() <= time) {
                m3.processEvent();
                m3.handleMessage();
                continue;
            }
            this.lookahead = m3;
            return;
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

