/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.framework.PlanAgent;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.agents.PersonDriverAgentImpl;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.PassengerAccessEgressImpl;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgent;
import org.matsim.core.mobsim.qsim.pt.TransitStopAgentTracker;
import org.matsim.core.mobsim.qsim.pt.TransitVehicle;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public abstract class AbstractTransitDriverAgent
implements TransitDriverAgent,
PlanAgent {
    private static final Logger log = Logger.getLogger(AbstractTransitDriverAgent.class);
    private EventsManager eventsManager;
    private TransitVehicle vehicle = null;
    private int nextLinkIndex = 0;
    private Person dummyPerson;
    private TransitRouteStop currentStop = null;
    protected TransitRouteStop nextStop;
    private ListIterator<TransitRouteStop> stopIterator;
    private final InternalInterface internalInterface;
    private final PassengerAccessEgressImpl accessEgress;
    MobsimAgent.State state = MobsimAgent.State.ACTIVITY;

    @Override
    public final MobsimAgent.State getState() {
        return this.state;
    }

    @Override
    public abstract void endLegAndComputeNextState(double var1);

    protected abstract NetworkRoute getCarRoute();

    protected abstract TransitLine getTransitLine();

    public abstract TransitRoute getTransitRoute();

    protected abstract Departure getDeparture();

    @Override
    public abstract double getActivityEndTime();

    AbstractTransitDriverAgent(InternalInterface internalInterface, TransitStopAgentTracker agentTracker2) {
        this.internalInterface = internalInterface;
        Scenario scenario = internalInterface.getMobsim().getScenario();
        this.eventsManager = internalInterface.getMobsim().getEventsManager();
        this.accessEgress = new PassengerAccessEgressImpl(this.internalInterface, agentTracker2, scenario, this.eventsManager);
    }

    final void init() {
        if (this.getTransitRoute() != null) {
            this.stopIterator = this.getTransitRoute().getStops().listIterator();
            this.nextStop = this.stopIterator.hasNext() ? this.stopIterator.next() : null;
        } else {
            this.nextStop = null;
        }
        this.nextLinkIndex = 0;
    }

    final void setDriver(Person personImpl) {
        this.dummyPerson = personImpl;
    }

    @Override
    public final Id<Link> chooseNextLinkId() {
        NetworkRoute netR = this.getCarRoute();
        List<Id<Link>> linkIds = netR.getLinkIds();
        if (this.nextLinkIndex < linkIds.size()) {
            return linkIds.get(this.nextLinkIndex);
        }
        if (this.nextLinkIndex == linkIds.size()) {
            if (linkIds.size() == 0 && netR.getStartLinkId().equals(netR.getEndLinkId())) {
                return null;
            }
            return netR.getEndLinkId();
        }
        this.assertAllStopsServed();
        return null;
    }

    @Override
    public final void setStateToAbort(double now) {
        this.state = MobsimAgent.State.ABORT;
    }

    @Override
    public final Id<Link> getCurrentLinkId() {
        int currentLinkIndex = this.nextLinkIndex - 1;
        if (currentLinkIndex < 0) {
            return this.getCarRoute().getStartLinkId();
        }
        if (currentLinkIndex >= this.getCarRoute().getLinkIds().size()) {
            return this.getCarRoute().getEndLinkId();
        }
        return this.getCarRoute().getLinkIds().get(currentLinkIndex);
    }

    @Override
    public final void notifyMoveOverNode(Id<Link> nextLinkId) {
        ++this.nextLinkIndex;
    }

    @Override
    public final TransitStopFacility getNextTransitStop() {
        if (this.nextStop == null) {
            return null;
        }
        return this.nextStop.getStopFacility();
    }

    @Override
    public double handleTransitStop(TransitStopFacility stop, double now) {
        this.assertExpectedStop(stop);
        this.processEventVehicleArrives(stop, now);
        TransitRoute route = this.getTransitRoute();
        List<TransitRouteStop> stopsToCome = route.getStops().subList(this.stopIterator.nextIndex(), route.getStops().size());
        double stopTime = this.accessEgress.calculateStopTimeAndTriggerBoarding(this.getTransitRoute(), this.getTransitLine(), this.vehicle, stop, stopsToCome, now);
        if (stopTime == 0.0) {
            stopTime = this.longerStopTimeIfWeAreAheadOfSchedule(now, stopTime);
        }
        if (stopTime == 0.0) {
            this.depart(now);
        }
        return stopTime;
    }

    final void sendTransitDriverStartsEvent(double now) {
        if (this.internalInterface != null) {
            if (this.getTransitLine() == null) {
                this.eventsManager.processEvent(new TransitDriverStartsEvent(now, this.dummyPerson.getId(), this.vehicle.getId(), Id.create("Wenden", TransitLine.class), Id.create("Wenden", TransitRoute.class), Id.create("Wenden", Departure.class)));
            } else {
                this.eventsManager.processEvent(new TransitDriverStartsEvent(now, this.dummyPerson.getId(), this.vehicle.getId(), this.getTransitLine().getId(), this.getTransitRoute().getId(), this.getDeparture().getId()));
            }
        }
    }

    @Override
    public void notifyArrivalOnLinkByNonNetworkMode(Id<Link> linkId) {
    }

    final Person getPerson() {
        return this.dummyPerson;
    }

    @Override
    public final TransitVehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    public final void setVehicle(MobsimVehicle vehicle) {
        this.vehicle = (TransitVehicle)vehicle;
    }

    private void processEventVehicleArrives(TransitStopFacility stop, double now) {
        if (this.currentStop == null) {
            this.currentStop = this.nextStop;
            double delay = now - this.getDeparture().getDepartureTime();
            if (!Double.isNaN(this.currentStop.getArrivalOffset()) || !Double.isInfinite(this.currentStop.getArrivalOffset())) {
                delay -= this.currentStop.getArrivalOffset();
            } else if (!Double.isNaN(this.currentStop.getDepartureOffset()) || !Double.isInfinite(this.currentStop.getDepartureOffset())) {
                delay -= this.currentStop.getDepartureOffset();
            } else {
                log.warn("Could not calculate delay!");
            }
            this.eventsManager.processEvent(new VehicleArrivesAtFacilityEvent(now, this.vehicle.getVehicle().getId(), stop.getId(), delay));
        }
    }

    private void assertExpectedStop(TransitStopFacility stop) {
        if (stop != this.nextStop.getStopFacility()) {
            throw new RuntimeException("Expected different stop.");
        }
    }

    protected double longerStopTimeIfWeAreAheadOfSchedule(double now, double stopTime) {
        double earliestDepTime;
        if (this.nextStop.isAwaitDepartureTime() && this.nextStop.getDepartureOffset() != Double.NEGATIVE_INFINITY && now + stopTime < (earliestDepTime = this.getActivityEndTime() + this.nextStop.getDepartureOffset())) {
            return earliestDepTime - now;
        }
        return stopTime;
    }

    private boolean isBadDouble(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    private void depart(double now) {
        double delay = now - this.getDeparture().getDepartureTime();
        if (this.isBadDouble(this.getDeparture().getDepartureTime())) {
            delay = 0.0;
        }
        if (!this.isBadDouble(this.currentStop.getDepartureOffset())) {
            delay -= this.currentStop.getDepartureOffset();
        } else if (!this.isBadDouble(this.currentStop.getArrivalOffset())) {
            delay -= this.currentStop.getArrivalOffset();
        } else {
            log.warn("Could not calculate delay!");
        }
        this.eventsManager.processEvent(new VehicleDepartsAtFacilityEvent(now, this.vehicle.getVehicle().getId(), this.currentStop.getStopFacility().getId(), delay));
        TransitRouteStop transitRouteStop = this.nextStop = this.stopIterator.hasNext() ? this.stopIterator.next() : null;
        if (this.nextStop == null) {
            this.assertVehicleIsEmpty();
        }
        this.currentStop = null;
    }

    private void assertAllStopsServed() {
        if (this.nextStop != null) {
            RuntimeException e = new RuntimeException("Transit vehicle is not yet at last stop! vehicle-id = " + this.vehicle.getVehicle().getId() + "; next-stop = " + this.nextStop.getStopFacility().getId());
            log.error(e);
            throw e;
        }
    }

    private void assertVehicleIsEmpty() {
        if (this.vehicle.getPassengers().size() > 0) {
            RuntimeException e = new RuntimeException("Transit vehicle is at last stop but still contains passengers that did not leave the vehicle!");
            log.error("Transit vehicle must be empty after last stop! vehicle-id = " + this.vehicle.getVehicle().getId(), e);
            for (PassengerAgent passengerAgent : this.vehicle.getPassengers()) {
                if (!(passengerAgent instanceof PersonDriverAgentImpl)) continue;
                log.error("Agent is still in transit vehicle: agent-id = " + ((PersonDriverAgentImpl)passengerAgent).getPerson().getId());
            }
            throw e;
        }
    }

    final NetworkRouteWrapper getWrappedCarRoute(NetworkRoute carRoute) {
        return new NetworkRouteWrapper(carRoute);
    }

    @Override
    public Id<Person> getId() {
        return this.dummyPerson.getId();
    }

    abstract Leg getCurrentLeg();

    private final class NetworkRouteWrapper
    implements NetworkRoute,
    Cloneable {
        private final NetworkRoute delegate;

        NetworkRouteWrapper(NetworkRoute route) {
            this.delegate = route;
        }

        @Override
        public List<Id<Link>> getLinkIds() {
            return this.delegate.getLinkIds();
        }

        @Override
        public NetworkRoute getSubRoute(Id<Link> fromLinkId, Id<Link> toLinkId) {
            return this.delegate.getSubRoute(fromLinkId, toLinkId);
        }

        @Override
        public double getTravelCost() {
            return this.delegate.getTravelCost();
        }

        @Override
        public Id<Vehicle> getVehicleId() {
            return AbstractTransitDriverAgent.this.vehicle.getVehicle().getId();
        }

        @Override
        public void setLinkIds(Id<Link> startLinkId, List<Id<Link>> srcRoute, Id<Link> endLinkId) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public void setTravelCost(double travelCost) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public void setVehicleId(Id<Vehicle> vehicleId) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public void setEndLinkId(Id<Link> linkId) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public void setStartLinkId(Id<Link> linkId) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public void setRouteDescription(String routeDescription) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public String getRouteDescription() {
            return this.delegate.getRouteDescription();
        }

        @Override
        public String getRouteType() {
            return this.delegate.getRouteType();
        }

        @Override
        @Deprecated
        public double getDistance() {
            return this.delegate.getDistance();
        }

        @Override
        public Id<Link> getEndLinkId() {
            return this.delegate.getEndLinkId();
        }

        @Override
        public Id<Link> getStartLinkId() {
            return this.delegate.getStartLinkId();
        }

        @Override
        @Deprecated
        public double getTravelTime() {
            return this.delegate.getTravelTime();
        }

        @Override
        public void setDistance(double distance) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public void setTravelTime(double travelTime) {
            throw new UnsupportedOperationException("read only route.");
        }

        @Override
        public NetworkRouteWrapper clone() {
            try {
                return (NetworkRouteWrapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

