/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.core.mobsim.qsim.pt.PassengerAccessEgress;
import org.matsim.core.mobsim.qsim.pt.TransitStopHandler;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleType;

public class ComplexTransitStopHandler
implements TransitStopHandler {
    private static final Logger log = Logger.getLogger(ComplexTransitStopHandler.class);
    private boolean doorsOpen = false;
    private double passengersLeavingTimeFraction = 0.0;
    private double passengersEnteringTimeFraction = 0.0;
    private final double personEntersTime;
    private final double personLeavesTime;
    private final VehicleType.DoorOperationMode doorOperationMode;
    private static final double openDoorsDuration = 1.0;
    private static final double closeDoorsDuration = 1.0;

    ComplexTransitStopHandler(Vehicle vehicle) {
        this.personEntersTime = vehicle.getType().getAccessTime();
        this.personLeavesTime = vehicle.getType().getEgressTime();
        this.doorOperationMode = vehicle.getType().getDoorOperationMode();
    }

    @Override
    public double handleTransitStop(TransitStopFacility stop, double now, List<PTPassengerAgent> leavingPassengers, List<PTPassengerAgent> enteringPassengers, PassengerAccessEgress handler, MobsimVehicle vehicle) {
        if (this.doorOperationMode == VehicleType.DoorOperationMode.parallel) {
            return this.handleParallelStop(stop, now, leavingPassengers, enteringPassengers, handler, vehicle);
        }
        if (this.doorOperationMode == VehicleType.DoorOperationMode.serial) {
            return this.handleSerialStop(stop, now, leavingPassengers, enteringPassengers, handler, vehicle);
        }
        log.info("Unimplemented door operation mode " + (Object)((Object)this.doorOperationMode) + " set. Using parralel mode as default.");
        return this.handleParallelStop(stop, now, leavingPassengers, enteringPassengers, handler, vehicle);
    }

    private double handleSerialStop(TransitStopFacility stop, double now, List<PTPassengerAgent> leavingPassengers, List<PTPassengerAgent> enteringPassengers, PassengerAccessEgress handler, MobsimVehicle vehicle) {
        double stopTime = 0.0;
        int cntEgress = leavingPassengers.size();
        int cntAccess = enteringPassengers.size();
        if (!this.doorsOpen) {
            if (cntAccess > 0 || cntEgress > 0) {
                this.doorsOpen = true;
                stopTime = 1.0;
            } else {
                stopTime = 0.0;
            }
        } else if (cntAccess > 0 || cntEgress > 0) {
            if (cntEgress > 0) {
                if (this.passengersLeavingTimeFraction < 1.0) {
                    while (this.passengersLeavingTimeFraction < 1.0 && leavingPassengers.size() != 0 && handler.handlePassengerLeaving(leavingPassengers.get(0), vehicle, stop.getLinkId(), now)) {
                        leavingPassengers.remove(0);
                        this.passengersLeavingTimeFraction += this.personLeavesTime;
                    }
                    this.passengersLeavingTimeFraction -= 1.0;
                    stopTime = 1.0;
                } else {
                    this.passengersLeavingTimeFraction -= 1.0;
                    stopTime = 1.0;
                }
            } else {
                this.passengersLeavingTimeFraction -= 1.0;
                this.passengersLeavingTimeFraction = Math.max(0.0, this.passengersLeavingTimeFraction);
                if (cntAccess > 0) {
                    if (this.passengersEnteringTimeFraction < 1.0) {
                        while (this.passengersEnteringTimeFraction < 1.0 && enteringPassengers.size() != 0 && handler.handlePassengerEntering(enteringPassengers.get(0), vehicle, stop.getId(), now)) {
                            enteringPassengers.remove(0);
                            this.passengersEnteringTimeFraction += this.personEntersTime;
                        }
                        this.passengersEnteringTimeFraction -= 1.0;
                        stopTime = 1.0;
                    } else {
                        this.passengersEnteringTimeFraction -= 1.0;
                        stopTime = 1.0;
                    }
                } else {
                    this.passengersEnteringTimeFraction -= 1.0;
                    this.passengersEnteringTimeFraction = Math.max(0.0, this.passengersEnteringTimeFraction);
                }
            }
        } else {
            if (this.passengersEnteringTimeFraction < 1.0 && this.passengersLeavingTimeFraction < 1.0) {
                this.doorsOpen = false;
                this.passengersEnteringTimeFraction = 0.0;
                this.passengersLeavingTimeFraction = 0.0;
                stopTime = 1.0;
            }
            if (this.passengersEnteringTimeFraction >= 1.0) {
                this.passengersEnteringTimeFraction -= 1.0;
                stopTime = 1.0;
            }
            if (this.passengersLeavingTimeFraction >= 1.0) {
                this.passengersLeavingTimeFraction -= 1.0;
                stopTime = 1.0;
            }
        }
        return stopTime;
    }

    private double handleParallelStop(TransitStopFacility stop, double now, List<PTPassengerAgent> leavingPassengers, List<PTPassengerAgent> enteringPassengers, PassengerAccessEgress handler, MobsimVehicle vehicle) {
        double stopTime = 0.0;
        int cntEgress = leavingPassengers.size();
        int cntAccess = enteringPassengers.size();
        if (!this.doorsOpen) {
            if (cntAccess > 0 || cntEgress > 0) {
                this.doorsOpen = true;
                stopTime = 1.0;
            } else {
                stopTime = 0.0;
            }
        } else if (cntAccess > 0 || cntEgress > 0) {
            if (cntAccess > 0) {
                if (this.passengersEnteringTimeFraction < 1.0) {
                    while (this.passengersEnteringTimeFraction < 1.0 && enteringPassengers.size() != 0 && handler.handlePassengerEntering(enteringPassengers.get(0), vehicle, stop.getId(), now)) {
                        enteringPassengers.remove(0);
                        this.passengersEnteringTimeFraction += this.personEntersTime;
                    }
                    this.passengersEnteringTimeFraction -= 1.0;
                    stopTime = 1.0;
                } else {
                    this.passengersEnteringTimeFraction -= 1.0;
                    stopTime = 1.0;
                }
            } else {
                this.passengersEnteringTimeFraction -= 1.0;
                this.passengersEnteringTimeFraction = Math.max(0.0, this.passengersEnteringTimeFraction);
            }
            if (cntEgress > 0) {
                if (this.passengersLeavingTimeFraction < 1.0) {
                    while (this.passengersLeavingTimeFraction < 1.0 && leavingPassengers.size() != 0 && handler.handlePassengerLeaving(leavingPassengers.get(0), vehicle, stop.getLinkId(), now)) {
                        leavingPassengers.remove(0);
                        this.passengersLeavingTimeFraction += this.personLeavesTime;
                    }
                    this.passengersLeavingTimeFraction -= 1.0;
                    stopTime = 1.0;
                } else {
                    this.passengersLeavingTimeFraction -= 1.0;
                    stopTime = 1.0;
                }
            } else {
                this.passengersLeavingTimeFraction -= 1.0;
                this.passengersLeavingTimeFraction = Math.max(0.0, this.passengersLeavingTimeFraction);
            }
        } else {
            if (this.passengersEnteringTimeFraction < 1.0 && this.passengersLeavingTimeFraction < 1.0) {
                this.doorsOpen = false;
                this.passengersEnteringTimeFraction = 0.0;
                this.passengersLeavingTimeFraction = 0.0;
                stopTime = 1.0;
            }
            if (this.passengersEnteringTimeFraction >= 1.0) {
                this.passengersEnteringTimeFraction -= 1.0;
                stopTime = 1.0;
            }
            if (this.passengersLeavingTimeFraction >= 1.0) {
                this.passengersLeavingTimeFraction -= 1.0;
                stopTime = 1.0;
            }
        }
        return stopTime;
    }
}

