/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.BoardingDeniedEvent;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.core.mobsim.qsim.pt.PassengerAccessEgress;
import org.matsim.core.mobsim.qsim.pt.TransitStopAgentTracker;
import org.matsim.core.mobsim.qsim.pt.TransitStopHandler;
import org.matsim.core.mobsim.qsim.pt.TransitVehicle;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

class PassengerAccessEgressImpl
implements PassengerAccessEgress {
    private final InternalInterface internalInterface;
    private final TransitStopAgentTracker agentTracker;
    private final boolean isGeneratingDeniedBoardingEvents;
    private Set<PTPassengerAgent> agentsDeniedToBoard = null;
    private Scenario scenario;
    private EventsManager eventsManager;

    PassengerAccessEgressImpl(InternalInterface internalInterface, TransitStopAgentTracker agentTracker, Scenario scenario, EventsManager eventsManager) {
        this.internalInterface = internalInterface;
        this.agentTracker = agentTracker;
        this.scenario = scenario;
        this.eventsManager = eventsManager;
        this.isGeneratingDeniedBoardingEvents = this.scenario.getConfig().vspExperimental().isGeneratingBoardingDeniedEvents();
        if (this.isGeneratingDeniedBoardingEvents) {
            this.agentsDeniedToBoard = new HashSet<PTPassengerAgent>();
        }
    }

    double calculateStopTimeAndTriggerBoarding(TransitRoute transitRoute, TransitLine transitLine, TransitVehicle vehicle, TransitStopFacility stop, List<TransitRouteStop> stopsToCome, double now) {
        ArrayList<PTPassengerAgent> passengersLeaving = this.findPassengersLeaving(vehicle, stop);
        int freeCapacity = vehicle.getPassengerCapacity() - vehicle.getPassengers().size() + passengersLeaving.size();
        List<PTPassengerAgent> passengersEntering = this.findPassengersEntering(transitRoute, transitLine, vehicle, stop, stopsToCome, freeCapacity, now);
        TransitStopHandler stopHandler = vehicle.getStopHandler();
        double stopTime = stopHandler.handleTransitStop(stop, now, passengersLeaving, passengersEntering, this, vehicle);
        if (stopTime == 0.0 && this.isGeneratingDeniedBoardingEvents) {
            this.fireBoardingDeniedEvents(vehicle, now);
            this.agentsDeniedToBoard.clear();
        }
        return stopTime;
    }

    private void fireBoardingDeniedEvents(TransitVehicle vehicle, double now) {
        Id<Vehicle> vehicleId = vehicle.getId();
        for (PTPassengerAgent agent : this.agentsDeniedToBoard) {
            Id<Person> agentId = agent.getId();
            this.eventsManager.processEvent(new BoardingDeniedEvent(now, agentId, vehicleId));
        }
    }

    private List<PTPassengerAgent> findPassengersEntering(TransitRoute transitRoute, TransitLine transitLine, TransitVehicle vehicle, TransitStopFacility stop, List<TransitRouteStop> stopsToCome, int freeCapacity, double now) {
        ArrayList<PTPassengerAgent> passengersEntering = new ArrayList<PTPassengerAgent>();
        if (this.isGeneratingDeniedBoardingEvents) {
            for (PTPassengerAgent agent : this.agentTracker.getAgentsAtFacility(stop.getId())) {
                if (!agent.getEnterTransitRoute(transitLine, transitRoute, stopsToCome, vehicle)) continue;
                if (freeCapacity >= 1) {
                    passengersEntering.add(agent);
                    --freeCapacity;
                    continue;
                }
                this.agentsDeniedToBoard.add(agent);
            }
        } else {
            for (PTPassengerAgent agent : this.agentTracker.getAgentsAtFacility(stop.getId())) {
                if (freeCapacity != 0) {
                    if (!agent.getEnterTransitRoute(transitLine, transitRoute, stopsToCome, vehicle)) continue;
                    passengersEntering.add(agent);
                    --freeCapacity;
                    continue;
                }
                break;
            }
        }
        return passengersEntering;
    }

    private ArrayList<PTPassengerAgent> findPassengersLeaving(TransitVehicle vehicle, TransitStopFacility stop) {
        ArrayList<PTPassengerAgent> passengersLeaving = new ArrayList<PTPassengerAgent>();
        for (PassengerAgent passengerAgent : vehicle.getPassengers()) {
            if (!((PTPassengerAgent)passengerAgent).getExitAtStop(stop)) continue;
            passengersLeaving.add((PTPassengerAgent)passengerAgent);
        }
        return passengersLeaving;
    }

    @Override
    public boolean handlePassengerEntering(PTPassengerAgent passenger, MobsimVehicle vehicle, Id<TransitStopFacility> fromStopFacilityId, double time) {
        boolean handled = vehicle.addPassenger(passenger);
        if (handled) {
            this.agentTracker.removeAgentFromStop(passenger, fromStopFacilityId);
            MobsimAgent planAgent = (MobsimAgent)((Object)passenger);
            Id<Person> agentId = planAgent.getId();
            Id<Link> linkId = planAgent.getCurrentLinkId();
            this.internalInterface.unregisterAdditionalAgentOnLink(agentId, linkId);
            MobsimDriverAgent agent = (MobsimDriverAgent)((Object)passenger);
            passenger.setVehicle(vehicle);
            this.eventsManager.processEvent(new PersonEntersVehicleEvent(time, agent.getId(), vehicle.getVehicle().getId()));
        }
        return handled;
    }

    @Override
    public boolean handlePassengerLeaving(PTPassengerAgent passenger, MobsimVehicle vehicle, Id<Link> toLinkId, double time) {
        boolean handled = vehicle.removePassenger(passenger);
        if (handled) {
            passenger.setVehicle(null);
            this.eventsManager.processEvent(new PersonLeavesVehicleEvent(time, passenger.getId(), vehicle.getVehicle().getId()));
            MobsimAgent agent = (MobsimAgent)((Object)passenger);
            agent.notifyArrivalOnLinkByNonNetworkMode(toLinkId);
            agent.endLegAndComputeNextState(time);
            this.internalInterface.arrangeNextAgentState(agent);
        }
        return handled;
    }
}

