/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.List;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.core.mobsim.qsim.pt.PassengerAccessEgress;
import org.matsim.core.mobsim.qsim.pt.TransitStopHandler;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class SimpleTransitStopHandler
implements TransitStopHandler {
    private TransitStopFacility lastHandledStop = null;

    @Override
    public double handleTransitStop(TransitStopFacility stop, double now, List<PTPassengerAgent> leavingPassengers, List<PTPassengerAgent> enteringPassengers, PassengerAccessEgress accessEgress, MobsimVehicle vehicle) {
        int cntEgress = leavingPassengers.size();
        int cntAccess = enteringPassengers.size();
        double stopTime = 0.0;
        if (cntAccess > 0 || cntEgress > 0) {
            stopTime = cntAccess * 4 + cntEgress * 2;
            if (this.lastHandledStop != stop) {
                stopTime += 15.0;
            }
            for (PTPassengerAgent passenger : leavingPassengers) {
                accessEgress.handlePassengerLeaving(passenger, vehicle, stop.getLinkId(), now);
            }
            for (PTPassengerAgent passenger : enteringPassengers) {
                accessEgress.handlePassengerEntering(passenger, vehicle, stop.getId(), now);
            }
        }
        this.lastHandledStop = stop;
        return stopTime;
    }
}

