/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.Iterator;
import java.util.ListIterator;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.pt.AbstractTransitDriverAgent;
import org.matsim.core.mobsim.qsim.pt.TransitStopAgentTracker;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.Facility;
import org.matsim.pt.Umlauf;
import org.matsim.pt.UmlaufStueckI;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.vehicles.Vehicle;

public class TransitDriverAgentImpl
extends AbstractTransitDriverAgent {
    private final EventsManager eventsManager;
    private final Umlauf umlauf;
    private final Iterator<UmlaufStueckI> iUmlaufStueck;
    private final ListIterator<PlanElement> iPlanElement;
    private NetworkRoute carRoute;
    private double departureTime;
    private PlanElement currentPlanElement;
    private TransitLine transitLine;
    private TransitRoute transitRoute;
    private Departure departure;
    private Scenario scenario;

    public TransitDriverAgentImpl(Umlauf umlauf, String transportMode, TransitStopAgentTracker thisAgentTracker, InternalInterface internalInterface) {
        super(internalInterface, thisAgentTracker);
        this.umlauf = umlauf;
        this.eventsManager = internalInterface.getMobsim().getEventsManager();
        this.scenario = internalInterface.getMobsim().getScenario();
        this.iUmlaufStueck = this.umlauf.getUmlaufStuecke().iterator();
        Person driverPerson = PopulationUtils.getFactory().createPerson(Id.create("pt_" + umlauf.getId(), Person.class));
        PlanBuilder planBuilder = new PlanBuilder();
        for (UmlaufStueckI umlaufStueck : umlauf.getUmlaufStuecke()) {
            NetworkRoute carRoute2 = umlaufStueck.getCarRoute();
            Gbl.assertNotNull(carRoute2);
            planBuilder.addTrip(this.getWrappedCarRoute(carRoute2), transportMode);
        }
        Plan plan = planBuilder.build();
        driverPerson.addPlan(plan);
        driverPerson.setSelectedPlan(plan);
        this.setDriver(driverPerson);
        this.iPlanElement = plan.getPlanElements().listIterator();
        this.currentPlanElement = this.iPlanElement.next();
        this.setNextLeg();
    }

    @Override
    public void endActivityAndComputeNextState(double now) {
        this.currentPlanElement = this.iPlanElement.next();
        this.sendTransitDriverStartsEvent(now);
        this.state = MobsimAgent.State.LEG;
    }

    @Override
    public void endLegAndComputeNextState(double now) {
        this.eventsManager.processEvent(new PersonArrivalEvent(now, this.getId(), this.getDestinationLinkId(), this.getCurrentLeg().getMode()));
        this.currentPlanElement = this.iPlanElement.next();
        if (this.iUmlaufStueck.hasNext()) {
            this.setNextLeg();
            if (this.departureTime < now) {
                this.departureTime = now;
            }
            this.state = MobsimAgent.State.ACTIVITY;
        } else {
            this.state = MobsimAgent.State.ACTIVITY;
            this.departureTime = Double.POSITIVE_INFINITY;
        }
    }

    private void setNextLeg() {
        UmlaufStueckI umlaufStueck = this.iUmlaufStueck.next();
        if (umlaufStueck.isFahrt()) {
            this.setLeg(umlaufStueck.getLine(), umlaufStueck.getRoute(), umlaufStueck.getDeparture());
        } else {
            this.setWenden(umlaufStueck.getCarRoute());
        }
        this.init();
    }

    private void setWenden(NetworkRoute carRoute) {
        this.transitLine = null;
        this.transitRoute = null;
        this.departure = null;
        this.carRoute = carRoute;
    }

    private void setLeg(TransitLine line, TransitRoute route, Departure departure) {
        this.transitLine = line;
        this.transitRoute = route;
        this.departure = departure;
        this.departureTime = departure.getDepartureTime();
        this.carRoute = route.getRoute();
    }

    @Override
    Leg getCurrentLeg() {
        return (Leg)this.currentPlanElement;
    }

    @Override
    public Double getExpectedTravelTime() {
        return ((Leg)this.currentPlanElement).getTravelTime();
    }

    @Override
    public Double getExpectedTravelDistance() {
        return ((Leg)this.currentPlanElement).getRoute().getDistance();
    }

    @Override
    public String getMode() {
        return ((Leg)this.currentPlanElement).getMode();
    }

    @Override
    public Id<Vehicle> getPlannedVehicleId() {
        Route route = ((Leg)this.currentPlanElement).getRoute();
        return ((NetworkRoute)route).getVehicleId();
    }

    @Override
    public PlanElement getCurrentPlanElement() {
        return this.currentPlanElement;
    }

    @Override
    public PlanElement getNextPlanElement() {
        if (this.iPlanElement.hasNext()) {
            PlanElement next = this.iPlanElement.next();
            this.iPlanElement.previous();
            return next;
        }
        return null;
    }

    @Override
    public PlanElement getPreviousPlanElement() {
        if (this.iPlanElement.hasPrevious()) {
            PlanElement prev = this.iPlanElement.previous();
            this.iPlanElement.next();
            return prev;
        }
        return null;
    }

    @Override
    public Id<Link> getDestinationLinkId() {
        return this.getCurrentLeg().getRoute().getEndLinkId();
    }

    @Override
    public NetworkRoute getCarRoute() {
        return this.carRoute;
    }

    @Override
    public TransitLine getTransitLine() {
        return this.transitLine;
    }

    @Override
    public TransitRoute getTransitRoute() {
        return this.transitRoute;
    }

    @Override
    public Departure getDeparture() {
        return this.departure;
    }

    @Override
    public double getActivityEndTime() {
        return this.departureTime;
    }

    @Override
    public Plan getCurrentPlan() {
        return PopulationUtils.unmodifiablePlan((Plan)this.getPerson().getSelectedPlan());
    }

    @Override
    public boolean isWantingToArriveOnCurrentLink() {
        return this.chooseNextLinkId() == null;
    }

    @Override
    public Facility getCurrentFacility() {
        Activity activity;
        PlanElement pe = this.getCurrentPlanElement();
        if (pe instanceof Activity) {
            activity = (Activity)pe;
        } else if (pe instanceof Leg) {
            activity = (Activity)this.getPreviousPlanElement();
        } else {
            throw new RuntimeException("unexpected type of PlanElement");
        }
        return FacilitiesUtils.toFacility(activity, this.scenario.getActivityFacilities());
    }

    @Override
    public Facility getDestinationFacility() {
        PlanElement pe = this.getCurrentPlanElement();
        if (pe instanceof Leg) {
            Activity activity = (Activity)this.getNextPlanElement();
            return FacilitiesUtils.toFacility(activity, this.scenario.getActivityFacilities());
        }
        if (pe instanceof Activity) {
            return null;
        }
        throw new RuntimeException("unexpected type of PlanElement");
    }

    private static class PlanBuilder {
        final Plan plan = PopulationUtils.createPlan();
        static final String activityType = "pt interaction";

        private PlanBuilder() {
        }

        public void addTrip(NetworkRoute networkRoute, String transportMode) {
            if (!this.plan.getPlanElements().isEmpty()) {
                Activity lastActivity = (Activity)this.plan.getPlanElements().get(this.plan.getPlanElements().size() - 1);
                assert (lastActivity.getLinkId().equals(networkRoute.getStartLinkId()));
            } else {
                Activity lastActivity = PopulationUtils.createActivityFromLinkId(activityType, networkRoute.getStartLinkId());
                this.plan.addActivity(lastActivity);
            }
            Leg leg = PopulationUtils.createLeg(transportMode);
            leg.setRoute(networkRoute);
            this.plan.addLeg(leg);
            Activity activity = PopulationUtils.createActivityFromLinkId(activityType, networkRoute.getEndLinkId());
            this.plan.addActivity(activity);
        }

        public Plan build() {
            return this.plan;
        }
    }
}

