/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.core.mobsim.framework.AgentSource;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.qsim.HasAgentTracker;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.interfaces.DepartureHandler;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.mobsim.qsim.pt.AbstractTransitDriverAgent;
import org.matsim.core.mobsim.qsim.pt.DefaultTransitDriverAgentFactory;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.core.mobsim.qsim.pt.SimpleTransitStopHandlerFactory;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgentFactory;
import org.matsim.core.mobsim.qsim.pt.TransitQVehicle;
import org.matsim.core.mobsim.qsim.pt.TransitStopAgentTracker;
import org.matsim.core.mobsim.qsim.pt.TransitStopHandlerFactory;
import org.matsim.core.mobsim.qsim.pt.UmlaufCache;
import org.matsim.pt.ReconstructingUmlaufBuilder;
import org.matsim.pt.Umlauf;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.Vehicles;

public class TransitQSimEngine
implements DepartureHandler,
MobsimEngine,
AgentSource,
HasAgentTracker {
    private Collection<MobsimAgent> ptDrivers;
    private static final Logger log = Logger.getLogger(TransitQSimEngine.class);
    private final QSim qSim;
    private TransitSchedule schedule = null;
    protected final TransitStopAgentTracker agentTracker;
    private TransitStopHandlerFactory stopHandlerFactory = new SimpleTransitStopHandlerFactory();
    private TransitDriverAgentFactory transitDriverFactory;
    private InternalInterface internalInterface = null;

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.internalInterface = internalInterface;
        this.transitDriverFactory = new DefaultTransitDriverAgentFactory(internalInterface, this.agentTracker);
    }

    public TransitQSimEngine(QSim queueSimulation) {
        this(queueSimulation, new SimpleTransitStopHandlerFactory());
    }

    @Inject
    public TransitQSimEngine(QSim queueSimulation, TransitStopHandlerFactory stopHandlerFactory) {
        this.qSim = queueSimulation;
        this.schedule = queueSimulation.getScenario().getTransitSchedule();
        this.agentTracker = new TransitStopAgentTracker(this.qSim.getEventsManager());
        this.stopHandlerFactory = stopHandlerFactory;
    }

    public InternalInterface getInternalInterface() {
        return this.internalInterface;
    }

    @Override
    public void onPrepareSim() {
    }

    @Override
    public void afterSim() {
        double now = this.qSim.getSimTimer().getTimeOfDay();
        for (Map.Entry<Id<TransitStopFacility>, List<PTPassengerAgent>> agentsAtStop : this.agentTracker.getAgentsAtStop().entrySet()) {
            TransitStopFacility stop = this.schedule.getFacilities().get(agentsAtStop.getKey());
            for (PTPassengerAgent agent : agentsAtStop.getValue()) {
                this.qSim.getEventsManager().processEvent(new PersonStuckEvent(now, agent.getId(), stop.getLinkId(), ((MobsimAgent)((Object)agent)).getMode()));
                this.qSim.getAgentCounter().decLiving();
                this.qSim.getAgentCounter().incLost();
            }
        }
    }

    private Collection<MobsimAgent> createVehiclesAndDriversWithUmlaeufe() {
        Scenario scenario = this.qSim.getScenario();
        Vehicles vehicles = scenario.getTransitVehicles();
        ArrayList<MobsimAgent> drivers = new ArrayList<MobsimAgent>();
        UmlaufCache umlaufCache = TransitQSimEngine.getOrCreateUmlaufCache(scenario);
        for (Umlauf umlauf : umlaufCache.getUmlaeufe()) {
            Vehicle basicVehicle = vehicles.getVehicles().get(umlauf.getVehicleId());
            if (umlauf.getUmlaufStuecke().isEmpty()) continue;
            AbstractTransitDriverAgent driver = this.createAndScheduleVehicleAndDriver(umlauf, basicVehicle);
            drivers.add(driver);
        }
        return drivers;
    }

    private static UmlaufCache getOrCreateUmlaufCache(Scenario scenario) {
        ReconstructingUmlaufBuilder reconstructingUmlaufBuilder = new ReconstructingUmlaufBuilder(scenario.getNetwork(), scenario.getTransitSchedule().getTransitLines().values(), scenario.getTransitVehicles(), scenario.getConfig().planCalcScore());
        Collection<Umlauf> umlaeufe = reconstructingUmlaufBuilder.build();
        UmlaufCache umlaufCache = new UmlaufCache(scenario.getTransitSchedule(), umlaeufe);
        return umlaufCache;
    }

    private AbstractTransitDriverAgent createAndScheduleVehicleAndDriver(Umlauf umlauf, Vehicle vehicle) {
        TransitQVehicle veh = new TransitQVehicle(vehicle);
        AbstractTransitDriverAgent driver = this.transitDriverFactory.createTransitDriver(umlauf);
        veh.setDriver(driver);
        veh.setStopHandler(this.stopHandlerFactory.createTransitStopHandler(veh.getVehicle()));
        driver.setVehicle(veh);
        Leg firstLeg = (Leg)driver.getNextPlanElement();
        Id<Link> startLinkId = firstLeg.getRoute().getStartLinkId();
        this.qSim.addParkedVehicle(veh, startLinkId);
        this.qSim.insertAgentIntoMobsim(driver);
        return driver;
    }

    private void handleAgentPTDeparture(MobsimAgent planAgent, Id<Link> linkId) {
        Id<TransitStopFacility> accessStopId = ((PTPassengerAgent)((Object)planAgent)).getDesiredAccessStopId();
        if (accessStopId == null) {
            log.error("pt-agent doesn't know to what transit stop to go. Removing agent from simulation. Agent " + planAgent.getId().toString());
            this.qSim.getAgentCounter().decLiving();
            this.qSim.getAgentCounter().incLost();
            return;
        }
        TransitStopFacility stop = this.schedule.getFacilities().get(accessStopId);
        if (stop.getLinkId() != null && !stop.getLinkId().equals(linkId)) {
            throw new TransitAgentTriesToTeleportException("Agent " + planAgent.getId() + " tries to enter a transit stop at link " + stop.getLinkId() + " but really is at " + linkId + "!");
        }
        double now = this.qSim.getSimTimer().getTimeOfDay();
        this.agentTracker.addAgentToStop(now, (PTPassengerAgent)((Object)planAgent), stop.getId());
        this.internalInterface.registerAdditionalAgentOnLink(planAgent);
    }

    @Override
    public boolean handleDeparture(double now, MobsimAgent agent, Id<Link> linkId) {
        String requestedMode = agent.getMode();
        if (this.qSim.getScenario().getConfig().transit().getTransitModes().contains(requestedMode)) {
            this.handleAgentPTDeparture(agent, linkId);
            return true;
        }
        return false;
    }

    @Override
    public TransitStopAgentTracker getAgentTracker() {
        return this.agentTracker;
    }

    public void setTransitStopHandlerFactory(TransitStopHandlerFactory stopHandlerFactory) {
        this.stopHandlerFactory = stopHandlerFactory;
    }

    public void setAbstractTransitDriverFactory(TransitDriverAgentFactory abstractTransitDriverFactory) {
        this.transitDriverFactory = abstractTransitDriverFactory;
    }

    @Override
    public void doSimStep(double time) {
    }

    @Override
    public void insertAgentsIntoMobsim() {
        this.ptDrivers = this.createVehiclesAndDriversWithUmlaeufe();
    }

    public Collection<MobsimAgent> getPtDrivers() {
        return Collections.unmodifiableCollection(this.ptDrivers);
    }

    public static class TransitAgentTriesToTeleportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TransitAgentTriesToTeleportException(String message) {
            super(message);
        }
    }
}

