/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.pt;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.experimental.events.AgentWaitingForPtEvent;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.qsim.AgentTracker;
import org.matsim.core.mobsim.qsim.pt.PTPassengerAgent;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class TransitStopAgentTracker
implements AgentTracker {
    private static final Logger log = Logger.getLogger(TransitStopAgentTracker.class);
    private final EventsManager events;
    private final Map<Id<TransitStopFacility>, List<PTPassengerAgent>> agentsAtStops = new ConcurrentHashMap<Id<TransitStopFacility>, List<PTPassengerAgent>>();

    public TransitStopAgentTracker(EventsManager events) {
        this.events = events;
    }

    public void addAgentToStop(double now, PTPassengerAgent agent, Id<TransitStopFacility> stopId) {
        if (stopId == null) {
            throw new NullPointerException("stop must not be null.");
        }
        List<PTPassengerAgent> agents = this.agentsAtStops.get(stopId);
        if (agents == null) {
            agents = new CopyOnWriteArrayList<PTPassengerAgent>();
            this.agentsAtStops.put(stopId, agents);
        }
        if (!agents.add(agent)) {
            log.error("did NOT add agent " + agent.getId() + " since it was already there.");
        }
        Id<TransitStopFacility> destinationStopId = agent.getDesiredDestinationStopId();
        this.events.processEvent(new AgentWaitingForPtEvent(now, agent.getId(), stopId, destinationStopId));
    }

    public void removeAgentFromStop(PTPassengerAgent agent, Id<TransitStopFacility> stopId) {
        if (stopId == null) {
            throw new NullPointerException("stopId must not be null.");
        }
        List<PTPassengerAgent> agents = this.agentsAtStops.get(stopId);
        if (agents != null) {
            if (!agents.remove(agent)) {
                log.error("Agent " + agent.getId() + " could not be removed from waiting at stop " + stopId);
            }
        } else {
            log.error("Agent " + agent.getId() + " could not be removed from waiting at stop " + stopId + " since agents list was null.");
        }
    }

    @Override
    public List<PTPassengerAgent> getAgentsAtFacility(Id<TransitStopFacility> stopId) {
        List<PTPassengerAgent> agents = this.agentsAtStops.get(stopId);
        if (agents == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(agents);
    }

    public Map<Id<TransitStopFacility>, List<PTPassengerAgent>> getAgentsAtStop() {
        return this.agentsAtStops;
    }
}

