/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.HasPerson;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgent;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.QueueWithBuffer;
import org.matsim.core.mobsim.qsim.qnetsimengine.VisUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfoFactory;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;
import org.matsim.vis.snapshotwriters.VisVehicle;

abstract class AbstractAgentSnapshotInfoBuilder {
    private static final Logger log = Logger.getLogger(AbstractAgentSnapshotInfoBuilder.class);
    private final AgentSnapshotInfoFactory snapshotInfoFactory;
    private Scenario scenario;
    private static int wrnCnt = 0;

    AbstractAgentSnapshotInfoBuilder(Scenario sc, SnapshotLinkWidthCalculator linkWidthCalculator) {
        this.snapshotInfoFactory = new AgentSnapshotInfoFactory(linkWidthCalculator);
        this.scenario = sc;
    }

    public final int positionVehiclesFromWaitingList(Collection<AgentSnapshotInfo> positions, Link link, int cnt2, Queue<QVehicle> waitingList) {
        for (QVehicle veh : waitingList) {
            List<Identifiable<?>> peopleInVehicle = VisUtils.getPeopleInVehicle(veh);
            boolean first = true;
            for (Identifiable identifiable : peopleInVehicle) {
                AgentSnapshotInfo passengerPosition = this.snapshotInfoFactory.createAgentSnapshotInfo(identifiable.getId(), link, 0.9 * link.getLength(), ++cnt2);
                if (identifiable.getId().toString().startsWith("pt")) {
                    passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.TRANSIT_DRIVER);
                } else if (first) {
                    passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
                } else {
                    passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
                }
                Person person = this.scenario.getPopulation().getPersons().get(identifiable.getId());
                if (person != null && person.getAttributes().getAttribute("marker") != null) {
                    passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
                }
                positions.add(passengerPosition);
                first = false;
            }
        }
        return cnt2;
    }

    public final int positionAgentsInActivities(Collection<AgentSnapshotInfo> positions, Link link, Collection<MobsimAgent> agentsInActivities, int cnt2) {
        for (MobsimAgent pa : agentsInActivities) {
            AgentSnapshotInfo agInfo = this.snapshotInfoFactory.createAgentSnapshotInfo(pa.getId(), link, 0.9 * link.getLength(), cnt2);
            agInfo.setAgentState(AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY);
            Person person = this.scenario.getPopulation().getPersons().get(pa.getId());
            if (person != null && person.getAttributes().getAttribute("marker") != null) {
                agInfo.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
            }
            positions.add(agInfo);
            ++cnt2;
        }
        return cnt2;
    }

    public final int positionVehiclesFromTransitStop(Collection<AgentSnapshotInfo> positions, Link link, Queue<QVehicle> transitVehicleStopQueue, int cnt2) {
        if (transitVehicleStopQueue.size() > 0) {
            for (QVehicle veh : transitVehicleStopQueue) {
                List<Identifiable<?>> peopleInVehicle = VisUtils.getPeopleInVehicle(veh);
                boolean last = false;
                cnt2 += peopleInVehicle.size();
                ListIterator<Identifiable<?>> it = peopleInVehicle.listIterator(peopleInVehicle.size());
                while (it.hasPrevious()) {
                    Identifiable<?> passenger = it.previous();
                    if (!it.hasPrevious()) {
                        last = true;
                    }
                    AgentSnapshotInfo passengerPosition = this.snapshotInfoFactory.createAgentSnapshotInfo(passenger.getId(), link, 0.9 * link.getLength(), cnt2);
                    if (passenger.getId().toString().startsWith("pt")) {
                        passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.TRANSIT_DRIVER);
                    } else if (last) {
                        passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
                    } else {
                        passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
                    }
                    positions.add(passengerPosition);
                    --cnt2;
                }
                cnt2 += peopleInVehicle.size();
            }
        }
        return cnt2;
    }

    public final void positionAgentGivenDistanceFromFNode(Collection<AgentSnapshotInfo> positions, Coord startCoord, Coord endCoord, double lengthOfCurve, QVehicle veh, double distanceFromFromNode, Integer lane, double speedValueBetweenZeroAndOne) {
        Person person;
        MobsimDriverAgent driverAgent = veh.getDriver();
        AgentSnapshotInfo pos = this.snapshotInfoFactory.createAgentSnapshotInfo(driverAgent.getId(), startCoord, endCoord, distanceFromFromNode, lane, lengthOfCurve);
        pos.setColorValueBetweenZeroAndOne(speedValueBetweenZeroAndOne);
        if (driverAgent instanceof TransitDriverAgent) {
            pos.setAgentState(AgentSnapshotInfo.AgentState.TRANSIT_DRIVER);
        } else if (driverAgent.getMode().equals("car")) {
            pos.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
        } else {
            pos.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
        }
        if (driverAgent instanceof HasPerson && PopulationUtils.getPersonAttribute(((HasPerson)((Object)driverAgent)).getPerson(), "marker") != null) {
            pos.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
        }
        if ((person = this.scenario.getPopulation().getPersons().get(driverAgent.getId())) != null && person.getAttributes().getAttribute("marker") != null) {
            pos.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
        }
        this.positionPassengers(positions, veh.getPassengers(), distanceFromFromNode, startCoord, endCoord, lengthOfCurve, lane + 5, speedValueBetweenZeroAndOne);
        positions.add(pos);
    }

    public final Collection<AgentSnapshotInfo> positionVehiclesAlongLine(Collection<AgentSnapshotInfo> positions, double now, Collection<MobsimVehicle> vehs, double curvedLength, double storageCapacity, Coord upstreamCoord, Coord downstreamCoord, double inverseFlowCapPerTS, double freeSpeed, int numberOfLanesAsInt, Queue<QueueWithBuffer.Hole> holes) {
        double spacingOfOnePCE = this.calculateVehicleSpacing(curvedLength, storageCapacity, vehs);
        double ttimeOfHoles = curvedLength / 4.166666666666667;
        TreeMap<Double, QueueWithBuffer.Hole> consumableHoles = new TreeMap<Double, QueueWithBuffer.Hole>();
        switch (this.scenario.getConfig().qsim().getSnapshotStyle()) {
            case equiDist: 
            case queue: {
                break;
            }
            case withHoles: 
            case withHolesAndShowHoles: 
            case kinematicWaves: {
                if (holes.isEmpty()) break;
                double firstHolePosition = Double.NaN;
                double distanceOfHoleFromFromNode = Double.NaN;
                double sum = 0.0;
                for (QueueWithBuffer.Hole hole : holes) {
                    sum += hole.getSizeInEquivalents();
                    distanceOfHoleFromFromNode = AbstractAgentSnapshotInfoBuilder.computeHolePositionAndReturnDistance(ttimeOfHoles, hole, now, curvedLength);
                    if (Double.isNaN(firstHolePosition)) {
                        firstHolePosition = distanceOfHoleFromFromNode;
                        sum = 0.0;
                    }
                    if (Math.round(distanceOfHoleFromFromNode) != Math.round(curvedLength)) {
                        consumableHoles.put(distanceOfHoleFromFromNode, hole);
                    }
                    if (QSimConfigGroup.SnapshotStyle.withHolesAndShowHoles != this.scenario.getConfig().qsim().getSnapshotStyle()) continue;
                    this.addHolePosition(positions, distanceOfHoleFromFromNode, hole, curvedLength, upstreamCoord, downstreamCoord);
                }
                double spaceConsumptionOfHoles = sum * spacingOfOnePCE;
                double spaceAvailableForHoles = distanceOfHoleFromFromNode - firstHolePosition;
                if (wrnCnt >= 10) break;
                ++wrnCnt;
                if (spaceConsumptionOfHoles >= spaceAvailableForHoles) {
                    log.warn("we have a problem: holes consume too much space:");
                    log.warn("summed up space consumption of holes: " + spaceConsumptionOfHoles);
                    log.warn("distance bw first and last hole: " + spaceAvailableForHoles);
                }
                if (wrnCnt != 10) break;
                log.warn(" Future occurences of this logging statement are suppressed.");
                break;
            }
            default: {
                throw new RuntimeException("The traffic dynmics " + (Object)((Object)this.scenario.getConfig().qsim().getSnapshotStyle()) + " is not implemented yet.");
            }
        }
        double freespeedTraveltime = curvedLength / freeSpeed;
        double distanceFromFromNode = Double.NaN;
        block9: for (MobsimVehicle mveh : vehs) {
            QVehicle veh = (QVehicle)mveh;
            double remainingTravelTime = veh.getEarliestLinkExitTime() - now;
            double vehicleSpacing = mveh.getSizeInEquivalents() * spacingOfOnePCE;
            Integer lane = VisUtils.guessLane(veh, numberOfLanesAsInt);
            double speedValue = VisUtils.calcSpeedValueBetweenZeroAndOne(veh, inverseFlowCapPerTS, now, freeSpeed);
            Gbl.assertNotNull(upstreamCoord);
            Gbl.assertNotNull(downstreamCoord);
            this.positionAgentGivenDistanceFromFNode(positions, upstreamCoord, downstreamCoord, curvedLength, veh, distanceFromFromNode, lane, speedValue);
            switch (this.scenario.getConfig().qsim().getTrafficDynamics()) {
                case queue: {
                    continue block9;
                }
                case withHoles: 
                case kinematicWaves: {
                    Map.Entry entry;
                    for (distanceFromFromNode = this.calculateOdometerDistanceFromFromNode(curvedLength, vehicleSpacing, distanceFromFromNode, now, freespeedTraveltime, remainingTravelTime); !consumableHoles.isEmpty() && distanceFromFromNode < (Double)consumableHoles.lastKey(); distanceFromFromNode -= spacingOfOnePCE * ((QueueWithBuffer.Hole)entry.getValue()).getSizeInEquivalents()) {
                        entry = consumableHoles.pollLastEntry();
                    }
                    continue block9;
                }
            }
            throw new RuntimeException("The traffic dynmics " + (Object)((Object)this.scenario.getConfig().qsim().getTrafficDynamics()) + " is not implemented yet.");
        }
        return positions;
    }

    private static double computeHolePositionAndReturnDistance(double freespeedTraveltime, QueueWithBuffer.Hole hole, double now, double curvedLength) {
        double remainingTravelTime = hole.getEarliestLinkExitTime() - now;
        double distanceFromFromNode = remainingTravelTime / freespeedTraveltime * curvedLength;
        return distanceFromFromNode;
    }

    private void addHolePosition(Collection<AgentSnapshotInfo> positions, double distanceFromFromNode, QueueWithBuffer.Hole veh, double curvedLength, Coord upstreamCoord, Coord downstreamCoord) {
        Integer lane = 20;
        double speedValue = 1.0;
        AgentSnapshotInfo pos = this.snapshotInfoFactory.createAgentSnapshotInfo(Id.create("hole", Person.class), upstreamCoord, downstreamCoord, distanceFromFromNode, lane, curvedLength);
        pos.setColorValueBetweenZeroAndOne(speedValue);
        pos.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
        positions.add(pos);
    }

    final void positionPassengers(Collection<AgentSnapshotInfo> positions, Collection<? extends PassengerAgent> passengers, double distanceOnLink, Coord startCoord, Coord endCoord, double lengthOfCurve, Integer lane, double speedValueBetweenZeroAndOne) {
        int cnt = passengers.size();
        int laneInt = 2 * (cnt + 1);
        if (lane != null) {
            laneInt += lane.intValue();
        }
        for (PassengerAgent passengerAgent : passengers) {
            int lanePos = laneInt - 2 * cnt;
            AgentSnapshotInfo passengerPosition = this.snapshotInfoFactory.createAgentSnapshotInfo(passengerAgent.getId(), startCoord, endCoord, distanceOnLink, lanePos, lengthOfCurve);
            passengerPosition.setColorValueBetweenZeroAndOne(speedValueBetweenZeroAndOne);
            passengerPosition.setAgentState(AgentSnapshotInfo.AgentState.PERSON_OTHER_MODE);
            positions.add(passengerPosition);
            --cnt;
        }
    }

    public abstract double calculateVehicleSpacing(double var1, double var3, Collection<? extends VisVehicle> var5);

    public abstract double calculateOdometerDistanceFromFromNode(double var1, double var3, double var5, double var7, double var9, double var11);
}

