/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleAbortsEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgent;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetElementActivationRegistry;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.TransitQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.LinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.VehicleHandler;
import org.matsim.core.network.NetworkUtils;
import org.matsim.vehicles.Vehicle;

abstract class AbstractQLink
implements QLinkI {
    private static final Logger log = Logger.getLogger(AbstractQLink.class);
    private final Link link;
    private NetElementActivationRegistry netElementActivationRegistry;
    private final Map<String, Object> customAttributes = new HashMap<String, Object>();
    private final Map<Id<Vehicle>, QVehicle> parkedVehicles = new ConcurrentHashMap<Id<Vehicle>, QVehicle>(10);
    private final Map<Id<Person>, MobsimAgent> additionalAgentsOnLink = new ConcurrentHashMap<Id<Person>, MobsimAgent>();
    private final Map<Id<Vehicle>, Queue<MobsimDriverAgent>> driversWaitingForCars = new LinkedHashMap<Id<Vehicle>, Queue<MobsimDriverAgent>>();
    private final Map<Id<Person>, MobsimDriverAgent> driversWaitingForPassengers = new LinkedHashMap<Id<Person>, MobsimDriverAgent>();
    private final Map<Id<Vehicle>, Set<MobsimAgent>> passengersWaitingForCars = new LinkedHashMap<Id<Vehicle>, Set<MobsimAgent>>();
    private final Queue<QVehicle> waitingList = new LinkedList<QVehicle>();
    private boolean active = false;
    private TransitQLink transitQLink;
    private final QNodeI toQNode;
    private final NetsimEngineContext context;
    private final QNetsimEngine.NetsimInternalInterface netsimEngine;
    private final LinkSpeedCalculator linkSpeedCalculator;
    private final VehicleHandler vehicleHandler;
    private static int wrnCnt = 0;
    private final QLinkInternalInterface qLinkInternalInterface = new QLinkInternalInterface();

    AbstractQLink(Link link, QNodeI toNode, NetsimEngineContext context, QNetsimEngine.NetsimInternalInterface netsimEngine2, LinkSpeedCalculator linkSpeedCalculator, VehicleHandler vehicleHandler) {
        this.link = link;
        this.toQNode = toNode;
        this.context = context;
        this.netsimEngine = netsimEngine2;
        this.linkSpeedCalculator = linkSpeedCalculator;
        this.vehicleHandler = vehicleHandler;
    }

    @Override
    public QNodeI getToNode() {
        return this.toQNode;
    }

    private void activateLink() {
        if (!this.active) {
            this.netElementActivationRegistry.registerLinkAsActive(this);
            this.active = true;
        }
    }

    public final void addParkedVehicle(MobsimVehicle vehicle, boolean isInitial) {
        QVehicle qveh = (QVehicle)vehicle;
        if (this.parkedVehicles.put(qveh.getId(), qveh) != null && wrnCnt < 1) {
            ++wrnCnt;
            log.warn("existing vehicle on link was just overwritten by other vehicle with same ID.  Not clear what this means.  Continuing anyways ...");
            log.warn(" This message given only once.");
        }
        qveh.setCurrentLink(this.link);
        if (isInitial) {
            this.vehicleHandler.handleInitialVehicleArrival(qveh, this.link);
        }
    }

    @Override
    public final void addParkedVehicle(MobsimVehicle vehicle) {
        this.addParkedVehicle(vehicle, true);
    }

    final boolean letVehicleArrive(QVehicle qveh) {
        if (this.vehicleHandler.handleVehicleArrival(qveh, this.getLink())) {
            this.addParkedVehicle(qveh, false);
            double now = this.context.getSimTimer().getTimeOfDay();
            this.context.getEventsManager().processEvent(new VehicleLeavesTrafficEvent(now, qveh.getDriver().getId(), this.link.getId(), qveh.getId(), qveh.getDriver().getMode(), 1.0));
            this.netsimEngine.letVehicleArrive(qveh);
            this.makeVehicleAvailableToNextDriver(qveh);
            return true;
        }
        return false;
    }

    @Override
    public final QVehicle removeParkedVehicle(Id<Vehicle> vehicleId) {
        return this.parkedVehicles.remove(vehicleId);
    }

    @Override
    public QVehicle getParkedVehicle(Id<Vehicle> vehicleId) {
        return this.parkedVehicles.get(vehicleId);
    }

    private final void addDepartingVehicle(MobsimVehicle mvehicle) {
        QVehicle vehicle = (QVehicle)mvehicle;
        this.waitingList.add(vehicle);
        vehicle.setCurrentLink(this.getLink());
        this.activateLink();
        this.vehicleHandler.handleVehicleDeparture(vehicle, this.link);
    }

    @Override
    public void registerAdditionalAgentOnLink(MobsimAgent planAgent) {
        this.additionalAgentsOnLink.put(planAgent.getId(), planAgent);
    }

    @Override
    public MobsimAgent unregisterAdditionalAgentOnLink(Id<Person> mobsimAgentId) {
        return this.additionalAgentsOnLink.remove(mobsimAgentId);
    }

    @Override
    public Collection<MobsimAgent> getAdditionalAgentsOnLink() {
        return Collections.unmodifiableCollection(this.additionalAgentsOnLink.values());
    }

    @Override
    public void clearVehicles() {
        double now = this.context.getSimTimer().getTimeOfDay();
        HashSet stuckAgents = new HashSet();
        for (QVehicle qVehicle : this.parkedVehicles.values()) {
            if (qVehicle.getDriver() != null) {
                if (qVehicle.getDriver().getState() != MobsimAgent.State.LEG || stuckAgents.contains(qVehicle.getDriver().getId())) continue;
                stuckAgents.add(qVehicle.getDriver().getId());
                this.context.getEventsManager().processEvent(new VehicleAbortsEvent(now, qVehicle.getId(), qVehicle.getCurrentLink().getId()));
                this.context.getEventsManager().processEvent(new PersonStuckEvent(now, qVehicle.getDriver().getId(), qVehicle.getCurrentLink().getId(), qVehicle.getDriver().getMode()));
                this.context.getAgentCounter().incLost();
                this.context.getAgentCounter().decLiving();
            }
            for (PassengerAgent passengerAgent : qVehicle.getPassengers()) {
                if (stuckAgents.contains(passengerAgent.getId())) continue;
                stuckAgents.add(passengerAgent.getId());
                MobsimAgent mobsimAgent = (MobsimAgent)((Object)passengerAgent);
                this.context.getEventsManager().processEvent(new PersonStuckEvent(now, mobsimAgent.getId(), qVehicle.getCurrentLink().getId(), mobsimAgent.getMode()));
                this.context.getAgentCounter().incLost();
                this.context.getAgentCounter().decLiving();
            }
        }
        this.parkedVehicles.clear();
        for (MobsimAgent mobsimAgent : this.driversWaitingForPassengers.values()) {
            if (stuckAgents.contains(mobsimAgent.getId())) continue;
            stuckAgents.add(mobsimAgent.getId());
            this.context.getEventsManager().processEvent(new PersonStuckEvent(now, mobsimAgent.getId(), mobsimAgent.getCurrentLinkId(), mobsimAgent.getMode()));
            this.context.getAgentCounter().incLost();
            this.context.getAgentCounter().decLiving();
        }
        this.driversWaitingForPassengers.clear();
        for (Queue queue : this.driversWaitingForCars.values()) {
            for (MobsimAgent mobsimAgent : queue) {
                if (stuckAgents.contains(mobsimAgent.getId())) continue;
                stuckAgents.add(mobsimAgent.getId());
                this.context.getEventsManager().processEvent(new PersonStuckEvent(now, mobsimAgent.getId(), mobsimAgent.getCurrentLinkId(), mobsimAgent.getMode()));
                this.context.getAgentCounter().incLost();
                this.context.getAgentCounter().decLiving();
            }
        }
        this.driversWaitingForCars.clear();
        for (Set set : this.passengersWaitingForCars.values()) {
            for (MobsimAgent mobsimAgent : set) {
                if (stuckAgents.contains(mobsimAgent.getId())) continue;
                stuckAgents.add(mobsimAgent.getId());
                this.context.getEventsManager().processEvent(new PersonStuckEvent(now, mobsimAgent.getId(), mobsimAgent.getCurrentLinkId(), mobsimAgent.getMode()));
                this.context.getAgentCounter().incLost();
                this.context.getAgentCounter().decLiving();
            }
        }
        this.passengersWaitingForCars.clear();
        for (QVehicle qVehicle : this.waitingList) {
            if (stuckAgents.contains(qVehicle.getDriver().getId())) continue;
            stuckAgents.add(qVehicle.getDriver().getId());
            this.context.getEventsManager().processEvent(new VehicleAbortsEvent(now, qVehicle.getId(), qVehicle.getCurrentLink().getId()));
            this.context.getEventsManager().processEvent(new PersonStuckEvent(now, qVehicle.getDriver().getId(), qVehicle.getCurrentLink().getId(), qVehicle.getDriver().getMode()));
            this.context.getAgentCounter().incLost();
            this.context.getAgentCounter().decLiving();
        }
        this.waitingList.clear();
    }

    void makeVehicleAvailableToNextDriver(QVehicle veh) {
        MobsimDriverAgent driverWaitingForPassengers;
        Queue<MobsimDriverAgent> driversWaitingForCar;
        boolean thereIsDriverWaiting;
        Id<Vehicle> vehicleId = veh.getId();
        Set<MobsimAgent> passengers = this.passengersWaitingForCars.get(vehicleId);
        if (passengers != null) {
            ArrayList<MobsimAgent> passengersToHandle = new ArrayList<MobsimAgent>(passengers);
            for (MobsimAgent passenger : passengersToHandle) {
                this.unregisterPassengerAgentWaitingForCar(passenger, vehicleId);
                this.insertPassengerIntoVehicle(passenger, vehicleId);
            }
        }
        boolean bl = thereIsDriverWaiting = (driversWaitingForCar = this.driversWaitingForCars.get(veh.getId())) != null && !driversWaitingForCar.isEmpty();
        if (thereIsDriverWaiting && (driverWaitingForPassengers = this.driversWaitingForPassengers.get(driversWaitingForCar.element().getId())) != null) {
            return;
        }
        if (thereIsDriverWaiting && veh.getDriver() == null) {
            veh.setDriver(driversWaitingForCar.remove());
            if (driversWaitingForCar.isEmpty()) {
                Queue<MobsimDriverAgent> r = this.driversWaitingForCars.remove(veh.getId());
                assert (r == driversWaitingForCar);
            }
            this.removeParkedVehicle(veh.getId());
            this.letVehicleDepart(veh);
        }
    }

    @Override
    public final void letVehicleDepart(QVehicle vehicle) {
        double now = this.context.getSimTimer().getTimeOfDay();
        MobsimDriverAgent driver = vehicle.getDriver();
        if (driver == null) {
            throw new RuntimeException("Vehicle cannot depart without a driver!");
        }
        EventsManager eventsManager = this.context.getEventsManager();
        eventsManager.processEvent(new PersonEntersVehicleEvent(now, driver.getId(), vehicle.getId()));
        this.addDepartingVehicle(vehicle);
    }

    @Override
    public final boolean insertPassengerIntoVehicle(MobsimAgent passenger, Id<Vehicle> vehicleId) {
        double now = this.context.getSimTimer().getTimeOfDay();
        QVehicle vehicle = this.getParkedVehicle(vehicleId);
        if (vehicle == null) {
            this.registerPassengerAgentWaitingForCar(passenger, vehicleId);
            return false;
        }
        boolean added = vehicle.addPassenger((PassengerAgent)((Object)passenger));
        if (!added) {
            log.warn("Passenger " + passenger.getId().toString() + " could not be inserted into vehicle " + vehicleId.toString() + " since there is no free seat available!");
            return false;
        }
        ((PassengerAgent)((Object)passenger)).setVehicle(vehicle);
        EventsManager eventsManager = this.context.getEventsManager();
        eventsManager.processEvent(new PersonEntersVehicleEvent(now, passenger.getId(), vehicle.getId()));
        return true;
    }

    @Override
    public QVehicle getVehicle(Id<Vehicle> vehicleId) {
        QVehicle ret = this.parkedVehicles.get(vehicleId);
        return ret;
    }

    @Override
    public final Collection<MobsimVehicle> getAllVehicles() {
        Collection<MobsimVehicle> vehicles = this.getAllNonParkedVehicles();
        vehicles.addAll(this.parkedVehicles.values());
        return vehicles;
    }

    @Override
    public final Map<String, Object> getCustomAttributes() {
        return this.customAttributes;
    }

    void setNetElementActivationRegistry(NetElementActivationRegistry qSimEngineRunner) {
        this.netElementActivationRegistry = qSimEngineRunner;
    }

    @Override
    public void registerDriverAgentWaitingForCar(MobsimDriverAgent agent) {
        Id<Vehicle> vehicleId = agent.getPlannedVehicleId();
        Queue<MobsimDriverAgent> queue = this.driversWaitingForCars.get(vehicleId);
        if (queue == null) {
            queue = new LinkedList<MobsimDriverAgent>();
            this.driversWaitingForCars.put(vehicleId, queue);
        }
        queue.add(agent);
    }

    @Override
    public void registerDriverAgentWaitingForPassengers(MobsimDriverAgent agent) {
        this.driversWaitingForPassengers.put(agent.getId(), agent);
    }

    @Override
    public MobsimAgent unregisterDriverAgentWaitingForPassengers(Id<Person> agentId) {
        return this.driversWaitingForPassengers.remove(agentId);
    }

    @Override
    public void registerPassengerAgentWaitingForCar(MobsimAgent agent, Id<Vehicle> vehicleId) {
        Set<MobsimAgent> passengers = this.passengersWaitingForCars.get(vehicleId);
        if (passengers == null) {
            passengers = new LinkedHashSet<MobsimAgent>();
            this.passengersWaitingForCars.put(vehicleId, passengers);
        }
        passengers.add(agent);
    }

    @Override
    public MobsimAgent unregisterPassengerAgentWaitingForCar(MobsimAgent agent, Id<Vehicle> vehicleId) {
        Set<MobsimAgent> passengers = this.passengersWaitingForCars.get(vehicleId);
        if (passengers != null && passengers.remove(agent)) {
            return agent;
        }
        return null;
    }

    @Override
    public Set<MobsimAgent> getAgentsWaitingForCar(Id<Vehicle> vehicleId) {
        Set<MobsimAgent> set = this.passengersWaitingForCars.get(vehicleId);
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    boolean isActive() {
        return this.active;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    Queue<QVehicle> getWaitingList() {
        return this.waitingList;
    }

    TransitQLink getTransitQLink() {
        return this.transitQLink;
    }

    void setTransitQLink(TransitQLink transitQLink) {
        this.transitQLink = transitQLink;
    }

    public final QLinkInternalInterface getInternalInterface() {
        return this.qLinkInternalInterface;
    }

    public final class QLinkInternalInterface {
        public QNodeI getToNodeQ() {
            return AbstractQLink.this.toQNode;
        }

        public Node getToNode() {
            return AbstractQLink.this.link.getToNode();
        }

        public double getFreespeed() {
            return AbstractQLink.this.link.getFreespeed();
        }

        public Id<Link> getId() {
            return AbstractQLink.this.link.getId();
        }

        public HandleTransitStopResult handleTransitStop(double now, QVehicle veh, TransitDriverAgent driver, Id<Link> linkId) {
            return AbstractQLink.this.transitQLink.handleTransitStop(now, veh, driver, linkId);
        }

        public void addParkedVehicle(QVehicle veh) {
            AbstractQLink.this.addParkedVehicle(veh);
        }

        public boolean letVehicleArrive(QVehicle veh) {
            return AbstractQLink.this.letVehicleArrive(veh);
        }

        public void makeVehicleAvailableToNextDriver(QVehicle veh) {
            AbstractQLink.this.makeVehicleAvailableToNextDriver(veh);
        }

        public void activateLink() {
            AbstractQLink.this.activateLink();
        }

        public double getMaximumVelocityFromLinkSpeedCalculator(QVehicle veh, double now) {
            LinkSpeedCalculator linkSpeedCalculator = AbstractQLink.this.linkSpeedCalculator;
            Gbl.assertNotNull(linkSpeedCalculator);
            return linkSpeedCalculator.getMaximumVelocity(veh, AbstractQLink.this.link, now);
        }

        public void setCurrentLinkToVehicle(QVehicle veh) {
            veh.setCurrentLink(AbstractQLink.this.link);
        }

        public QLaneI getAcceptingQLane() {
            return AbstractQLink.this.getAcceptingQLane();
        }

        public List<QLaneI> getOfferingQLanes() {
            return AbstractQLink.this.getOfferingQLanes();
        }

        public Node getFromNode() {
            return AbstractQLink.this.link.getFromNode();
        }

        public double getFreespeed(double now) {
            return AbstractQLink.this.link.getFreespeed(now);
        }

        public int getNumberOfLanesAsInt(double now) {
            return NetworkUtils.getNumberOfLanesAsInt(now, AbstractQLink.this.link);
        }
    }

    public static enum HandleTransitStopResult {
        continue_driving,
        rehandle,
        accepted;

    }
}

