/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.DefaultTurnAcceptanceLogic;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.QueueWithBuffer;
import org.matsim.core.mobsim.qsim.qnetsimengine.TurnAcceptanceLogic;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.DefaultLinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.LinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.DefaultVehicleHandler;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.VehicleHandler;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicleq.FIFOVehicleQ;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicleq.VehicleQ;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;

public final class ConfigurableQNetworkFactory
implements QNetworkFactory {
    private QSimConfigGroup qsimConfig;
    private EventsManager events;
    private Network network;
    private Scenario scenario;
    private NetsimEngineContext context;
    private QNetsimEngine.NetsimInternalInterface netsimEngine;
    private LinkSpeedCalculator linkSpeedCalculator = new DefaultLinkSpeedCalculator();
    private TurnAcceptanceLogic turnAcceptanceLogic = new DefaultTurnAcceptanceLogic();
    private VehicleHandler vehicleHandler = new DefaultVehicleHandler();
    private VehicleQ.Factory<QVehicle> vehicleQFactory = FIFOVehicleQ::new;

    public ConfigurableQNetworkFactory(EventsManager events, Scenario scenario) {
        this.events = events;
        this.scenario = scenario;
        this.network = scenario.getNetwork();
        this.qsimConfig = scenario.getConfig().qsim();
    }

    @Override
    public void initializeFactory(AgentCounter agentCounter, MobsimTimer mobsimTimer, QNetsimEngine.NetsimInternalInterface netsimEngine1) {
        this.netsimEngine = netsimEngine1;
        double effectiveCellSize = this.network.getEffectiveCellSize();
        SnapshotLinkWidthCalculator linkWidthCalculator = new SnapshotLinkWidthCalculator();
        linkWidthCalculator.setLinkWidthForVis(this.qsimConfig.getLinkWidthForVis());
        if (!Double.isNaN(this.network.getEffectiveLaneWidth())) {
            linkWidthCalculator.setLaneWidth(this.network.getEffectiveLaneWidth());
        }
        AbstractAgentSnapshotInfoBuilder agentSnapshotInfoBuilder = QNetsimEngine.createAgentSnapshotInfoBuilder(this.scenario, linkWidthCalculator);
        this.context = new NetsimEngineContext(this.events, effectiveCellSize, agentCounter, agentSnapshotInfoBuilder, this.qsimConfig, mobsimTimer, linkWidthCalculator);
    }

    @Override
    public QLinkI createNetsimLink(Link link, QNodeI toQueueNode) {
        QLinkImpl.Builder linkBuilder = new QLinkImpl.Builder(this.context, this.netsimEngine);
        QueueWithBuffer.Builder laneFactory = new QueueWithBuffer.Builder(this.context);
        laneFactory.setVehicleQueue(this.vehicleQFactory.createVehicleQ());
        linkBuilder.setLaneFactory(laneFactory);
        linkBuilder.setLinkSpeedCalculator(this.linkSpeedCalculator);
        linkBuilder.setVehicleHandler(this.vehicleHandler);
        return linkBuilder.build(link, toQueueNode);
    }

    @Override
    public QNodeI createNetsimNode(Node node) {
        QNodeImpl.Builder builder = new QNodeImpl.Builder(this.netsimEngine, this.context);
        builder.setTurnAcceptanceLogic(this.turnAcceptanceLogic);
        return builder.build(node);
    }

    public final void setLinkSpeedCalculator(LinkSpeedCalculator linkSpeedCalculator) {
        this.linkSpeedCalculator = linkSpeedCalculator;
    }

    public final void setTurnAcceptanceLogic(TurnAcceptanceLogic turnAcceptanceLogic) {
        this.turnAcceptanceLogic = turnAcceptanceLogic;
    }

    public final void setVehicleHandler(VehicleHandler vehicleHandler) {
        this.vehicleHandler = vehicleHandler;
    }

    public final void setVehicleQFactory(VehicleQ.Factory<QVehicle> factory) {
        this.vehicleQFactory = factory;
    }
}

