/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import javax.inject.Inject;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeImpl;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;

public final class DefaultQNetworkFactory
implements QNetworkFactory {
    private EventsManager events;
    private Scenario scenario;
    private NetsimEngineContext context;
    private QNetsimEngine.NetsimInternalInterface netsimEngine;

    @Inject
    DefaultQNetworkFactory(EventsManager events, Scenario scenario) {
        this.events = events;
        this.scenario = scenario;
    }

    @Override
    public void initializeFactory(AgentCounter agentCounter, MobsimTimer mobsimTimer, QNetsimEngine.NetsimInternalInterface netsimEngine1) {
        this.netsimEngine = netsimEngine1;
        double effectiveCellSize = this.scenario.getNetwork().getEffectiveCellSize();
        SnapshotLinkWidthCalculator linkWidthCalculator = new SnapshotLinkWidthCalculator();
        linkWidthCalculator.setLinkWidthForVis(this.scenario.getConfig().qsim().getLinkWidthForVis());
        linkWidthCalculator.setLaneWidth(this.scenario.getNetwork().getEffectiveLaneWidth());
        AbstractAgentSnapshotInfoBuilder agentSnapshotInfoBuilder = QNetsimEngine.createAgentSnapshotInfoBuilder(this.scenario, linkWidthCalculator);
        this.context = new NetsimEngineContext(this.events, effectiveCellSize, agentCounter, agentSnapshotInfoBuilder, this.scenario.getConfig().qsim(), mobsimTimer, linkWidthCalculator);
    }

    @Override
    public QLinkI createNetsimLink(Link link, QNodeI toQueueNode) {
        QLinkImpl.Builder linkBuilder = new QLinkImpl.Builder(this.context, this.netsimEngine);
        return linkBuilder.build(link, toQueueNode);
    }

    @Override
    public QNodeI createNetsimNode(Node node) {
        QNodeImpl.Builder builder = new QNodeImpl.Builder(this.netsimEngine, this.context);
        return builder.build(node);
    }
}

