/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.mobsim.qsim.interfaces.SignalGroupState;
import org.matsim.core.mobsim.qsim.interfaces.SignalizeableItem;

public final class DefaultSignalizeableItem
implements SignalizeableItem {
    private Map<Id<Link>, SignalGroupState> toLinkIdSignalStates = null;
    private SignalGroupState allToLinksState = SignalGroupState.GREEN;
    private boolean linkGreen = true;
    private Set<Id<Link>> outLinks;

    public DefaultSignalizeableItem(Set<Id<Link>> outLinks) {
        this.outLinks = outLinks;
    }

    @Override
    public void setSignalStateAllTurningMoves(SignalGroupState state) {
        this.allToLinksState = state;
        this.linkGreen = DefaultSignalizeableItem.checkGreen(state);
    }

    private void initToLinkIdSignalStates() {
        this.allToLinksState = null;
        this.toLinkIdSignalStates = new HashMap<Id<Link>, SignalGroupState>();
        for (Id<Link> outLinkId : this.outLinks) {
            this.toLinkIdSignalStates.put(outLinkId, SignalGroupState.GREEN);
        }
    }

    @Override
    public void setSignalStateForTurningMove(SignalGroupState state, Id<Link> toLinkId) {
        if (this.toLinkIdSignalStates == null) {
            this.initToLinkIdSignalStates();
        }
        this.toLinkIdSignalStates.put(toLinkId, state);
        if (DefaultSignalizeableItem.checkGreen(state)) {
            this.linkGreen = true;
        } else {
            boolean foundGreen = false;
            for (SignalGroupState sgs : this.toLinkIdSignalStates.values()) {
                if (!DefaultSignalizeableItem.checkGreen(sgs)) continue;
                foundGreen = true;
            }
            this.linkGreen = foundGreen;
        }
    }

    private static boolean checkGreen(SignalGroupState state) {
        return state.equals((Object)SignalGroupState.GREEN) || state.equals((Object)SignalGroupState.YELLOW) || state.equals((Object)SignalGroupState.OFF);
    }

    @Override
    public boolean hasGreenForAllToLinks() {
        return this.linkGreen;
    }

    @Override
    public boolean hasGreenForToLink(Id<Link> toLinkId) {
        if (this.allToLinksState != null) {
            return DefaultSignalizeableItem.checkGreen(this.allToLinksState);
        }
        return DefaultSignalizeableItem.checkGreen(this.toLinkIdSignalStates.get(toLinkId));
    }

    @Override
    public void setSignalized(boolean isSignalized) {
    }
}

