/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetwork;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.TurnAcceptanceLogic;

public final class DefaultTurnAcceptanceLogic
implements TurnAcceptanceLogic {
    private static final Logger log = Logger.getLogger(DefaultTurnAcceptanceLogic.class);

    @Override
    public TurnAcceptanceLogic.AcceptTurn isAcceptingTurn(Link currentLink, QLaneI currentLane, Id<Link> nextLinkId, QVehicle veh, QNetwork qNetwork, double now) {
        if (nextLinkId == null) {
            log.error("Agent has no or wrong route! agentId=" + veh.getDriver().getId() + " currentLink=" + currentLink.getId().toString() + ". The agent is removed from the simulation.");
            return TurnAcceptanceLogic.AcceptTurn.ABORT;
        }
        QLinkI nextQLink = qNetwork.getNetsimLinks().get(nextLinkId);
        if (nextQLink == null) {
            log.warn("The link id " + nextLinkId + " is not available in the simulation network, but vehicle " + veh.getId() + " plans to travel on that link from link " + veh.getCurrentLink().getId());
            return TurnAcceptanceLogic.AcceptTurn.ABORT;
        }
        if (currentLink.getToNode() != nextQLink.getLink().getFromNode()) {
            log.warn("Cannot move vehicle " + veh.getId() + " from link " + currentLink.getId() + " to link " + nextQLink.getLink().getId());
            return TurnAcceptanceLogic.AcceptTurn.ABORT;
        }
        return TurnAcceptanceLogic.AcceptTurn.GO;
    }
}

