/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Collection;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;
import org.matsim.vis.snapshotwriters.VisVehicle;

final class EquiDistAgentSnapshotInfoBuilder
extends AbstractAgentSnapshotInfoBuilder {
    EquiDistAgentSnapshotInfoBuilder(Scenario sc, SnapshotLinkWidthCalculator linkWidthCalculator) {
        super(sc, linkWidthCalculator);
    }

    @Override
    public double calculateVehicleSpacing(double linkLength, double overallStorageCapacity, Collection<? extends VisVehicle> vehs) {
        double sum = 0.0;
        for (VisVehicle visVehicle : vehs) {
            sum += visVehicle.getSizeInEquivalents();
        }
        return linkLength / sum;
    }

    @Override
    public double calculateOdometerDistanceFromFromNode(double length, double spacing, double lastDistanceFromFromNode, double now, double freespeedTraveltime, double remainingTravelTime) {
        double distanceOnVector = 0.0;
        distanceOnVector = Double.isNaN(lastDistanceFromFromNode) ? length - spacing / 2.0 : lastDistanceFromFromNode - spacing;
        return distanceOnVector;
    }
}

