/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.List;
import javax.inject.Inject;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.DefaultQNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkLanesImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesToLinkAssignment;
import org.matsim.lanes.LanesUtils;
import org.matsim.lanes.ModelLane;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;

public final class QLanesNetworkFactory
implements QNetworkFactory {
    private Lanes laneDefinitions;
    private final QNetworkFactory delegate;
    private NetsimEngineContext context;
    private QSimConfigGroup qsimConfig;
    private EventsManager events;
    private Network network;
    private Scenario scenario;
    private QNetsimEngine.NetsimInternalInterface netsimEngine;

    @Inject
    public QLanesNetworkFactory(EventsManager events, Scenario scenario) {
        this.qsimConfig = scenario.getConfig().qsim();
        this.events = events;
        this.network = scenario.getNetwork();
        this.scenario = scenario;
        this.laneDefinitions = scenario.getLanes();
        this.delegate = new DefaultQNetworkFactory(events, scenario);
    }

    @Override
    public void initializeFactory(AgentCounter agentCounter, MobsimTimer mobsimTimer, QNetsimEngine.NetsimInternalInterface netsimEngine1) {
        this.netsimEngine = netsimEngine1;
        double effectiveCellSize = this.network.getEffectiveCellSize();
        SnapshotLinkWidthCalculator linkWidthCalculator = new SnapshotLinkWidthCalculator();
        linkWidthCalculator.setLinkWidthForVis(this.qsimConfig.getLinkWidthForVis());
        if (!Double.isNaN(this.network.getEffectiveLaneWidth())) {
            linkWidthCalculator.setLaneWidth(this.network.getEffectiveLaneWidth());
        }
        AbstractAgentSnapshotInfoBuilder agentSnapshotInfoBuilder = QNetsimEngine.createAgentSnapshotInfoBuilder(this.scenario, linkWidthCalculator);
        this.context = new NetsimEngineContext(this.events, effectiveCellSize, agentCounter, agentSnapshotInfoBuilder, this.qsimConfig, mobsimTimer, linkWidthCalculator);
        this.delegate.initializeFactory(agentCounter, mobsimTimer, netsimEngine1);
    }

    @Override
    public QLinkI createNetsimLink(Link link, QNodeI queueNode) {
        QLinkI ql = null;
        LanesToLinkAssignment l2l = (LanesToLinkAssignment)this.laneDefinitions.getLanesToLinkAssignments().get(link.getId());
        if (l2l != null) {
            List<ModelLane> lanes = LanesUtils.createLanes(link, l2l);
            QLinkLanesImpl.Builder builder = new QLinkLanesImpl.Builder(this.context, this.netsimEngine);
            ql = builder.build(link, queueNode, lanes);
        } else {
            ql = this.delegate.createNetsimLink(link, queueNode);
        }
        return ql;
    }

    @Override
    public QNodeI createNetsimNode(Node node) {
        return this.delegate.createNetsimNode(node);
    }
}

