/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.interfaces.SignalGroupState;
import org.matsim.core.mobsim.qsim.interfaces.SignalizeableItem;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.QueueWithBuffer;
import org.matsim.core.mobsim.qsim.qnetsimengine.TransitQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.DefaultLinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.LinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.DefaultVehicleHandler;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.VehicleHandler;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.lanes.VisLaneModelBuilder;
import org.matsim.lanes.VisLinkWLanes;
import org.matsim.vehicles.Vehicle;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.VisData;

public final class QLinkImpl
extends AbstractQLink
implements SignalizeableItem {
    private static final Logger log = Logger.getLogger(QLinkImpl.class);
    private final VisData visdata;
    private final QLaneI qlane;
    private NetsimEngineContext context;

    private QLinkImpl(Link link2, QNodeI toNode, LaneFactory roadFactory, NetsimEngineContext context, QNetsimEngine.NetsimInternalInterface netsimEngine, LinkSpeedCalculator linkSpeedCalculator, VehicleHandler vehicleHandler) {
        super(link2, toNode, context, netsimEngine, linkSpeedCalculator, vehicleHandler);
        this.context = context;
        this.qlane = roadFactory.createLane(this);
        this.visdata = new VisDataImpl();
        super.setTransitQLink(new TransitQLink(this.qlane));
    }

    @Override
    public void clearVehicles() {
        super.clearVehicles();
        this.qlane.clearVehicles();
    }

    @Override
    public boolean doSimStep() {
        double now = this.context.getSimTimer().getTimeOfDay();
        this.qlane.initBeforeSimStep();
        if (this.context.qsimConfig.isInsertingWaitingVehiclesBeforeDrivingVehicles()) {
            this.moveWaitToRoad();
            this.getTransitQLink().handleTransitVehiclesInStopQueue(now);
            this.qlane.doSimStep();
        } else {
            this.getTransitQLink().handleTransitVehiclesInStopQueue(now);
            this.qlane.doSimStep();
            this.moveWaitToRoad();
        }
        this.setActive(this.checkForActivity());
        return this.isActive();
    }

    private void moveWaitToRoad() {
        while (!this.getWaitingList().isEmpty()) {
            if (!this.qlane.isAcceptingFromWait(this.getWaitingList().peek())) {
                return;
            }
            QVehicle veh = this.getWaitingList().poll();
            double now = this.context.getSimTimer().getTimeOfDay();
            this.context.getEventsManager().processEvent(new VehicleEntersTrafficEvent(now, veh.getDriver().getId(), this.getLink().getId(), veh.getId(), veh.getDriver().getMode(), 1.0));
            if (this.getTransitQLink().addTransitToStopQueue(now, veh, this.getLink().getId())) continue;
            if (veh.getDriver().isWantingToArriveOnCurrentLink()) {
                this.qlane.addTransitSlightlyUpstreamOfStop(veh);
                continue;
            }
            this.qlane.addFromWait(veh);
        }
    }

    @Override
    public boolean isNotOfferingVehicle() {
        return this.qlane.isNotOfferingVehicle();
    }

    @Override
    public void recalcTimeVariantAttributes() {
        double now = this.context.getSimTimer().getTimeOfDay();
        this.qlane.changeUnscaledFlowCapacityPerSecond(this.getLink().getFlowCapacityPerSec(now));
        this.qlane.changeEffectiveNumberOfLanes(this.getLink().getNumberOfLanes(now));
        this.qlane.recalcTimeVariantAttributes();
    }

    @Override
    public QVehicle getVehicle(Id<Vehicle> vehicleId) {
        QVehicle ret = super.getVehicle(vehicleId);
        if (ret != null) {
            return ret;
        }
        for (QVehicle veh : this.getWaitingList()) {
            if (!veh.getId().equals(vehicleId)) continue;
            return veh;
        }
        return this.qlane.getVehicle(vehicleId);
    }

    @Override
    public Collection<MobsimVehicle> getAllNonParkedVehicles() {
        ArrayList<MobsimVehicle> vehicles = new ArrayList<MobsimVehicle>();
        vehicles.addAll(this.getTransitQLink().getTransitVehicleStopQueue());
        vehicles.addAll(this.getWaitingList());
        vehicles.addAll(this.qlane.getAllVehicles());
        return vehicles;
    }

    double getSpaceCap() {
        return this.qlane.getStorageCapacity();
    }

    double getSimulatedFlowCapacityPerTimeStep() {
        return this.qlane.getSimulatedFlowCapacityPerTimeStep();
    }

    @Override
    public VisData getVisData() {
        return this.visdata;
    }

    private boolean checkForActivity() {
        return this.qlane.isActive() || !this.getWaitingList().isEmpty() || !this.getTransitQLink().getTransitVehicleStopQueue().isEmpty();
    }

    @Override
    public void setSignalStateAllTurningMoves(SignalGroupState state) {
        ((SignalizeableItem)((Object)this.qlane)).setSignalStateAllTurningMoves(state);
    }

    @Override
    public void setSignalStateForTurningMove(SignalGroupState state, Id<Link> toLinkId) {
        ((SignalizeableItem)((Object)this.qlane)).setSignalStateForTurningMove(state, toLinkId);
    }

    @Override
    public void setSignalized(boolean isSignalized) {
        ((SignalizeableItem)((Object)this.qlane)).setSignalized(isSignalized);
    }

    @Override
    public boolean hasGreenForToLink(Id<Link> toLinkId) {
        return ((SignalizeableItem)((Object)this.qlane)).hasGreenForToLink(toLinkId);
    }

    @Override
    public boolean hasGreenForAllToLinks() {
        return ((SignalizeableItem)((Object)this.qlane)).hasGreenForAllToLinks();
    }

    @Override
    public List<QLaneI> getOfferingQLanes() {
        ArrayList<QLaneI> list = new ArrayList<QLaneI>();
        list.add(this.qlane);
        return list;
    }

    @Override
    public QLaneI getAcceptingQLane() {
        return this.qlane;
    }

    class VisDataImpl
    implements VisData {
        private VisLaneModelBuilder visModelBuilder = null;
        private VisLinkWLanes visLink = null;

        private VisDataImpl() {
            double nodeOffset = ((QLinkImpl)QLinkImpl.this).context.qsimConfig.getNodeOffset();
            if (nodeOffset != 0.0) {
                this.visModelBuilder = new VisLaneModelBuilder();
                IdentityTransformation transformation = new IdentityTransformation();
                this.visLink = this.visModelBuilder.createVisLinkLanes(transformation, QLinkImpl.this, nodeOffset += 2.0, null);
                this.visModelBuilder.recalculatePositions(this.visLink, ((QLinkImpl)QLinkImpl.this).context.linkWidthCalculator);
            }
        }

        @Override
        public Collection<AgentSnapshotInfo> addAgentSnapshotInfo(Collection<AgentSnapshotInfo> positions) {
            QLaneI.VisData roadVisData = QLinkImpl.this.getAcceptingQLane().getVisData();
            if (this.visLink != null) {
                ((QueueWithBuffer.VisDataImpl)roadVisData).setVisInfo(this.visLink.getLinkStartCoord(), this.visLink.getLinkEndCoord());
            }
            double now = QLinkImpl.this.context.getSimTimer().getTimeOfDay();
            positions = roadVisData.addAgentSnapshotInfo(positions, now);
            int cnt2 = 10;
            cnt2 = ((QLinkImpl)QLinkImpl.this).context.snapshotInfoBuilder.positionVehiclesFromTransitStop(positions, QLinkImpl.this.getLink(), QLinkImpl.this.getTransitQLink().getTransitVehicleStopQueue(), cnt2);
            cnt2 = ((QLinkImpl)QLinkImpl.this).context.snapshotInfoBuilder.positionVehiclesFromWaitingList(positions, QLinkImpl.this.getLink(), cnt2, QLinkImpl.this.getWaitingList());
            cnt2 = ((QLinkImpl)QLinkImpl.this).context.snapshotInfoBuilder.positionAgentsInActivities(positions, QLinkImpl.this.getLink(), QLinkImpl.this.getAdditionalAgentsOnLink(), cnt2);
            return positions;
        }
    }

    public static interface LaneFactory {
        public QLaneI createLane(AbstractQLink var1);
    }

    public static final class Builder {
        private QNetsimEngine.NetsimInternalInterface netsimEngine;
        private final NetsimEngineContext context;
        private LaneFactory laneFactory;
        private LinkSpeedCalculator linkSpeedCalculator = new DefaultLinkSpeedCalculator();
        private VehicleHandler vehicleHandler = new DefaultVehicleHandler();

        Builder(NetsimEngineContext context, QNetsimEngine.NetsimInternalInterface netsimEngine2) {
            this.context = context;
            this.netsimEngine = netsimEngine2;
        }

        final void setLaneFactory(LaneFactory laneFactory) {
            this.laneFactory = laneFactory;
        }

        public void setLinkSpeedCalculator(LinkSpeedCalculator linkSpeedCalculator) {
            this.linkSpeedCalculator = linkSpeedCalculator;
        }

        public void setVehicleHandler(VehicleHandler vehicleHandler) {
            this.vehicleHandler = vehicleHandler;
        }

        QLinkImpl build(Link link, QNodeI toNode) {
            if (this.laneFactory == null) {
                this.laneFactory = new QueueWithBuffer.Builder(this.context);
            }
            return new QLinkImpl(link, toNode, this.laneFactory, this.context, this.netsimEngine, this.linkSpeedCalculator, this.vehicleHandler);
        }
    }
}

