/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.QueueWithBuffer;
import org.matsim.core.mobsim.qsim.qnetsimengine.TransitQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.DefaultLinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.linkspeedcalculator.LinkSpeedCalculator;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.DefaultVehicleHandler;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicle_handler.VehicleHandler;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicleq.FIFOVehicleQ;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.lanes.Lane;
import org.matsim.lanes.ModelLane;
import org.matsim.lanes.VisLane;
import org.matsim.lanes.VisLaneModelBuilder;
import org.matsim.lanes.VisLinkWLanes;
import org.matsim.vehicles.Vehicle;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.VisData;

public final class QLinkLanesImpl
extends AbstractQLink {
    private static final Logger log = Logger.getLogger(QLinkLanesImpl.class);
    private final QNodeI toQueueNode;
    private QLaneI firstLaneQueue;
    private final LinkedHashMap<Id<Lane>, QLaneI> laneQueues;
    private List<QLaneI> toNodeLaneQueues = null;
    private VisData visdata = null;
    private final List<ModelLane> lanes;
    private final Map<Id<Lane>, Map<Id<Link>, List<QLaneI>>> nextQueueToLinkCache;
    private NetsimEngineContext context;

    private QLinkLanesImpl(Link link, QNodeI toNodeQ, List<ModelLane> lanes, NetsimEngineContext context, QNetsimEngine.NetsimInternalInterface netsimEngine, LinkSpeedCalculator linkSpeedCalculator, VehicleHandler vehicleHandler) {
        super(link, toNodeQ, context, netsimEngine, linkSpeedCalculator, vehicleHandler);
        this.context = context;
        this.toQueueNode = toNodeQ;
        this.laneQueues = new LinkedHashMap();
        this.toNodeLaneQueues = new ArrayList<QLaneI>();
        this.lanes = lanes;
        this.nextQueueToLinkCache = new LinkedHashMap<Id<Lane>, Map<Id<Link>, List<QLaneI>>>();
        this.initLaneQueues();
        this.visdata = new VisDataImpl();
        this.setTransitQLink(new TransitQLink(this.firstLaneQueue));
    }

    private void initLaneQueues() {
        Stack<QueueWithBuffer> stack = new Stack<QueueWithBuffer>();
        HashMap<Id<Lane>, QueueWithBuffer> queueByIdMap = new HashMap<Id<Lane>, QueueWithBuffer>();
        HashMap laneIdToLinksMap = new HashMap();
        for (ModelLane lane : this.lanes) {
            ModelLane toLane;
            Set toLinks;
            Id<Lane> laneId = lane.getLaneData().getId();
            QueueWithBuffer.Builder builder = new QueueWithBuffer.Builder(this.context);
            builder.setVehicleQueue(new FIFOVehicleQ());
            builder.setLaneId(laneId);
            builder.setLength(lane.getLength());
            builder.setEffectiveNumberOfLanes(lane.getLaneData().getNumberOfRepresentedLanes());
            builder.setFlowCapacity_s(lane.getLaneData().getCapacityVehiclesPerHour() / 3600.0);
            QueueWithBuffer queue = builder.createLane(this);
            queueByIdMap.put(laneId, queue);
            this.firstLaneQueue = queue;
            stack.push(queue);
            HashSet<Id<Link>> toLinkIds = new HashSet<Id<Link>>();
            if (lane.getToLanes() == null || lane.getToLanes().isEmpty()) {
                this.toNodeLaneQueues.add(queue);
                toLinkIds.addAll(lane.getLaneData().getToLinkIds());
                laneIdToLinksMap.put(laneId, toLinkIds);
                continue;
            }
            LinkedHashMap toLinkIdDownstreamQueues = new LinkedHashMap();
            this.nextQueueToLinkCache.put(Id.create(queue.getId(), Lane.class), toLinkIdDownstreamQueues);
            Iterator<ModelLane> iterator = lane.getToLanes().iterator();
            while (iterator.hasNext() && (toLinks = (Set)laneIdToLinksMap.get((toLane = iterator.next()).getLaneData().getId())) != null) {
                if (!laneIdToLinksMap.containsKey(laneId)) {
                    laneIdToLinksMap.put(laneId, new HashSet());
                }
                ((Set)laneIdToLinksMap.get(laneId)).addAll(toLinks);
                for (Id toLinkId : toLinks) {
                    ArrayList downstreamQueues = (ArrayList)toLinkIdDownstreamQueues.get(toLinkId);
                    if (downstreamQueues == null) {
                        downstreamQueues = new ArrayList();
                        toLinkIdDownstreamQueues.put(toLinkId, downstreamQueues);
                    }
                    downstreamQueues.add(queueByIdMap.get(toLane.getLaneData().getId()));
                }
            }
        }
        while (!stack.isEmpty()) {
            QLaneI queue = (QLaneI)stack.pop();
            this.laneQueues.put(queue.getId(), queue);
        }
    }

    @Override
    public List<QLaneI> getOfferingQLanes() {
        return this.toNodeLaneQueues;
    }

    @Override
    public void clearVehicles() {
        super.clearVehicles();
        for (QLaneI lane : this.laneQueues.values()) {
            lane.clearVehicles();
        }
    }

    @Override
    public boolean doSimStep() {
        double now = this.context.getSimTimer().getTimeOfDay();
        boolean lanesActive = false;
        boolean movedWaitToRoad = false;
        if (this.context.qsimConfig.isInsertingWaitingVehiclesBeforeDrivingVehicles()) {
            this.moveWaitToRoad(now);
            this.getTransitQLink().handleTransitVehiclesInStopQueue(now);
            lanesActive = this.moveLanes();
        } else {
            this.getTransitQLink().handleTransitVehiclesInStopQueue(now);
            lanesActive = this.moveLanes();
            movedWaitToRoad = this.moveWaitToRoad(now);
        }
        this.setActive(lanesActive || movedWaitToRoad || !this.getWaitingList().isEmpty() || !this.getTransitQLink().getTransitVehicleStopQueue().isEmpty());
        return this.isActive();
    }

    private boolean moveLanes() {
        boolean activeLane = false;
        for (QLaneI lane : this.laneQueues.values()) {
            if (this.toNodeLaneQueues.contains(lane)) continue;
            this.moveBufferToNextLane(lane);
        }
        for (QLaneI lane : this.laneQueues.values()) {
            lane.initBeforeSimStep();
        }
        for (QLaneI lane : this.laneQueues.values()) {
            lane.doSimStep();
            activeLane = activeLane || lane.isActive();
        }
        return activeLane;
    }

    private void moveBufferToNextLane(QLaneI qlane) {
        while (!qlane.isNotOfferingVehicle()) {
            QVehicle veh = qlane.getFirstVehicle();
            Id<Link> toLinkId = veh.getDriver().chooseNextLinkId();
            QLaneI nextQueue = this.chooseNextLane(qlane, toLinkId);
            if (nextQueue != null) {
                if (!nextQueue.isAcceptingFromUpstream()) break;
                qlane.popFirstVehicle();
                nextQueue.addFromUpstream(veh);
                continue;
            }
            StringBuilder b = new StringBuilder();
            b.append("Person Id: ").append(veh.getDriver().getId());
            b.append(" is on Lane Id ").append(qlane.getId());
            b.append(" on Link Id ").append(this.getLink().getId());
            b.append(" and wants to drive to Link Id ").append(toLinkId);
            b.append(" but there is no Lane leading to that Link!");
            log.error(b.toString());
            throw new IllegalStateException(b.toString());
        }
    }

    private QLaneI chooseNextLane(QLaneI queue, Id<Link> toLinkId) {
        List<QLaneI> toQueues = this.nextQueueToLinkCache.get(queue.getId()).get(toLinkId);
        QLaneI retLane = toQueues.get(0);
        if (toQueues.size() == 1) {
            return retLane;
        }
        for (int i = 1; i < toQueues.size(); ++i) {
            QLaneI toQueue = toQueues.get(i);
            if (!(toQueue.getLoadIndicator() < retLane.getLoadIndicator())) continue;
            retLane = toQueue;
        }
        return retLane;
    }

    private boolean moveWaitToRoad(double now) {
        boolean movedWaitToRoad = false;
        while (!this.getWaitingList().isEmpty()) {
            if (!this.firstLaneQueue.isAcceptingFromWait(this.getWaitingList().peek())) {
                return movedWaitToRoad;
            }
            QVehicle veh = this.getWaitingList().poll();
            movedWaitToRoad = true;
            this.context.getEventsManager().processEvent(new VehicleEntersTrafficEvent(now, veh.getDriver().getId(), this.getLink().getId(), veh.getId(), veh.getDriver().getMode(), 1.0));
            if (this.getTransitQLink().addTransitToStopQueue(now, veh, this.getLink().getId())) continue;
            if (veh.getDriver().isWantingToArriveOnCurrentLink()) {
                this.firstLaneQueue.addTransitSlightlyUpstreamOfStop(veh);
                continue;
            }
            this.firstLaneQueue.addFromWait(veh);
        }
        return movedWaitToRoad;
    }

    @Override
    public boolean isNotOfferingVehicle() {
        for (QLaneI lane : this.toNodeLaneQueues) {
            if (lane.isNotOfferingVehicle()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void recalcTimeVariantAttributes() {
        for (QLaneI lane : this.laneQueues.values()) {
            lane.recalcTimeVariantAttributes();
        }
    }

    @Override
    public QVehicle getVehicle(Id<Vehicle> vehicleId) {
        QVehicle ret = super.getVehicle(vehicleId);
        if (ret != null) {
            return ret;
        }
        for (QVehicle veh : this.getWaitingList()) {
            if (!veh.getId().equals(vehicleId)) continue;
            return veh;
        }
        for (QLaneI lane : this.laneQueues.values()) {
            ret = lane.getVehicle(vehicleId);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public final Collection<MobsimVehicle> getAllNonParkedVehicles() {
        ArrayList<MobsimVehicle> ret = new ArrayList<MobsimVehicle>(this.getWaitingList());
        for (QLaneI lane : this.laneQueues.values()) {
            ret.addAll(lane.getAllVehicles());
        }
        return ret;
    }

    double getSpaceCap() {
        double total = 0.0;
        for (QLaneI lane : this.laneQueues.values()) {
            double storageCapacity = lane.getStorageCapacity();
            log.warn("storageCapacity=" + storageCapacity);
            total += storageCapacity;
        }
        return total;
    }

    @Override
    public QNodeI getToNode() {
        return this.toQueueNode;
    }

    double getSimulatedFlowCapacity() {
        return this.firstLaneQueue.getSimulatedFlowCapacityPerTimeStep();
    }

    public LinkedHashMap<Id<Lane>, QLaneI> getQueueLanes() {
        return this.laneQueues;
    }

    @Override
    public VisData getVisData() {
        return this.visdata;
    }

    QLaneI getOriginalLane() {
        return this.firstLaneQueue;
    }

    @Override
    public QLaneI getAcceptingQLane() {
        return this.firstLaneQueue;
    }

    class VisDataImpl
    implements VisData {
        private VisLaneModelBuilder visModelBuilder = null;
        private VisLinkWLanes visLink = null;

        VisDataImpl() {
            double nodeOffset = ((QLinkLanesImpl)QLinkLanesImpl.this).context.qsimConfig.getNodeOffset();
            if (nodeOffset != 0.0) {
                this.visModelBuilder = new VisLaneModelBuilder();
                IdentityTransformation transformation = new IdentityTransformation();
                this.visLink = this.visModelBuilder.createVisLinkLanes(transformation, QLinkLanesImpl.this, nodeOffset += 2.0, QLinkLanesImpl.this.lanes);
                this.visModelBuilder.recalculatePositions(this.visLink, ((QLinkLanesImpl)QLinkLanesImpl.this).context.linkWidthCalculator);
            }
        }

        @Override
        public Collection<AgentSnapshotInfo> addAgentSnapshotInfo(Collection<AgentSnapshotInfo> positions) {
            double now = QLinkLanesImpl.this.context.getSimTimer().getTimeOfDay();
            if (this.visLink != null) {
                for (QLaneI ql : QLinkLanesImpl.this.laneQueues.values()) {
                    VisLane otfLane = this.visLink.getLaneData().get(ql.getId().toString());
                    ((QueueWithBuffer.VisDataImpl)ql.getVisData()).setVisInfo(otfLane.getStartCoord(), otfLane.getEndCoord());
                }
            }
            for (QLaneI road : QLinkLanesImpl.this.getQueueLanes().values()) {
                road.getVisData().addAgentSnapshotInfo(positions, now);
            }
            int cnt2 = 10;
            cnt2 = ((QLinkLanesImpl)QLinkLanesImpl.this).context.snapshotInfoBuilder.positionVehiclesFromTransitStop(positions, QLinkLanesImpl.this.getLink(), QLinkLanesImpl.this.getTransitQLink().getTransitVehicleStopQueue(), cnt2);
            ((QLinkLanesImpl)QLinkLanesImpl.this).context.snapshotInfoBuilder.positionVehiclesFromWaitingList(positions, QLinkLanesImpl.this.getLink(), cnt2, QLinkLanesImpl.this.getWaitingList());
            cnt2 = QLinkLanesImpl.this.getWaitingList().size();
            ((QLinkLanesImpl)QLinkLanesImpl.this).context.snapshotInfoBuilder.positionAgentsInActivities(positions, QLinkLanesImpl.this.getLink(), QLinkLanesImpl.this.getAdditionalAgentsOnLink(), cnt2);
            return positions;
        }
    }

    static final class Builder {
        private final NetsimEngineContext context;
        private final QNetsimEngine.NetsimInternalInterface netsimEngine;
        private LinkSpeedCalculator linkSpeedCalculator = new DefaultLinkSpeedCalculator();
        private VehicleHandler vehicleHandler = new DefaultVehicleHandler();

        public Builder(NetsimEngineContext context, QNetsimEngine.NetsimInternalInterface netsimEngine) {
            this.context = context;
            this.netsimEngine = netsimEngine;
        }

        public final void setLinkSpeedCalculator(LinkSpeedCalculator linkSpeedCalculator) {
            this.linkSpeedCalculator = linkSpeedCalculator;
        }

        AbstractQLink build(Link link, QNodeI toNodeQ, List<ModelLane> lanes) {
            return new QLinkLanesImpl(link, toNodeQ, lanes, this.context, this.netsimEngine, this.linkSpeedCalculator, this.vehicleHandler);
        }
    }
}

