/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.qsim.InternalInterface;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.interfaces.MobsimEngine;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.interfaces.NetsimLink;
import org.matsim.core.mobsim.qsim.interfaces.NetsimNetwork;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQNode;
import org.matsim.core.mobsim.qsim.qnetsimengine.DefaultQNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.EquiDistAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngineRunner;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetwork;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.QueueAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.VehicularDepartureHandler;
import org.matsim.core.utils.misc.Time;
import org.matsim.vehicles.Vehicle;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;

public class QNetsimEngine
implements MobsimEngine,
NetsimEngine {
    NetsimInternalInterface ii = new NetsimInternalInterface(){

        @Override
        public QNetwork getNetsimNetwork() {
            return QNetsimEngine.this.network;
        }

        @Override
        public void arrangeNextAgentState(MobsimAgent driver) {
            QNetsimEngine.this.arrangeNextAgentState(driver);
        }

        @Override
        public void letVehicleArrive(QVehicle veh) {
            QNetsimEngine.this.letVehicleArrive(veh);
        }
    };
    private static final Logger log = Logger.getLogger(QNetsimEngine.class);
    private static final int INFO_PERIOD = 3600;
    private QNetwork network;
    private final Map<Id<Vehicle>, QVehicle> vehicles = new HashMap<Id<Vehicle>, QVehicle>();
    private final QSim qsim;
    private final VehicularDepartureHandler dpHandler;
    private double infoTime = 0.0;
    private final int numOfThreads;
    private List<QNetsimEngineRunner> engines;
    private Phaser startBarrier;
    private Phaser endBarrier;
    private final Set<QLinkI> linksToActivateInitially = new HashSet<QLinkI>();
    private InternalInterface internalInterface = null;
    private int numOfRunners;
    private ExecutorService pool;
    private final boolean usingThreadpool;
    public static int numObservedTimeSteps = 86400;
    public static boolean printRunTimesPerTimeStep = false;
    private static int wrnCnt = 0;

    @Override
    public void setInternalInterface(InternalInterface internalInterface) {
        this.internalInterface = internalInterface;
    }

    public QNetsimEngine(QSim sim) {
        this(sim, null);
    }

    @Inject
    public QNetsimEngine(QSim sim, QNetworkFactory netsimNetworkFactory) {
        this.qsim = sim;
        Config config = sim.getScenario().getConfig();
        QSimConfigGroup qsimConfigGroup = config.qsim();
        this.usingThreadpool = qsimConfigGroup.isUsingThreadpool();
        QSimConfigGroup qSimConfigGroup = this.qsim.getScenario().getConfig().qsim();
        QSimConfigGroup.VehicleBehavior vehicleBehavior = qSimConfigGroup.getVehicleBehavior();
        switch (vehicleBehavior) {
            case exception: 
            case teleport: 
            case wait: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown vehicle behavior option.");
            }
        }
        this.dpHandler = new VehicularDepartureHandler(this, vehicleBehavior, qSimConfigGroup);
        if (qSimConfigGroup.getLinkDynamics().equals((Object)QSimConfigGroup.LinkDynamics.SeepageQ)) {
            log.info("Seepage is allowed. Seep mode(s) is(are) " + qSimConfigGroup.getSeepModes() + ".");
            if (qSimConfigGroup.isSeepModeStorageFree()) {
                log.warn("Seep mode(s) " + qSimConfigGroup.getSeepModes() + " does not take storage space thus only considered for flow capacities.");
            }
        }
        if (netsimNetworkFactory != null) {
            this.network = new QNetwork(sim.getScenario().getNetwork(), netsimNetworkFactory);
        } else {
            Scenario scenario = sim.getScenario();
            EventsManager events = sim.getEventsManager();
            DefaultQNetworkFactory netsimNetworkFactory2 = new DefaultQNetworkFactory(events, scenario);
            MobsimTimer mobsimTimer = sim.getSimTimer();
            AgentCounter agentCounter = sim.getAgentCounter();
            netsimNetworkFactory2.initializeFactory(agentCounter, mobsimTimer, this.ii);
            this.network = new QNetwork(sim.getScenario().getNetwork(), netsimNetworkFactory2);
        }
        this.network.initialize(this, sim.getAgentCounter(), sim.getSimTimer());
        this.numOfThreads = sim.getScenario().getConfig().qsim().getNumberOfThreads();
    }

    @Override
    public void addParkedVehicle(MobsimVehicle veh, Id<Link> startLinkId) {
        QLinkI qlink;
        if (this.vehicles.put(veh.getId(), (QVehicle)veh) != null && wrnCnt < 1) {
            ++wrnCnt;
            log.warn("existing vehicle in mobsim was just overwritten by other vehicle with same ID.  Not clear what this means.  Continuing anyways ...");
            log.warn(" This message given only once.");
        }
        if ((qlink = this.network.getNetsimLinks().get(startLinkId)) == null) {
            throw new RuntimeException("requested link with id=" + startLinkId + " does not exist in network. Possible vehicles " + "or activities or facilities are registered to a different network.");
        }
        qlink.addParkedVehicle(veh);
    }

    static AbstractAgentSnapshotInfoBuilder createAgentSnapshotInfoBuilder(Scenario scenario, SnapshotLinkWidthCalculator linkWidthCalculator) {
        QSimConfigGroup.SnapshotStyle snapshotStyle = scenario.getConfig().qsim().getSnapshotStyle();
        switch (snapshotStyle) {
            case queue: {
                return new QueueAgentSnapshotInfoBuilder(scenario, linkWidthCalculator);
            }
            case withHoles: 
            case withHolesAndShowHoles: {
                return new QueueAgentSnapshotInfoBuilder(scenario, linkWidthCalculator);
            }
            case kinematicWaves: {
                log.warn("The snapshotStyle \"" + (Object)((Object)snapshotStyle) + "\" is not explicitly supported. Using \"" + (Object)((Object)QSimConfigGroup.SnapshotStyle.withHoles) + "\" instead.");
                return new QueueAgentSnapshotInfoBuilder(scenario, linkWidthCalculator);
            }
            case equiDist: {
                return new EquiDistAgentSnapshotInfoBuilder(scenario, linkWidthCalculator);
            }
        }
        log.warn("The snapshotStyle \"" + (Object)((Object)snapshotStyle) + "\" is not supported. Using equiDist");
        return new EquiDistAgentSnapshotInfoBuilder(scenario, linkWidthCalculator);
    }

    @Override
    public void onPrepareSim() {
        this.infoTime = Math.floor(this.internalInterface.getMobsim().getSimTimer().getSimStartTime() / 3600.0) * 3600.0;
        this.initQSimEngineThreads();
    }

    @Override
    public void afterSim() {
        for (QNetsimEngineRunner engine : this.engines) {
            engine.afterSim();
        }
        if (this.usingThreadpool) {
            this.pool.shutdown();
        } else {
            this.startBarrier.arriveAndAwaitAdvance();
        }
        for (QLinkI link : this.network.getNetsimLinks().values()) {
            link.clearVehicles();
        }
    }

    @Override
    public void doSimStep(double time) {
        this.run(time);
        this.printSimLog(time);
    }

    private void run(double time) {
        for (QNetsimEngineRunner qNetsimEngineRunner : this.engines) {
            qNetsimEngineRunner.setTime(time);
        }
        if (this.usingThreadpool) {
            try {
                for (QNetsimEngineRunner qNetsimEngineRunner : this.engines) {
                    qNetsimEngineRunner.setMovingNodes(true);
                }
                for (Future future : this.pool.invokeAll(this.engines)) {
                    future.get();
                }
                for (QNetsimEngineRunner qNetsimEngineRunner : this.engines) {
                    qNetsimEngineRunner.setMovingNodes(false);
                }
                for (Future future : this.pool.invokeAll(this.engines)) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.startBarrier.arriveAndAwaitAdvance();
            this.endBarrier.arriveAndAwaitAdvance();
        }
    }

    void printSimLog(double time) {
        if (time >= this.infoTime) {
            this.infoTime += 3600.0;
            int nofActiveLinks = this.getNumberOfSimulatedLinks();
            int nofActiveNodes = this.getNumberOfSimulatedNodes();
            log.info("SIMULATION (QNetsimEngine) AT " + Time.writeTime(time) + " : #links=" + nofActiveLinks + " #nodes=" + nofActiveNodes);
        }
    }

    public int getNumberOfSimulatedLinks() {
        int numLinks = 0;
        for (QNetsimEngineRunner engine : this.engines) {
            numLinks += engine.getNumberOfSimulatedLinks();
        }
        return numLinks;
    }

    public int getNumberOfSimulatedNodes() {
        int numNodes = 0;
        for (QNetsimEngineRunner engine : this.engines) {
            numNodes += engine.getNumberOfSimulatedNodes();
        }
        return numNodes;
    }

    @Override
    public NetsimNetwork getNetsimNetwork() {
        return this.network;
    }

    public VehicularDepartureHandler getDepartureHandler() {
        return this.dpHandler;
    }

    public final Map<Id<Vehicle>, QVehicle> getVehicles() {
        return Collections.unmodifiableMap(this.vehicles);
    }

    @Override
    public final void registerAdditionalAgentOnLink(MobsimAgent planAgent) {
        Id<Link> linkId = planAgent.getCurrentLinkId();
        if (linkId != null) {
            NetsimLink qLink = this.network.getNetsimLink((Id)linkId);
            if (qLink == null) {
                throw new RuntimeException("netsim link lookup failed; agentId=" + planAgent.getId() + "; linkId=" + linkId);
            }
            qLink.registerAdditionalAgentOnLink(planAgent);
        }
    }

    @Override
    public MobsimAgent unregisterAdditionalAgentOnLink(Id<Person> agentId, Id<Link> linkId) {
        if (linkId == null) {
            return null;
        }
        NetsimLink qLink = this.network.getNetsimLink((Id)linkId);
        return qLink.unregisterAdditionalAgentOnLink(agentId);
    }

    private void letVehicleArrive(QVehicle veh) {
        double now = this.qsim.getSimTimer().getTimeOfDay();
        MobsimDriverAgent driver = veh.getDriver();
        this.qsim.getEventsManager().processEvent(new PersonLeavesVehicleEvent(now, driver.getId(), veh.getId()));
        veh.setDriver(null);
        driver.endLegAndComputeNextState(now);
        this.internalInterface.arrangeNextAgentState(driver);
    }

    private void initQSimEngineThreads() {
        this.engines = new ArrayList<QNetsimEngineRunner>();
        this.startBarrier = new Phaser(this.numOfThreads + 1);
        Phaser separationBarrier = new Phaser(this.numOfThreads);
        this.endBarrier = new Phaser(this.numOfThreads + 1);
        this.numOfRunners = this.numOfThreads;
        if (this.usingThreadpool) {
            this.pool = Executors.newFixedThreadPool(this.numOfThreads, new NamedThreadFactory());
        }
        for (int i = 0; i < this.numOfRunners; ++i) {
            QNetsimEngineRunner engine;
            if (this.usingThreadpool) {
                engine = new QNetsimEngineRunner();
            } else {
                engine = new QNetsimEngineRunner(this.startBarrier, separationBarrier, this.endBarrier);
                Thread thread = new Thread(engine);
                thread.setName("QNetsimEngineRunner_" + i);
                thread.setDaemon(true);
                thread.start();
            }
            this.engines.add(engine);
        }
        this.assignNetElementActivators();
    }

    private void assignNetElementActivators() {
        int[] nodes = new int[this.numOfRunners];
        int[] links = new int[this.numOfRunners];
        int roundRobin = 0;
        for (QNodeI node : this.network.getNetsimNodes().values()) {
            int i = roundRobin % this.numOfRunners;
            if (node instanceof AbstractQNode) {
                ((AbstractQNode)node).setNetElementActivationRegistry(this.engines.get(i));
            }
            int n = i;
            nodes[n] = nodes[n] + 1;
            for (Link link : node.getNode().getOutLinks().values()) {
                AbstractQLink qLink = (AbstractQLink)this.network.getNetsimLink(link.getId());
                qLink.setNetElementActivationRegistry(this.engines.get(i));
                if (this.linksToActivateInitially.remove(qLink) || this.qsim.getScenario().getConfig().qsim().getSimStarttimeInterpretation() == QSimConfigGroup.StarttimeInterpretation.onlyUseStarttime) {
                    this.engines.get(i).registerLinkAsActive(qLink);
                }
                int n2 = i;
                links[n2] = links[n2] + 1;
            }
            ++roundRobin;
        }
        for (int i = 0; i < this.engines.size(); ++i) {
            log.info("Assigned " + nodes[i] + " nodes and " + links[i] + " links to QSimEngineRunner #" + i);
        }
        this.linksToActivateInitially.clear();
    }

    public void printEngineRunTimes() {
        if (!QSim.analyzeRunTimes) {
            return;
        }
        if (printRunTimesPerTimeStep) {
            log.info("detailed QNetsimEngineRunner run times per time step:");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\t");
        sb.append("time");
        for (int i = 0; i < this.engines.size(); ++i) {
            sb.append("\t");
            sb.append("thread_");
            sb.append(Integer.toString(i));
        }
        sb.append("\t");
        sb.append("min");
        sb.append("\t");
        sb.append("max");
        if (printRunTimesPerTimeStep) {
            log.info(sb.toString());
        }
        long sum = 0L;
        long sumMin = 0L;
        long sumMax = 0L;
        for (int i = 0; i < numObservedTimeSteps; ++i) {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("\t" + i);
            long min2 = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (QNetsimEngineRunner runner : this.engines) {
                long runTime = runner.runTimes[i];
                sum += runTime;
                if (runTime < min2) {
                    min2 = runTime;
                }
                if (runTime > max) {
                    max = runTime;
                }
                sb2.append("\t");
                sb2.append(Long.toString(runTime));
            }
            sb2.append("\t");
            sb2.append(Long.toString(min2));
            sb2.append("\t");
            sb2.append(Long.toString(max));
            if (printRunTimesPerTimeStep) {
                log.info(sb2.toString());
            }
            sumMin += min2;
            sumMax += max;
        }
        log.info("sum min run times: " + sumMin);
        log.info("sum max run times: " + sumMax);
        log.info("sum all run times / num threads: " + sum / (long)this.numOfThreads);
    }

    private final void arrangeNextAgentState(MobsimAgent pp) {
        this.internalInterface.arrangeNextAgentState(pp);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private int count = 0;

        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "QNetsimEngine_PooledThread_" + this.count++);
        }
    }

    public static interface NetsimInternalInterface {
        public QNetwork getNetsimNetwork();

        public void arrangeNextAgentState(MobsimAgent var1);

        public void letVehicleArrive(QVehicle var1);
    }
}

