/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Phaser;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.qsim.QSim;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetElementActivationRegistry;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;

class QNetsimEngineRunner
extends NetElementActivationRegistry
implements Runnable,
Callable<Boolean> {
    private double time = 0.0;
    private volatile boolean simulationRunning = true;
    private final Phaser startBarrier;
    private final Phaser separationBarrier;
    private final Phaser endBarrier;
    private final Queue<QNodeI> nodesQueue = new ConcurrentLinkedQueue<QNodeI>();
    private final List<QLinkI> linksList = new LinkedList<QLinkI>();
    private boolean lockNodes = false;
    private boolean lockLinks = false;
    private boolean movingNodes;
    long[] runTimes = (long[])(QSim.analyzeRunTimes ? new long[QNetsimEngine.numObservedTimeSteps] : null);
    private long startTime = 0L;

    QNetsimEngineRunner(Phaser startBarrier, Phaser separationBarrier, Phaser endBarrier) {
        this.startBarrier = startBarrier;
        this.separationBarrier = separationBarrier;
        this.endBarrier = endBarrier;
    }

    QNetsimEngineRunner() {
        this.startBarrier = null;
        this.separationBarrier = null;
        this.endBarrier = null;
    }

    void setTime(double t) {
        this.time = t;
    }

    public void afterSim() {
        this.simulationRunning = false;
    }

    @Override
    public Boolean call() {
        if (!this.simulationRunning) {
            Gbl.printCurrentThreadCpuTime();
            return false;
        }
        if (this.movingNodes) {
            this.moveNodes();
        } else {
            this.moveLinks();
        }
        return true;
    }

    @Override
    public void run() {
        while (true) {
            this.startBarrier.arriveAndAwaitAdvance();
            if (QSim.analyzeRunTimes) {
                this.startTime = System.nanoTime();
            }
            if (!this.simulationRunning) {
                Gbl.printCurrentThreadCpuTime();
                return;
            }
            this.moveNodes();
            this.separationBarrier.arriveAndAwaitAdvance();
            this.moveLinks();
            if (QSim.analyzeRunTimes) {
                long end = System.nanoTime();
                int bin = (int)this.time;
                if (bin < this.runTimes.length) {
                    this.runTimes[bin] = end - this.startTime;
                }
            }
            this.endBarrier.arriveAndAwaitAdvance();
        }
    }

    private void moveNodes() {
        this.lockNodes = true;
        Iterator simNodes = this.nodesQueue.iterator();
        while (simNodes.hasNext()) {
            QNodeI node = (QNodeI)simNodes.next();
            boolean remainsActive = node.doSimStep(this.time);
            if (remainsActive) continue;
            simNodes.remove();
        }
        this.lockNodes = false;
    }

    private void moveLinks() {
        this.lockLinks = true;
        ListIterator<QLinkI> simLinks = this.linksList.listIterator();
        while (simLinks.hasNext()) {
            QLinkI link = simLinks.next();
            boolean remainsActive = link.doSimStep();
            if (remainsActive) continue;
            simLinks.remove();
        }
        this.lockLinks = false;
    }

    @Override
    protected void registerLinkAsActive(QLinkI link) {
        if (this.lockLinks) {
            throw new RuntimeException("Tried to activate a QLink at a time where this was not allowed. Aborting!");
        }
        this.linksList.add(link);
    }

    @Override
    public int getNumberOfSimulatedLinks() {
        return this.linksList.size();
    }

    @Override
    protected void registerNodeAsActive(QNodeI node) {
        if (this.lockNodes) {
            throw new RuntimeException("Tried to activate a QNode at a time where this was not allowed. Aborting!");
        }
        this.nodesQueue.add(node);
    }

    @Override
    public int getNumberOfSimulatedNodes() {
        return this.nodesQueue.size();
    }

    public void setMovingNodes(boolean movingNodes) {
        this.movingNodes = movingNodes;
    }
}

