/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.interfaces.NetsimNetwork;
import org.matsim.core.mobsim.qsim.interfaces.NetsimNode;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.vis.snapshotwriters.VisLink;

public class QNetwork
implements NetsimNetwork {
    private final Map<Id<Link>, QLinkI> links;
    private final Map<Id<Node>, QNodeI> nodes;
    private final Network network;
    private final QNetworkFactory queueNetworkFactory;
    QNetsimEngine simEngine;

    QNetwork(Network network, QNetworkFactory netsimNetworkFactory) {
        this.network = network;
        this.queueNetworkFactory = netsimNetworkFactory;
        this.links = new LinkedHashMap<Id<Link>, QLinkI>((int)((double)network.getLinks().size() * 1.1), 0.95f);
        this.nodes = new LinkedHashMap<Id<Node>, QNodeI>((int)((double)network.getLinks().size() * 1.1), 0.95f);
    }

    public void initialize(QNetsimEngine simEngine1, AgentCounter agentCounter, MobsimTimer simTimer) {
        this.simEngine = simEngine1;
        this.queueNetworkFactory.initializeFactory(agentCounter, simTimer, simEngine1.ii);
        for (Node node : this.network.getNodes().values()) {
            this.nodes.put(node.getId(), this.queueNetworkFactory.createNetsimNode(node));
        }
        for (Link link : this.network.getLinks().values()) {
            QLinkI qlink = this.queueNetworkFactory.createNetsimLink(link, this.nodes.get(link.getToNode().getId()));
            this.links.put(link.getId(), qlink);
        }
        for (QNodeI qNodeI : this.nodes.values()) {
            qNodeI.init();
        }
    }

    @Override
    public Network getNetwork() {
        return this.network;
    }

    public Map<Id<Link>, QLinkI> getNetsimLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    @Override
    public Map<Id<Link>, ? extends VisLink> getVisLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    public Map<Id<Node>, QNodeI> getNetsimNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    @Override
    public QLinkI getNetsimLink(Id<Link> id) {
        return this.links.get(id);
    }

    @Override
    public NetsimNode getNetsimNode(Id<Node> id) {
        return this.nodes.get(id);
    }
}

