/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.qsim.interfaces.NetsimLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQNode;
import org.matsim.core.mobsim.qsim.qnetsimengine.DefaultTurnAcceptanceLogic;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetwork;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.TurnAcceptanceLogic;

final class QNodeImpl
extends AbstractQNode {
    private static final Logger log = Logger.getLogger(QNodeImpl.class);
    private final QLinkI[] inLinksArrayCache;
    private final QLinkI[] tempLinks;
    private final Random random;
    private final NetsimEngineContext context;
    private final QNetsimEngine.NetsimInternalInterface netsimEngine;
    private final TurnAcceptanceLogic turnAcceptanceLogic;
    private static int wrnCnt = 0;

    private QNodeImpl(Node n, NetsimEngineContext context, QNetsimEngine.NetsimInternalInterface netsimEngine2, TurnAcceptanceLogic turnAcceptanceLogic) {
        super(n);
        this.netsimEngine = netsimEngine2;
        this.context = context;
        this.turnAcceptanceLogic = turnAcceptanceLogic;
        int nofInLinks = n.getInLinks().size();
        this.inLinksArrayCache = new QLinkI[nofInLinks];
        this.tempLinks = new QLinkI[nofInLinks];
        this.random = this.context.qsimConfig.getNumberOfThreads() > 1 ? MatsimRandom.getLocalInstance() : MatsimRandom.getRandom();
    }

    @Override
    public void init() {
        int i = 0;
        for (Link link : this.node.getInLinks().values()) {
            QNetwork network = this.netsimEngine.getNetsimNetwork();
            this.inLinksArrayCache[i] = network.getNetsimLinks().get(link.getId());
            ++i;
        }
        Arrays.sort(this.inLinksArrayCache, new Comparator<NetsimLink>(){

            @Override
            public int compare(NetsimLink o1, NetsimLink o2) {
                return o1.getLink().getId().compareTo(o2.getLink().getId());
            }
        });
    }

    @Override
    public boolean doSimStep(double now) {
        int inLinksCounter = 0;
        double inLinksCapSum = 0.0;
        for (QLinkI link : this.inLinksArrayCache) {
            if (link.isNotOfferingVehicle()) continue;
            this.tempLinks[inLinksCounter] = link;
            ++inLinksCounter;
            inLinksCapSum += link.getLink().getCapacity(now);
        }
        if (inLinksCounter == 0) {
            this.setActive(false);
            return false;
        }
        block1: for (int auxCounter = 0; auxCounter < inLinksCounter; ++auxCounter) {
            double rndNum = this.random.nextDouble() * inLinksCapSum;
            double selCap = 0.0;
            for (int i = 0; i < inLinksCounter; ++i) {
                QLinkI link = this.tempLinks[i];
                if (link == null || !((selCap += link.getLink().getCapacity(now)) >= rndNum)) continue;
                inLinksCapSum -= link.getLink().getCapacity(now);
                this.tempLinks[i] = null;
                this.moveLink(link, now);
                continue block1;
            }
        }
        return true;
    }

    private void moveLink(QLinkI link, double now) {
        for (QLaneI lane : link.getOfferingQLanes()) {
            QVehicle veh;
            while (!lane.isNotOfferingVehicle() && this.moveVehicleOverNode(veh = lane.getFirstVehicle(), link, lane, now)) {
            }
        }
    }

    private boolean moveVehicleOverNode(QVehicle veh, QLinkI fromLink, QLaneI fromLane, double now) {
        Id<Link> nextLinkId = veh.getDriver().chooseNextLinkId();
        Link currentLink = fromLink.getLink();
        TurnAcceptanceLogic.AcceptTurn turn = this.turnAcceptanceLogic.isAcceptingTurn(currentLink, fromLane, nextLinkId, veh, this.netsimEngine.getNetsimNetwork(), now);
        if (turn.equals((Object)TurnAcceptanceLogic.AcceptTurn.ABORT)) {
            this.moveVehicleFromInlinkToAbort(veh, fromLane, now, currentLink.getId());
            return true;
        }
        if (turn.equals((Object)TurnAcceptanceLogic.AcceptTurn.WAIT)) {
            return false;
        }
        QLinkI nextQueueLink = this.netsimEngine.getNetsimNetwork().getNetsimLinks().get(nextLinkId);
        QLaneI nextQueueLane = nextQueueLink.getAcceptingQLane();
        if (nextQueueLane.isAcceptingFromUpstream()) {
            this.moveVehicleFromInlinkToOutlink(veh, currentLink.getId(), fromLane, nextLinkId, nextQueueLane);
            return true;
        }
        if (this.vehicleIsStuck(fromLane, now)) {
            if (this.context.qsimConfig.isRemoveStuckVehicles()) {
                this.moveVehicleFromInlinkToAbort(veh, fromLane, now, currentLink.getId());
                return false;
            }
            this.moveVehicleFromInlinkToOutlink(veh, currentLink.getId(), fromLane, nextLinkId, nextQueueLane);
            return true;
        }
        return false;
    }

    private void moveVehicleFromInlinkToAbort(QVehicle veh, QLaneI fromLane, double now, Id<Link> currentLinkId) {
        fromLane.popFirstVehicle();
        this.context.getEventsManager().processEvent(new LinkLeaveEvent(now, veh.getId(), currentLinkId));
        for (PassengerAgent passengerAgent : veh.getPassengers()) {
            if (passengerAgent instanceof MobsimAgent) {
                ((MobsimAgent)((Object)passengerAgent)).setStateToAbort(now);
                this.netsimEngine.arrangeNextAgentState((MobsimAgent)((Object)passengerAgent));
                continue;
            }
            if (wrnCnt >= 1) continue;
            ++wrnCnt;
            log.warn("encountering PassengerAgent that cannot be cast into a MobsimAgent; cannot say if this is a problem");
            log.warn(" This message given only once.");
        }
        veh.getDriver().setStateToAbort(now);
        this.netsimEngine.arrangeNextAgentState(veh.getDriver());
    }

    private void moveVehicleFromInlinkToOutlink(QVehicle veh, Id<Link> currentLinkId, QLaneI fromLane, Id<Link> nextLinkId, QLaneI nextQueueLane) {
        double now = this.context.getSimTimer().getTimeOfDay();
        fromLane.popFirstVehicle();
        this.context.getEventsManager().processEvent(new LinkLeaveEvent(now, veh.getId(), currentLinkId));
        veh.getDriver().notifyMoveOverNode(nextLinkId);
        this.context.getEventsManager().processEvent(new LinkEnterEvent(now, veh.getId(), nextLinkId));
        nextQueueLane.addFromUpstream(veh);
    }

    private boolean vehicleIsStuck(QLaneI fromLaneBuffer, double now) {
        double stuckTime = this.context.qsimConfig.getStuckTime();
        return now - fromLaneBuffer.getLastMovementTimeOfFirstVehicle() > stuckTime;
    }

    public static class Builder {
        private final QNetsimEngine.NetsimInternalInterface netsimEngine;
        private final NetsimEngineContext context;
        private TurnAcceptanceLogic turnAcceptanceLogic = new DefaultTurnAcceptanceLogic();

        public Builder(QNetsimEngine.NetsimInternalInterface netsimEngine2, NetsimEngineContext context) {
            this.netsimEngine = netsimEngine2;
            this.context = context;
        }

        public final void setTurnAcceptanceLogic(TurnAcceptanceLogic turnAcceptanceLogic) {
            this.turnAcceptanceLogic = turnAcceptanceLogic;
        }

        public QNodeImpl build(Node n) {
            return new QNodeImpl(n, this.context, this.netsimEngine, this.turnAcceptanceLogic);
        }
    }
}

