/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.mobsim.framework.DriverAgent;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleCapacity;

public class QVehicleImpl
implements QVehicle {
    private static final Logger log = Logger.getLogger(QVehicleImpl.class);
    private static int warnCount = 0;
    private double linkEnterTime = 0.0;
    private double earliestLinkExitTime = 0.0;
    private DriverAgent driver = null;
    private Collection<PassengerAgent> passengers = null;
    private final Id<Vehicle> id;
    private Link currentLink = null;
    private final Vehicle vehicle;
    private final int passengerCapacity;

    public QVehicleImpl(Vehicle basicVehicle) {
        this.id = basicVehicle.getId();
        this.vehicle = basicVehicle;
        this.passengers = new ArrayList<PassengerAgent>();
        VehicleCapacity capacity = basicVehicle.getType().getCapacity();
        if (capacity == null) {
            this.passengerCapacity = 4;
            if (warnCount < 10) {
                log.warn("No VehicleCapacity (= maximum number of passengers) set in Vehicle. Using default value of 4.  This is only a problem if you need vehicles with different capacities, e.g. for minibuses.");
                if (++warnCount == 10) {
                    log.warn(" Future occurences of this logging statement are suppressed.");
                }
            }
        } else {
            this.passengerCapacity = capacity.getSeats() + (capacity.getStandingRoom() == null ? 0 : capacity.getStandingRoom());
        }
    }

    @Override
    public void setCurrentLink(Link link) {
        this.currentLink = link;
    }

    @Override
    public double getEarliestLinkExitTime() {
        return this.earliestLinkExitTime;
    }

    @Override
    public void setEarliestLinkExitTime(double time) {
        this.earliestLinkExitTime = time;
    }

    @Override
    public Link getCurrentLink() {
        return this.currentLink;
    }

    @Override
    public MobsimDriverAgent getDriver() {
        if (this.driver instanceof MobsimDriverAgent) {
            return (MobsimDriverAgent)this.driver;
        }
        if (this.driver == null) {
            return null;
        }
        throw new RuntimeException("error (downstream methods need to be made to accept DriverAgent)");
    }

    @Override
    public void setDriver(DriverAgent driver) {
        if (driver != null && this.driver != null && !this.driver.getId().equals(driver.getId())) {
            throw new RuntimeException("A driver (" + this.driver.getId() + ") " + "is already set in vehicle " + this.getId() + ". " + "Setting agent " + driver.getId().toString() + " is not possible!");
        }
        this.driver = driver;
    }

    @Override
    public Id<Vehicle> getId() {
        return this.id;
    }

    @Override
    public double getSizeInEquivalents() {
        return this.vehicle.getType().getPcuEquivalents();
    }

    @Override
    public double getFlowCapacityConsumptionInEquivalents() {
        return this.vehicle.getType().getPcuEquivalents() / this.vehicle.getType().getFlowEfficiencyFactor();
    }

    @Override
    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public String toString() {
        return "Vehicle Id " + this.getId() + ", driven by (personId) " + this.driver.getId() + ", on link " + this.currentLink.getId();
    }

    @Override
    public double getMaximumVelocity() {
        return this.vehicle.getType().getMaximumVelocity();
    }

    @Override
    public Collection<? extends PassengerAgent> getPassengers() {
        return Collections.unmodifiableCollection(this.passengers);
    }

    @Override
    public boolean addPassenger(PassengerAgent passenger) {
        if (this.passengers.size() < this.passengerCapacity) {
            return this.passengers.add(passenger);
        }
        return false;
    }

    @Override
    public boolean removePassenger(PassengerAgent passenger) {
        return this.passengers.remove(passenger);
    }

    @Override
    public int getPassengerCapacity() {
        return this.passengerCapacity;
    }

    @Override
    public final double getLinkEnterTime() {
        return this.linkEnterTime;
    }

    @Override
    public final void setLinkEnterTime(double linkEnterTime) {
        this.linkEnterTime = linkEnterTime;
    }
}

