/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Collection;
import javax.inject.Inject;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;
import org.matsim.vis.snapshotwriters.VisVehicle;

class QueueAgentSnapshotInfoBuilder
extends AbstractAgentSnapshotInfoBuilder {
    @Inject
    QueueAgentSnapshotInfoBuilder(Scenario scenario, SnapshotLinkWidthCalculator linkWidthCalculator) {
        super(scenario, linkWidthCalculator);
    }

    @Override
    public double calculateVehicleSpacing(double curvedLength, double overallStorageCapacity, Collection<? extends VisVehicle> vehs) {
        double sum = 0.0;
        for (VisVehicle visVehicle : vehs) {
            sum += visVehicle.getSizeInEquivalents();
        }
        double vehLen = Math.min(curvedLength / overallStorageCapacity, curvedLength / sum);
        return vehLen;
    }

    @Override
    public double calculateOdometerDistanceFromFromNode(double curvedLength, double spacing, double lastDistanceFromFNode, double now, double freespeedTraveltime, double remainingTravelTime) {
        double distanceFromFNode;
        boolean isFirstVehicle = false;
        if (freespeedTraveltime == 0.0) {
            distanceFromFNode = 0.0;
        } else {
            distanceFromFNode = (1.0 - remainingTravelTime / freespeedTraveltime) * curvedLength;
            if (distanceFromFNode < 0.0) {
                distanceFromFNode = 0.0;
            }
        }
        if (Double.isNaN(lastDistanceFromFNode)) {
            isFirstVehicle = true;
            lastDistanceFromFNode = curvedLength;
        }
        if (isFirstVehicle && distanceFromFNode >= lastDistanceFromFNode) {
            distanceFromFNode = lastDistanceFromFNode;
        } else if (distanceFromFNode >= lastDistanceFromFNode - spacing) {
            distanceFromFNode = lastDistanceFromFNode - spacing;
        }
        return distanceFromFNode;
    }
}

